/***************************************************************************
 *                                                                         *
 * File      : touchtest.h                                                 *
 * Comment   : touchtest program global structures                         *
 * Copyright : (c) CBD BC, 2007                                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TOUCHTEST_H_INCLUDED
#define TOUCHTEST_H_INCLUDED

#define TEST1_PASSED	0x01
#define TEST2_PASSED    0x02
#define TEST3_PASSED	0x04
#define TEST4_PASSED    0x08

typedef struct {

	int			sct_active_buttons;		// test 1 - active buttons counter

	int			draw_clear;				// clear draw_raw area flag
	PhPoint_t	draw_point1;			// line first point
	PhPoint_t	draw_point2;            // line last point
	
	int			draw_unrelease;         // button press flag

	PhArea_t	left_rect;				// left rect coordinates
	PhArea_t	right_rect;				// right rect coordinates

	int			drag_start;				// start drag form left rect into right rect (test4)
		
	char		passed_tests;			// passed tests counter
} touchtest_t;

extern touchtest_t	tt_data;

#endif
