/***************************************************************************
 *                                                                         *
 * File      : draw_func.c                                                 *
 * Comment   : draw_raw draw function                                	   *	
 * Copyright : (c) CBD BC, 2007                              			   *		
 *                                                                         *
 ***************************************************************************/

/* AppBuilder Photon Code Lib      Version 1.14C */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Toolkit headers */
#include <Ph.h>
#include <Pt.h>
#include <Ap.h>

/* Local headers */
#include "abimport.h"
#include "proto.h"
#include "touchtest.h"

// draw_raw - draw function ( Pt_ARG_RAW_DRAW_F )
void draw_func( PtWidget_t *widget, PhTile_t *damage )  
{

	if ( tt_data.draw_clear ) {
		PtSuperClassDraw( PtBasic, widget, damage );
		if ( tt_data.passed_tests != 15 )		
			tt_data.draw_clear = 0;
	}		
	else {
		PgSetStrokeWidth( 3 );
		PgSetStrokeColor( Pg_BLACK );

		PgDrawLine( &tt_data.draw_point1, &tt_data.draw_point2 );
	}
}
