	/***************************************************************************
 *                                                                         *
 * File      : calls.c                                                     *
 * Comment   : touchtest program callbacks handlers                  	   *	
 * Copyright : (c) CBD BC, 2007                              			   *		
 *                                                                         *
 ***************************************************************************/


/* AppBuilder Photon Code Lib    Version 1.14C */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Toolkit headers */
#include <Ph.h>
#include <Pt.h>
#include <Ap.h>

/* Local headers */
#include "abimport.h"
#include "proto.h"
#include "touchtest.h"

// prototypes for additional functions
int	display_curspos( unsigned short input_group );
int display_status( void );
int	reset_test_results( void );
int clear_draw_area( void );

// global variables
touchtest_t		tt_data;


// main_wnd - Pt_CB_WINDOW_OPENING callback
int mainwnd_opening( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[1];
	PhArea_t	*rect_area;
	
	tt_data.sct_active_buttons = 1;
	tt_data.draw_clear = 1;
	

	PtSetArg( &args[0], Pt_ARG_AREA, &rect_area, 0 );
	PtGetResources( ABW_left_rect, 1, args );
	tt_data.left_rect = *rect_area;

	PtSetArg( &args[0], Pt_ARG_AREA, &rect_area, 0 );
	PtGetResources( ABW_right_rect, 1, args );
	tt_data.right_rect = *rect_area;
	
	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// sct1_bt - Pt_CB_ACTIVATE callback
int sct1bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];
	
	if ( tt_data.sct_active_buttons  == 1 )	{
		PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_FALSE, Pt_GHOST );
		PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_TRUE, Pt_SELECTABLE );
		
		PtSetResources( ABW_sct2_bt, 2, args );
		tt_data.sct_active_buttons++;
	}		
	display_curspos( cbinfo->event->input_group );
	
	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}


// sct2_bt - Pt_CB_ACTIVATE callback
int sct2bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];

	if ( tt_data.sct_active_buttons  == 2 )	{
		PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_FALSE, Pt_GHOST );
		PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_TRUE, Pt_SELECTABLE );
	
		PtSetResources( ABW_sct3_bt, 2, args );
		tt_data.sct_active_buttons++;
	}		
	display_curspos( cbinfo->event->input_group );

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// sct3_bt - Pt_CB_ACTIVATE callback
int sct3bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];

	if ( tt_data.sct_active_buttons  == 3 )	{
		PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_FALSE, Pt_GHOST );
		PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_TRUE, Pt_SELECTABLE );
	
		PtSetResources( ABW_sct4_bt, 2, args );
		tt_data.sct_active_buttons++;
	}		
	display_curspos( cbinfo->event->input_group );

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// sct4_bt - Pt_CB_ACTIVATE callback
int sct4bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];

	if ( tt_data.sct_active_buttons  == 4 )	{
		PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_FALSE, Pt_GHOST );
		PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_TRUE, Pt_SELECTABLE );
		
		PtSetResources( ABW_sct5_bt, 2, args );
		tt_data.sct_active_buttons++;
	}		
	display_curspos( cbinfo->event->input_group );

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// sct5_bt - Pt_CB_ACTIVATE callback
int sct5bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];

	if ( tt_data.sct_active_buttons  == 5 )	{
		PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_FALSE, Pt_GHOST );
		PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_TRUE, Pt_SELECTABLE );
	
		PtSetResources( ABW_sct6_bt, 2, args );
		tt_data.sct_active_buttons++;
	}		
	display_curspos( cbinfo->event->input_group );

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// sct6_bt - Pt_CB_ACTIVATE callback
int sct6bt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t		args[2];
	
	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct2_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct3_bt, 2, args );
	

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct4_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct5_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct6_bt, 2, args );
	
	tt_data.sct_active_buttons = 1;

	display_curspos( cbinfo->event->input_group );
	
	tt_data.passed_tests |= TEST1_PASSED;
	display_status();
	
	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// dct_bt - Pt_CB_RAW callback ( Ph_EV_BUT_PRESS | Ph_EV_BUT_RELEASE )
int dctbt_buttpress( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t					args[1];
	PhCursorInfo_t			cbuf;

	if ( cbinfo->event->type == Ph_EV_BUT_PRESS ) {
		PhQueryCursor( cbinfo->event->input_group, &cbuf );		
		if ( cbuf.click_count == 2 ) {
			PtSetArg( &args[0], Pt_ARG_FILL_COLOR, 0, 0 );
			PtGetResources( ABW_dct_bt, 1 ,&args[0] );

			if ( args[0].value == Pg_GREEN ) {

				PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_TRANSPARENT, 0 );
			}
			else {
		
				PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GREEN, 0 );
			}
			PtSetResources( ABW_dct_bt, 1, args );
			display_curspos( cbinfo->event->input_group );
			tt_data.passed_tests |= TEST2_PASSED;
			display_status();
		}
	}

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// cat_cb - Pt_CB_SELECTION callback
int catcb_selection( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PtArg_t				args[1];	
	PtListCallback_t	*cd = cbinfo->cbdata;
	
	PtSetArg( &args[0], Pt_ARG_TEXT_STRING, cd->item, 0 );
	PtSetResources( ABW_cat_lbl, 1, args );

	display_curspos( cbinfo->event->input_group );

	tt_data.passed_tests |= TEST3_PASSED;

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// catdone_bt - Pt_CB_ACTIVATE callback
int catdonebt_activate( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	if ( tt_data.passed_tests & TEST3_PASSED )
		display_status();

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// draw_raw - Pt_CB_RAW ( Ph_EV_BUT_PRESS | Ph_EV_BUT_RELEASE | Ph_EV_PTR_MOTION_BUTTON )
int drawraw_rawevent( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{
	PhRect_t		*rect;
	PtArg_t			args[1];
	
	if ( cbinfo->event->type == Ph_EV_BUT_PRESS ) {
		tt_data.draw_unrelease = 1;
		rect = PhGetRects( cbinfo->event );
		tt_data.draw_point1 = tt_data.draw_point2 = rect->ul;
		if ( rect->ul.x > tt_data.left_rect.pos.x &&
			 rect->ul.x < tt_data.left_rect.pos.x + tt_data.left_rect.size.w &&
			 rect->ul.y > tt_data.left_rect.pos.y && 
			 rect->ul.y < tt_data.left_rect.pos.y + tt_data.left_rect.size.h )	{
			
			tt_data.drag_start = 1;	
			PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GREEN, 0 );
			PtSetResources( ABW_left_rect, 1, args );
		}

		display_curspos( cbinfo->event->input_group );
	}
	
	if ( cbinfo->event->type == Ph_EV_PTR_MOTION_BUTTON ) {
		if ( tt_data.draw_unrelease ) {
			tt_data.draw_point1 = tt_data.draw_point2;
			rect = PhGetRects( cbinfo->event );
			tt_data.draw_point2 = rect->ul;
			display_curspos( cbinfo->event->input_group );
			
					
			PtDamageWidget( ABW_draw_raw );
		}			
	}

	if ( cbinfo->event->type == Ph_EV_BUT_RELEASE ) {
		if ( cbinfo->event->subtype == Ph_EV_RELEASE_REAL ) {
			 tt_data.draw_unrelease = 0;
			 rect = PhGetRects( cbinfo->event );
			 
			if ( rect->ul.x > tt_data.right_rect.pos.x &&
				 rect->ul.x < tt_data.right_rect.pos.x + tt_data.right_rect.size.w &&
				 rect->ul.y > tt_data.right_rect.pos.y && 
				 rect->ul.y < tt_data.right_rect.pos.y + tt_data.right_rect.size.h &&
				 tt_data.drag_start )	{
	
				PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GREEN, 0 );
				PtSetResources( ABW_right_rect, 1, args );
				tt_data.passed_tests |= TEST4_PASSED;				
	 			display_status();
				
			}
			else {
				PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GRAY, 0 );
				PtSetResources( ABW_left_rect, 1, args );
				PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GRAY, 0 );
				PtSetResources( ABW_right_rect, 1, args );
				
			}
			tt_data.drag_start = 0;
		}

		display_curspos( cbinfo->event->input_group );
	}
	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}

// drawclear_bt - Pt_CB_ACTIVATE callback
int drawclear_bt( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )
{

	clear_draw_area();

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	return( Pt_CONTINUE );

}


// additional functions

// dispaly in status bar current cursor position coordinates
int	display_curspos( unsigned short input_group )
{
	PtArg_t				args[1];
	PhCursorInfo_t		cbuf;
	char				pos_str[10];	
	

	PhQueryCursor( input_group, &cbuf );		
	
	PtSetArg( args, Pt_ARG_TEXT_STRING, itoa( cbuf.pos.x, pos_str, 10 ), 0 );	
	PtSetResources( ABW_posx_lbl, 1, args );
	
	PtSetArg( args, Pt_ARG_TEXT_STRING,itoa( cbuf.pos.y, pos_str, 10 ), 0 );	
	PtSetResources( ABW_posy_lbl, 1, args );
	
	return ( 0 );
}

// display in status bar current test progress
int display_status( void )
{
	PtArg_t		args[1];
	char		tmp_str[10] = " ";
	
	if ( tt_data.passed_tests & TEST1_PASSED ) 
		strcat( tmp_str, "1" );			
	
	if ( tt_data.passed_tests & TEST2_PASSED ) 
		strcat( tmp_str, " 2" );			

	if ( tt_data.passed_tests & TEST3_PASSED ) 
		strcat( tmp_str, " 3" );			
	
	if ( tt_data.passed_tests & TEST4_PASSED ) 
		strcat( tmp_str, " 4" );			
		
	PtSetArg( args, Pt_ARG_TEXT_STRING, tmp_str, 0 );	
	PtSetResources( ABW_passedtst_lbl, 1, args );
	
	// show message window
	if ( tt_data.passed_tests == 15 ) {

		tt_data.draw_clear = 1;
		switch ( PtAskQuestion( ABW_main_wnd, "Tests passed", 
					            "  All tests successfully completed!\nTry again? ",
								"helv12", "&Yes", "&Exit", NULL, 1 ) ) {

			case 1:
				tt_data.passed_tests = 0;					   
				strcpy( tmp_str, " ");
		
				PtSetArg( args, Pt_ARG_TEXT_STRING, tmp_str, 0 );	
				PtSetResources( ABW_passedtst_lbl, 1, args );
				
				reset_test_results();
				
				break;
				
			case 2:
				exit ( 0 );
				break;								
		}								
	}
		
	return ( 0 );
}

// clear draw area (test 4)
int clear_draw_area( void )
{
	PtArg_t		args[1];
	PhRect_t	raw_canvas;
	
	
	tt_data.draw_clear = 1;
	

	PtWidgetCanvas( ABW_draw_pane, &raw_canvas );
	PtDamageExtent( ABW_draw_pane, &raw_canvas );
	PtFlush();
	

	PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GRAY, 0 );
	PtSetResources( ABW_left_rect, 1, args );
			
	PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_GRAY, 0 );
	PtSetResources( ABW_right_rect, 1, args );
	tt_data.drag_start = 0;

	return ( 0 );
}

// reset test results
int	reset_test_results( void )
{
	PtArg_t		args[2];
	
	// reset first test
	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct2_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct3_bt, 2, args );
	

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct4_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct5_bt, 2, args );

	PtSetArg( &args[0], Pt_ARG_FLAGS, Pt_TRUE, Pt_GHOST );
	PtSetArg( &args[1], Pt_ARG_FLAGS, Pt_FALSE, Pt_SELECTABLE );
	PtSetResources( ABW_sct6_bt, 2, args );
	
	tt_data.sct_active_buttons = 1;
	
	// reset second test
	PtSetArg( &args[0], Pt_ARG_FILL_COLOR, Pg_TRANSPARENT, 0 );
	PtSetResources( ABW_dct_bt, 1, args );
	
	// reset third test
	PtSetArg( args, Pt_ARG_TEXT_STRING, " ", 0 );	
	PtSetResources( ABW_cat_lbl, 1, args );
	
	PtSetArg( args, Pt_ARG_TEXT_STRING, "First element", 0 );	
	PtSetResources( ABW_cat_cb, 1, args );

	// reset fourth test
	clear_draw_area();

	return ( 0 );	
	
}

