/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 23/11/2009
 * Dev:  A. Docuchaev
 */


/* main.c */


#include <ioadm.h>
#include <l783m_msg.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <devctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/dispatch.h>


ioadm_device_t              l783m = IOADM_DEVICE_INIT;
char                        device[6] = "l783m";
int                         pci_index = 0;


void parse_options( int argc, char *argv[] )
{
    int                 c;

    while (-1 != (c = getopt(argc, argv, "i:"))) {
        switch (c) {
            case 'i':
                pci_index = strtoul( optarg, 0, 0 );
                break;
            default:
                printf( "Error: Undefined option \"-%c\"\n", c );
                exit( -1 );
        }
    }
}


int main( int argc, char *argv[] )
{
    l783m_msg_channel_t     ch_msg;
    l783m_buff_info_t       bi;
    int                     i;
    struct timespec         start[10],
                            stop[10];
    double                  interval;
    uint8_t                 dt[8 * 350 * 2];
    int                     sz;
    uint16_t                *ptr   = NULL;
    struct sched_param      sched_param;

    parse_options( argc, argv );

    sched_param.sched_priority = 70;
    pthread_setschedparam( pthread_self(), SCHED_RR, &sched_param );

    /* Try to open device l783m */
    if ( ioadm_open_pci( &l783m, device, pci_index ) ) {
        printf( "Error: can't open device\n" );
        exit( -1 );
    }

    /* Set channels number */
    if ( ioadm_set_channels_number( &l783m, 1 ) ) {
        printf( "Error: can't set channel number\n" );
        exit( -1 );
    }

    /* Set channels */
    ch_msg.index = 0;
    ch_msg.mode  = L783M_CHANNEL_SINGLE_ENDED;
    ch_msg.input = 0;
    ch_msg.gain  = 0;
    if ( ioadm_custom_dcmd( &l783m, DCMD_IOADM_SET_CHANNEL, (void *)&ch_msg, sizeof( ch_msg ) ) != 0 ) {
        printf( "Error: can't set channel's metric\n" );
        exit( -1 );
    }

    /* Set buffer size */
    bi.frag_sz = 8 * 350 * 2;
    bi.buf_sz  = 0; /* Max */
    if ( ioadm_set_buff( &l783m, (void *)&bi, sizeof( bi ) ) != 0 ) {
        printf( "Error: can't set buffer\n" );
        exit( -1 );
    }

    /* Set frame rate */
    /*if ( ioadm_set_frame_rate( &l783m, 100000 ) != 0 ) {
        printf( "Error: can't set frame rate\n" );
        exit( -1 );
    }*/

    {
        l783m_msg_timing_params_t   tp;
            tp.channel_rate = 8 * 100 * 1000;
            tp.frame_rate   = 0;

        if ( ioadm_set_timing( &l783m, &tp, sizeof( tp ) ) != 0 ) {
            printf( "Error: can't set timing parameters\n" );
            exit( -1 );
        }
    }

    /* Set calibration multipliers */
    if ( ioadm_set_calibration_multipliers( &l783m, NULL, 0 ) != 0 ) {
        printf( "Error: can't set calibration multipliers\n" );
        exit( -1 );
    }

    /* Enable calibration */
    if ( ioadm_enable_calibration( &l783m, 1 ) != 0 ) {
        printf( "Error: can't enable calibration\n" );
        exit( -1 );
    }

    /* Prepare lib to I/O operations */
    if ( ioadm_lib_prepare_io( &l783m ) != 0 ) {
        printf( "Error: can't prepare lib-i/o\n" );
        exit( -1 );
    }

    /* Start ADC */
    if ( ioadm_start( &l783m, 0 ) != 0 ) {
        printf( "Error: can't start ADC\n" );
        exit( -1 );
    }

    /* Read data */
    for ( i = 0; i < 10; i++ ) {

        clock_gettime( CLOCK_REALTIME, &start[i] );

        sz = ioadm_read_fragment_wc( &l783m, (void *)&ptr );
        memcpy( &dt[0], ptr, sz );

        clock_gettime( CLOCK_REALTIME, &stop[i] );

    }

    /* Stop ADC */
    if ( ioadm_stop( &l783m, 0 ) != 0 ) {
        printf( "Error: can't start ADC\n" );
        exit( -1 );
    }

    for ( i = 0; i < 10; i++ ) {

        interval = (stop[i].tv_sec - start[i].tv_sec) + 
                   (double)(stop[i].tv_nsec - start[i].tv_nsec) / (double)(1000000000L);
        printf( "Read time: %f ms\n", interval * 1000 );
        /*if ( i == 0 ) {
            int t = 0;
            for ( t = 0; t < 8 * 350; t+=2 ) {
                printf( "  %.2x%.2x", dt[t], dt[t+1] );
                if ( t % 32 == 0 && t != 0 )
                    printf( "\n" );
            }
            printf( "\n" );
        }*/

    }
    printf( "Time between 2 interrupts: %f\n", ioadm_get_b2int_time( &l783m ) );
    printf( "Read time: %f\n", ioadm_get_read_time( &l783m ) );
    printf( "Received data size: %lld\n", ioadm_get_received_data_sz( &l783m ) );
    printf( "Readed data size: %lld\n", ioadm_get_readed_data_sz( &l783m ) );

    ioadm_close( &l783m );

    return (0);
}
