/* Y o u r   D e s c r i p t i o n                       */
/*                            AppBuilder Photon Code Lib */
/*                                         Version 2.03  */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Local headers */
#include "ablibs.h"
#include "abimport.h"
#include "proto.h"

#include "my.h"

int			    	draw_pos = 0;

void draw_gr( uint8_t *ptr, int pos, int max )
{

    int                     	i = 0;
    uint16_t			*ptr2 = (uint16_t *)&ptr[(pos - 1) * 5600];
    char		    	txt[10];
    l783m_msg_sample_ranges_t	sr;
    double scale;
    int x, c, cu, u;

    /* Get sample ranges */
    sr.gain = 0;
    if ( ioadm_get_sample_ranges( &l783m, (void *)&sr, sizeof(l783m_msg_sample_ranges_t) ) != 0 ) {
        LOG( "Error: can't get sample ranges\n" );
        return;
    }
    scale = (sr.u_max - sr.u_min);
    scale /= (sr.sample_val_max - sr.sample_val_min);
    c = (sr.sample_val_min + sr.sample_val_max) / 2;
    cu = (sr.u_min + sr.u_max) / 2;

    sprintf( txt, "%i", pos );
    PtSetResource( ABW_PtLabel40, Pt_ARG_TEXT_STRING, txt, 0 );
    sprintf( txt, "%i", max );
    PtSetResource( ABW_PtLabel41, Pt_ARG_TEXT_STRING, txt, 0 );
    PtReRealizeWidget( ABW_PtLabel41 );
    PtReRealizeWidget( ABW_PtLabel40 );
    PtFlush();

    for ( i = 0; i < 5600 / 2; i++ ) {

        x = (int)(short int)ptr2[i];

        u = (x - c) * scale + cu;
        u = (double)u / (double)1000;	/* mV */

        PtMTrendChangeData( ABW_PtMTrend1, 0, &u, i, 1 );

    }

    return;

}
