/* Y o u r   D e s c r i p t i o n                       */
/*                            AppBuilder Photon Code Lib */
/*                                         Version 2.03  */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Local headers */
#include "ablibs.h"
#include "abimport.h"
#include "proto.h"

#include "my.h"

int
Timer1Timer( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )

	{

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	if ( timer1_st ) {
	
	    unsigned int state = ioadm_get_state( &l783m );
	    
	    if ( state & DEVICE_STATE_READY )
		ck_set( ABW_PtToggleButton1 )
	    else
		ck_unset( ABW_PtToggleButton1 )

	    if ( state & DEVICE_STATE_IRQ_ENABLED )
		ck_set( ABW_PtToggleButton2 )
	    else
		ck_unset( ABW_PtToggleButton2 )

	    if ( state & DEVICE_STATE_STARTED )
		ck_set( ABW_PtToggleButton3 )
	    else
		ck_unset( ABW_PtToggleButton3 )		

	    if ( state & DEVICE_STATE_DETECTED )
		ck_set( ABW_PtToggleButton4 )
	    else
		ck_unset( ABW_PtToggleButton4 )

	    if ( state & DEVICE_STATE_INITED )
		ck_set( ABW_PtToggleButton5 )
	    else
		ck_unset( ABW_PtToggleButton5 )

	    if ( state & DEVICE_STATE_MEM_ALLOCATED )
		ck_set( ABW_PtToggleButton6 )
	    else
		ck_unset( ABW_PtToggleButton6 )
		
	    unsigned long long sz = ioadm_get_received_data_sz( &l783m );
	    char	       text[255];
	    sprintf( text, "%lld", sz );
	    PtSetResource( ABW_PtLb1, Pt_ARG_TEXT_STRING, text, 0 );

	    sz = ioadm_get_readed_data_sz( &l783m );
	    sprintf( text, "%lld", sz );
	    PtSetResource( ABW_PtLb2, Pt_ARG_TEXT_STRING, text, 0 );

	} else {

	    ck_unset( ABW_PtToggleButton1 )
	    ck_unset( ABW_PtToggleButton2 )
	    ck_unset( ABW_PtToggleButton3 )
	    ck_unset( ABW_PtToggleButton4 )
	    ck_unset( ABW_PtToggleButton5 )
	    ck_unset( ABW_PtToggleButton6 )

	}

	return( Pt_CONTINUE );

	}

