/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 05/10/2010
 * Dev:  A. Docuchaev
 */


/* main.c */


#include <ioadm.h>
#include <piod64_msg.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <devctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/dispatch.h>


ioadm_device_t              piod64 = IOADM_DEVICE_INIT;
char                        device[7] = "piod64";
int                         pci_index = 0;


void parse_options( int argc, char *argv[] )
{
    int                 c;

    while (-1 != (c = getopt(argc, argv, "i:"))) {
        switch (c) {
            case 'i':
                pci_index = strtoul( optarg, 0, 0 );
                break;
            default:
                printf( "Error: Undefined option \"-%c\"\n", c );
                exit( -1 );
        }
    }
}


int main( int argc, char *argv[] )
{
    int                     i;
    int                     sz;
    uint32_t                rdata;
    struct sched_param      sched_param;
    unsigned long long      tmp;

    parse_options( argc, argv );

    sched_param.sched_priority = 70;
    pthread_setschedparam( pthread_self(), SCHED_FIFO, &sched_param );

    /* Try to open device piod64 */
    if ( ioadm_open_pci( &piod64, device, pci_index ) ) {
        printf( "Error: can't open device\n" );
        exit( -1 );
    }

    /* Prepare lib to I/O operations */
    if ( ioadm_lib_prepare_io( &piod64 ) != 0 ) {
        printf( "Error: can't prepare lib-i/o\n" );
        exit( -1 );
    }

    /* Enable EXTIRQ source */
    if ( ioadm_set_irq_sources( &piod64, PIOD64_IRQ_SOURCE_EXTIRQ ) != 0 ) {
        printf( "Error: can't activate EXTIRQ\n" );
        exit( -1 );
    }

    /* Set positive EXTIRQ polarity (all other IRQ sources set to negative polarity value) */
    if ( ioadm_set_irq_polarity( &piod64, PIOD64_IRQ_POSITIVE_POLARITY_EXTIRQ ) != 0 ) {
        printf( "Error: can't set EXTIRQ polarity\n" );
        exit( -1 );
    }

    /* Start piod64 */
    if ( ioadm_start( &piod64, 0 ) != 0 ) {
        printf( "Error: can't start device\n" );
        exit( -1 );
    }

    /* Read data (1) */
    for ( i = 0; i < 10; i++ ) {

        /* Waiting for EXTIRQ event */
        if ( ioadm_wait_irq_event( &piod64 ) != 0 ) {
            printf( "Error: can't identify IRQ event\n" );
            exit( -1 );
        }
        sz = ioadm_read( &piod64, &rdata, sizeof( rdata ) );

    }
    tmp = ioadm_get_readed_data_sz( &piod64 );
    printf( "1. Readed data size:                      %lldb\n", tmp );
    printf( "   Read cycles:                           %lld\n",  tmp / 4 );

    /* Read data (2) */
    ioadm_clear_statistic( &piod64 );
    sleep( 5 );
    tmp = ioadm_get_received_data_sz( &piod64 );
    printf( "2. Received data size (with 5 sec delay): %lldb\n", tmp );
    printf( "   IRQ count (with 5 sec delay):          %lld\n",  tmp / 4 );

    printf( "3. Time between 2 interrupts:             %f sec\n", ioadm_get_b2int_time( &piod64 ) );
    printf( "4. Read time (4 bytes):                   %f sec\n", ioadm_get_read_time( &piod64 ) );
    printf( "   Write time (4 bytes):                  %f sec\n", ioadm_get_write_time( &piod64 ) );

    /* Stop piod64 */
    if ( ioadm_stop( &piod64, 0 ) != 0 ) {
        printf( "Error: can't start device\n" );
        exit( -1 );
    }

    ioadm_close( &piod64 );

    return (0);
}
