/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 11/01/2010
 * Dev:  A. Docuchaev
 */


/* drvpool.c */


#include "io-adm-internal.h"


void io_adm_drv_init( struct io_adm_driver *drv )
{
    sprintf( drv->devname, "%s%u", drv->dll_name, drv->drv_descriptor->device_idx );

    drv->loaded = 1;
}

void *io_adm_drv_thread( void *drv_ )
{
    io_adm_t                *io_adm = drv_;
    int                     i = io_adm->drv_index;
    char                    dev[100];
    dispatch_t              *dpp;
    resmgr_attr_t           resmgr_attr;
    resmgr_context_t        *ctp;
    resmgr_connect_funcs_t  connect_funcs;
    resmgr_io_funcs_t       io_funcs;
    iofunc_attr_t           attr;
    int                     id;

    if ( !(io_adm->dll_desc[i].drv_descriptor = 
           (io_adm_drv_descriptor_t *)io_adm->dll_desc[i].drv_init( io_adm->dll_desc[i].dll_options )) ) {
        io_adm->t_error = 1;
        return (NULL);
    }

    /* Register resource manager */
    {
        /* Initialize dispatch interface */
        if ( (dpp = dispatch_create()) == NULL ) {
            MSG( ERRF, "Error: Unable to allocate thread's dispatch handle\n" );
            exit( -1 );
        }

        /* Initialize resource manager attributes */
        memset( &resmgr_attr, 0, sizeof resmgr_attr );
        resmgr_attr.nparts_max = 1;
        resmgr_attr.msg_max_size = 2048;

        /* Initialize functions for handling messages */
        iofunc_func_init( _RESMGR_CONNECT_NFUNCS, &connect_funcs,
                          _RESMGR_IO_NFUNCS, &io_funcs );

        /* Override functions */
        connect_funcs.open = io_adm_open;
        io_funcs.close_dup = io_adm_close;
        io_funcs.read      = io_adm_read;
        io_funcs.write     = io_adm_write;
        io_funcs.stat      = io_adm_stat;
        io_funcs.devctl    = io_adm_devctl;

        /* Initialize attribute structure */
        iofunc_attr_init( &attr, S_IFREG | 0777, 0, 0 );
        attr.inode  = i;
        attr.nbytes = /*io_adm->mem_sz*/IO_ADM_MAX_DEVICE_COUNT;

        /* Attach device name */
        sprintf( dev, "/dev/io-adm/%s%u", io_adm->dll_desc[i].dll_name, io_adm->dll_desc[i].drv_descriptor->device_idx );
        if ( (id = resmgr_attach( dpp, &resmgr_attr,
                                  dev, _FTYPE_ANY, _RESMGR_FLAG_BEFORE, &connect_funcs,
                                  &io_funcs, &attr)) == -1 ) {
            MSG( ERRF, "Error: Unable to attach thread's name\n" );
            exit( -1 );
        }

        /* Allocate a context structure */
        ctp = resmgr_context_alloc( dpp );
    }

    /* Start the resource manager message loop */
    while ( 1 ) {
        if ( (ctp = resmgr_block( ctp )) == NULL )
            exit( -1 );

        resmgr_handler( ctp );
    }
}

int io_adm_drv_open( resmgr_context_t *ctp, io_open_t *msg, RESMGR_HANDLE_T *handle, void *extra, struct io_adm_driver *drv_ )
{
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( drv->blocked )
        return (ENOMEM);

    drv->blocked = 1;

    if ( drv->drv_descriptor->io_adm_drv_open )
        if ( drv->drv_descriptor->io_adm_drv_open(
           (void *)drv->drv_descriptor ) != 0 )
            return (EINVAL);

    return iofunc_open_default( ctp, msg, handle, extra );
}

int io_adm_drv_close( resmgr_context_t *ctp, io_close_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    drv->blocked = 0;

    if ( drv->drv_descriptor->io_adm_drv_close )
        drv->drv_descriptor->io_adm_drv_close(
                    (void *)drv->drv_descriptor );

    return iofunc_close_dup_default( ctp, msg, ocb );
}

int io_adm_drv_read( resmgr_context_t *ctp, io_read_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status      = iofunc_read_verify( ctp, msg, ocb, NULL );
    int                     nbytes      = 0;
    void                    *io_adm_msg = (void *)((int)msg + 16);
    struct io_adm_driver    *drv        = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0) ||
         ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) )
        return ( EACCES );

    if ( status != EOK )
        return status;

    if ( (msg->i.xtype & _IO_XTYPE_MASK) != _IO_XTYPE_NONE )
        return (ENOSYS);

    if ( !drv->drv_descriptor->io_adm_drv_read )
        return (EINVAL);

    status = drv->drv_descriptor->io_adm_drv_read( (void *)drv->drv_descriptor,
                                                   io_adm_msg,
                                                   msg->i.nbytes );

    if ( status == 0 )
        return (EINVAL);

    nbytes = min( msg->i.nbytes, status );
    nbytes = min( nbytes, ocb->attr->nbytes - ocb->offset );

    if ( nbytes > 0 ) {

        SETIOV( ctp->iov, io_adm_msg, nbytes );
        _IO_SET_READ_NBYTES( ctp, nbytes );

    } else
        _IO_SET_READ_NBYTES( ctp, 0 );

    if ( msg->i.nbytes > 0 )
        ocb->attr->flags |= IOFUNC_ATTR_ATIME;

    if ( nbytes > 0 )
        return (_RESMGR_NPARTS( 1 ));
    else
        return (_RESMGR_NPARTS( 0 ));
}

int io_adm_drv_write( resmgr_context_t *ctp, io_write_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status      = iofunc_write_verify( ctp, msg, ocb, NULL );
    void                    *io_adm_msg = (void *)((int)msg + 16);
    struct io_adm_driver    *drv        = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0) ||
         ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) )
        return ( EACCES );

    if ( status != EOK )
        return status;

    if ( (msg->i.xtype & _IO_XTYPE_MASK) != _IO_XTYPE_NONE )
        return (ENOSYS);

    if ( !drv->drv_descriptor->io_adm_drv_write )
        return (EINVAL);

    status = drv->drv_descriptor->io_adm_drv_write( (void *)drv->drv_descriptor,
                                                    io_adm_msg,
                                                    msg->i.nbytes );

    if ( status != 0 )
        return (EINVAL);

    return (EOK);
}

int io_adm_drv_devctl( resmgr_context_t *ctp, io_devctl_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status = 0;
    struct {
        int                 data;
    }                       *internal_io_adm_data;
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( (status = iofunc_devctl_default( ctp, msg, ocb )) != _RESMGR_DEFAULT )
        return status;

    status               = 0;
    internal_io_adm_data = ((void *)(16 + (int)(msg)));

    switch ( msg->i.dcmd ) {
        /*case ???_???_???:
            internal_io_adm_data = ...;
            break;*/
        default:
            if ( (drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0 )
                return ( EACCES );
            if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) && 
                 (msg->i.dcmd == DCMD_IOADM_GET_SHMOBJECT_RD) )
                return ( EACCES );

            if ( !drv->drv_descriptor->io_adm_drv_devctl )
                return (EINVAL);
            if ( drv->drv_descriptor->io_adm_drv_devctl( (void *)drv->drv_descriptor,
                                                         msg,
                                                         (void *)internal_io_adm_data ) != 0 )
                return (EINVAL);
    }

    return (_RESMGR_PTR( ctp, &msg->o, sizeof( msg->o ) + msg->o.nbytes ));
}
