/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 07/10/2010
 * Dev:  A. Docuchaev
 */


/* piso725_msg.h */


#include <io-adm-msg.h>


#ifndef _CBD_BC_IO_ADM_PISO725_MSG_H_
#define _CBD_BC_IO_ADM_PISO725_MSG_H_


    /* Defines */

    /* see DCMD_IOADM_SET_IRQ_SOURCE */
    #define PISO725_IRQ_SOURCE_DI0              0x01ull         /* DI0 */
    #define PISO725_IRQ_SOURCE_DI1              0x02ull         /* DI1 */
    #define PISO725_IRQ_SOURCE_DI2              0x04ull         /* DI2 */
    #define PISO725_IRQ_SOURCE_DI3              0x08ull         /* DI3 */
    #define PISO725_IRQ_SOURCE_DI4              0x10ull         /* DI4 */
    #define PISO725_IRQ_SOURCE_DI5              0x20ull         /* DI5 */
    #define PISO725_IRQ_SOURCE_DI6              0x40ull         /* DI6 */
    #define PISO725_IRQ_SOURCE_DI7              0x80ull         /* DI7 */

    /* see DCMD_IOADM_SET_IRQ_POLARITY */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI0   0x0001ull       /* DI0: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI1   0x0002ull       /* DI1: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI2   0x0004ull       /* DI2: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI3   0x0008ull       /* DI3: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI4   0x0010ull       /* DI4: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI5   0x0020ull       /* DI5: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI6   0x0040ull       /* DI6: "0"->"1" */
    #define PISO725_IRQ_POSITIVE_POLARITY_DI7   0x0080ull       /* DI7: "0"->"1" */
    #define PISO725_IRQ_ANY_POLARITY            0x8000ull       /* Any polarity on any IRQ */

    /* see DCMD_IOADM_READ_REG & DCMD_IOADM_WRITE_REG */
    #define PISO725_REG_TYPE_PCI                0x01ull

    /* Types */

    /* DCMD_IOADM_GET_SAMPLE & DCMD_IOADM_GET_SAMPLE message */
    typedef uint8_t     piso725_line_t;     /*
                                             * DCMD_IOADM_GET_SAMPLE:
                                             *      [7..0]
                                             *         `----- iline #
                                             * DCMD_IOADM_SET_SAMPLE:
                                             *      [7][6..0]
                                             *       |    `----- oline #
                                             *       `---------- value: 0/1
                                             */

    typedef uint8_t     piso725_readback_t; /*
                                             * In: [7..0]  - oline
                                             * Out: [7..0] - [DO7..DO0] (This is not inverted values)
                                             */


#endif  /* _CBD_BC_IO_ADM_PIOD64_MSG_H_ */
