/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 05/10/2010
 * Dev:  A. Docuchaev
 */


/* piod64_msg.h */


#include <io-adm-msg.h>


#ifndef _CBD_BC_IO_ADM_PIOD64_MSG_H_
#define _CBD_BC_IO_ADM_PIOD64_MSG_H_


    /* Defines */

    /* see DCMD_IOADM_SET_IRQ_SOURCE */
    #define PIOD64_IRQ_SOURCE_EXTIRQ            0x01ull     /* INT_CHAN_0 */
    #define PIOD64_IRQ_SOURCE_EVTIRQ            0x02ull     /* INT_CHAN_1 */
    #define PIOD64_IRQ_SOURCE_TMRIRQ            0x04ull     /* INT_CHAN_2 */

    /* see DCMD_IOADM_SET_IRQ_POLARITY */
    #define PIOD64_IRQ_POSITIVE_POLARITY_EXTIRQ 0x01ull     /* INT_CHAN_0: "0"->"1" */
    #define PIOD64_IRQ_POSITIVE_POLARITY_EVTIRQ 0x02ull     /* INT_CHAN_1: "0"->"1" */
    #define PIOD64_IRQ_POSITIVE_POLARITY_TMRIRQ 0x04ull     /* INT_CHAN_2: "0"->"1" */
    #define PIOD64_IRQ_ANY_POLARITY             0x80ull     /* Any polarity on any IRQ */

    /* see DCMD_IOADM_READ_REG & DCMD_IOADM_WRITE_REG */
    #define PIOD64_REG_TYPE_PCI                 0x01ull

    /* Types */

    /* DCMD_IOADM_GET_SAMPLE & DCMD_IOADM_GET_SAMPLE message */
    typedef uint8_t     piod64_line_t;      /*
                                             * DCMD_IOADM_GET_SAMPLE:
                                             *      [7..0]
                                             *         `----- iline #
                                             * DCMD_IOADM_SET_SAMPLE:
                                             *      [7][6..0]
                                             *       |    `----- oline #
                                             *       `---------- value: 0/1
                                             */


#endif  /* _CBD_BC_IO_ADM_PIOD64_MSG_H_ */
