/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 07/10/2010
 * Dev:  A. Docuchaev
 */


/* busscan.c */


#include "piso.h"


typedef struct pci_ids {
    uint16_t    vid,
                did;
    int         pci_id;
    int         available;
} pci_ids_t;
pci_ids_t       ids[MAX_PISO725_DEVICE_COUNT];
int             ids_count = 0;


int piso725_busscan( piso725_dev_t *dev, uint16_t vid, uint16_t did, int pci_id )
{
    struct pci_dev_info     info;
    int                     ret     = 0;
    int                     i       = 0;
    void                    *device = NULL;

    if ( ids_count >= MAX_PISO725_DEVICE_COUNT )
        return (-1);

    if ( (dev->pci_server = pci_attach( 0 )) == -1 )
        return (-1);

    memset( &info, 0, sizeof( info ) );

    if ( pci_id == -1 ) {

        unsigned    bus;
        unsigned    dev_func;

        vid = PCI_VENDOR_ID_ICPDAS;
        for ( i = 0; i < 2 * PCI_SCAN_DEPTH; i++ ) {
            if ( i < PCI_SCAN_DEPTH ) {
                did = PCI_DEVICE_ID_N0;
                pci_id = i;
            } else {
                did = PCI_DEVICE_ID_N1;
                pci_id = i - PCI_SCAN_DEPTH;
            }

            ret = pci_find_device( did, vid, pci_id, &bus, &dev_func );
            if ( ret == -1 ) {
                pci_detach( dev->pci_server );
                dev->pci_server = 0;
                return (-1);
            }
            if ( ret == PCI_SUCCESS ) {
                uint32_t    sub_vid_did = 0;
                uint64_t    sub_id      = 0;
                uint64_t    bar0        = 0;
                uint32_t    port        = 0;

                if ( pci_read_config32( bus, dev_func, 0x2C, 1, &sub_vid_did ) != PCI_SUCCESS ) {
                    pci_detach( dev->pci_server );
                    dev->pci_server = 0;
                    return (-1);
                }

                memset( &info, 0, sizeof( info ) );
                info.VendorId = vid;
                info.DeviceId = did;

                device = pci_attach_device( NULL, PCI_SEARCH_VENDEV, pci_id, &info );
                if ( errno == EBUSY )
                    continue;           /* Device already attached, search for the next */
                if ( !device ) {
                    pci_detach( dev->pci_server );
                    dev->pci_server = 0;
                    return (-1);
                }

                if ( !PCI_IS_IO( info.PciBaseAddress[0] ) ) {
                    pci_detach_device( device );
                    device = NULL;
                    pci_detach( dev->pci_server );
                    dev->pci_server = 0;
                    return (-1);
                }

                bar0 = PCI_IO_ADDR( info.PciBaseAddress[0] );
                port = mmap_device_io( info.BaseAddressSize[0], bar0 );

                sub_id = (uint64_t)sub_vid_did;

                if ( sub_id == PCI_SUBDEVICE_ID_PISO725R2 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R21 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R22 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R23 ) {
                    dev->device = device;
                    dev->vid = vid;
                    dev->did = did;
                    dev->sub_id0 = (uint32_t)(sub_id >> 32);
                    dev->sub_id1 = (uint32_t)sub_id;
                    dev->idx = pci_id;
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R2 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R2 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R21 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R21 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R22 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R22 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R23 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R23 );
                    dev->base = port;
                    dev->irq = info.Irq;
                    dev->attached = 1;

                    /* Add device to list */
                    {
                        int     j = 0;

                        for ( j = 0; j < MAX_PISO725_DEVICE_COUNT; j++ )
                            if ( ids[j].available == 0 ) {
                                ids[j].vid       = vid;
                                ids[j].did       = did;
                                ids[j].pci_id    = pci_id;
                                ids[j].available = 1;
                                break;
                            }
                        ids_count++;
                    }

                    return (0);
                }

                pci_detach_device( device );
                device = NULL;
            }
        }

        pci_detach( dev->pci_server );
        dev->pci_server = 0;
        return (-1);

    } else {

        info.VendorId = vid;
        info.DeviceId = did;
        device = pci_attach_device( NULL, PCI_SEARCH_VENDEV, pci_id, &info );
        if ( !device ) {
            pci_detach( dev->pci_server );
            dev->pci_server = 0;
            return (-1);
        }

        {
            uint32_t    sub_vid_did = 0;
            uint64_t    sub_id      = 0;
            uint64_t    bar0        = 0;
            uint32_t    port        = 0;

            if ( pci_read_config32( info.BusNumber, info.DevFunc, 0x2C, 1, &sub_vid_did ) != PCI_SUCCESS ) {
                pci_detach( dev->pci_server );
                dev->pci_server = 0;
                return (-1);
            }

            if ( !PCI_IS_IO( info.PciBaseAddress[0] ) ) {
                pci_detach_device( device );
                device = NULL;
                pci_detach( dev->pci_server );
                dev->pci_server = 0;
                return (-1);
            }

            bar0 = PCI_IO_ADDR( info.PciBaseAddress[0] );
            port = mmap_device_io( info.BaseAddressSize[0], bar0 );

            sub_id = (uint64_t)sub_vid_did;

            if ( sub_id == PCI_SUBDEVICE_ID_PISO725R2 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R21 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R22 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R23 ) {
                dev->device = device;
                dev->vid = vid;
                dev->did = did;
                dev->sub_id0 = (uint32_t)(sub_id >> 32);
                dev->sub_id1 = (uint32_t)sub_id;
                if ( sub_id == PCI_SUBDEVICE_ID_PISO725R2 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R2 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R21 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R21 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R22 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R22 );
                    if ( sub_id == PCI_SUBDEVICE_ID_PISO725R23 )
                        strcpy( dev->name, PCI_DEVICE_NAME_PISO725R23 );
                dev->base = port;
                dev->irq = info.Irq;
                dev->attached = 1;

                /* Add device to list */
                {
                    int     j = 0;

                    for ( j = 0; j < MAX_PISO725_DEVICE_COUNT; j++ )
                        if ( ids[j].available == 0 ) {
                            ids[j].vid       = vid;
                            ids[j].did       = did;
                            ids[j].pci_id    = pci_id;
                            ids[j].available = 1;
                            break;
                        }
                    ids_count++;
                }

                return (0);
            }

            pci_detach_device( device );
            device = NULL;
        }

    }

    return (-1);
}


void piso725_busscan_detach( piso725_dev_t *dev )
{
    int     j = 0;

    for ( j = 0; j < MAX_PISO725_DEVICE_COUNT; j++ )
        if ( ids[j].available == 1 &&
             dev->vid == ids[j].vid &&
             dev->did == ids[j].did &&
             dev->idx == ids[j].pci_id ) {
            ids[j].vid       = 0;
            ids[j].did       = 0;
            ids[j].pci_id    = 0;
            ids[j].available = 0;
            ids_count--;
            break;
        }
}


int piso725_busscan_attached( uint16_t vid, uint16_t did, int idx )
{
    int     j = 0;

    for ( j = 0; j < MAX_PISO725_DEVICE_COUNT; j++ )
        if ( ids[j].available == 1 &&
             vid == ids[j].vid &&
             did == ids[j].did &&
             idx == ids[j].pci_id )
            return (1);

    return (0);
}


int piso725_busscan_result()
{
    struct pci_dev_info     info;
    int                     ret     = 0;
    int                     i       = 0;
    void                    *device = NULL;
    uint16_t                vid, did;
    int                     pci_id;
    unsigned                bus;
    unsigned                dev_func;

    if ( ids_count >= MAX_PISO725_DEVICE_COUNT )
        return (-1);

    memset( &info, 0, sizeof( info ) );

    vid = PCI_VENDOR_ID_ICPDAS;
    for ( i = 0; i < 2 * PCI_SCAN_DEPTH; i++ ) {
        if ( i < PCI_SCAN_DEPTH ) {
            did = PCI_DEVICE_ID_N0;
            pci_id = i;
        } else {
            did = PCI_DEVICE_ID_N1;
            pci_id = i - PCI_SCAN_DEPTH;
        }

        ret = pci_find_device( did, vid, pci_id, &bus, &dev_func );
        if ( ret == -1 )
            return (-1);
        if ( ret == PCI_SUCCESS ) {
            uint32_t    sub_vid_did = 0;
            uint64_t    sub_id      = 0;

            if ( pci_read_config32( bus, dev_func, 0x2C, 1, &sub_vid_did ) != PCI_SUCCESS )
                return (-1);

            /* Getting Sub-aux-ID */
            {
                uint64_t    bar0 = 0;
                uint32_t    port = 0;

                memset( &info, 0, sizeof( info ) );
                info.VendorId = vid;
                info.DeviceId = did;

                device = pci_attach_device( NULL, PCI_SEARCH_VENDEV, pci_id, &info );
                if ( errno == EBUSY )
                    continue;           /* Device already attached, search for the next */
                if ( !device )
                    return (-1);

                if ( !PCI_IS_IO( info.PciBaseAddress[0] ) ) {
                    pci_detach_device( device );
                    device = NULL;
                    return (-1);
                }

                bar0 = PCI_IO_ADDR( info.PciBaseAddress[0] );
                port = mmap_device_io( info.BaseAddressSize[0], bar0 );

                sub_id = (uint64_t)sub_vid_did;

                pci_detach_device( device );
                device = NULL;

                if ( sub_id == PCI_SUBDEVICE_ID_PISO725R2 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R21 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R22 ||
                     sub_id == PCI_SUBDEVICE_ID_PISO725R23 )
                    if ( piso725_busscan_attached( vid, did, pci_id ) == 0 )
                        return (0);
            }
        }
    }

    return (-1);
}
