/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 04/10/2010
 * Dev:  A. Docuchaev
 */


/* pio.h */


#include <io-adm-drv.h>
#include <io-adm-msg.h>
#include <ioadm.h>
#include <piod64_msg.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <malloc.h>
#include <unistd.h>
#include <devctl.h>
#include <fcntl.h>
#include <sys/neutrino.h>
#include <sys/syspage.h>
#include <sys/mman.h>
#include <hw/pci.h>
#include <hw/inout.h>


#ifndef _CBD_BC_IO_ADM_PIOD64_H_
#define _CBD_BC_IO_ADM_PIOD64_H_


/* Defs */
#define MSG                             fprintf
#define ERRF                            stderr
#define STDF                            stdout

#define PCI_VENDOR_ID_ICPDAS            0xE159
#define PCI_DEVICE_ID_N0                0x2
#define PCI_DEVICE_ID_N1                0x1
#define PCI_SUBDEVICE_ID_PIOD64R1       0x2000010080ull
#define PCI_SUBDEVICE_ID_PIOD64R2       0x2000014080ull
#define PCI_DEVICE_NAME_PIOD64R1        "ICP DAS PIO-D64 (rev.1.0)"
#define PCI_DEVICE_NAME_PIOD64R2        "ICP DAS PIO-D64U (rev.2.0)"

#define PCI_SCAN_DEPTH                  32
#define MAX_PIOD64_DEVICE_COUNT         32

/* Registers */
#define PIO_D64_RESET_CONTROL           0x00
#define PIO_D64_INT_MASK_CONTROL        0x05
#define PIO_D64_AUX_PIN_STATUS          0x07
#define PIO_D64_INT_POLARITY            0x2a
#define PIO_D64_DIO_BYTE0               0xc0
#define PIO_D64_DIO_BYTE1               0xc4
#define PIO_D64_DIO_BYTE2               0xc8
#define PIO_D64_DIO_BYTE3               0xcc


/* Types */

typedef struct piod64_dev {

    io_adm_drv_descriptor_t     descriptor; /* MUST BE FIRST */

    /* Device */
    uint32_t            sub_id0;            /* Sub AUX */
    uint32_t            sub_id1;            /* Sub vid:did */
    char                name[65];           /* Device name */

    /* PCI */
    int                 pci_server;
    void                *device;
    int                 attached;
    uint16_t            vid;
    uint16_t            did;
    int                 idx;                /* PCI index */

    /* I/O */
    uint32_t            base;               /* Base address */

    /* IRQ */
    uint32_t            irq;
    int                 iid;                /* Interrupt ID */
    struct sigevent     irq_notifier;
    uint8_t             int_mask;           /* current PIO_D64_INT_MASK_CONTROL register value */
    uint8_t             int_polarity;       /* current PIO_D64_INT_POLARITY register value */
    uint8_t             irq_source,         /*
                                             * xxx
                                             * ||`--- EXTIRQ: 1/0
                                             * |`---- EVTIRQ: 1/0
                                             * `----- TMRIRQ: 1/0
                                             */
                        irq_edge;           /*
                                             * xxx
                                             * ||`--- EXTIRQ: 1 - positive, 0 - negative
                                             * |`---- EVTIRQ: 1 - positive, 0 - negative
                                             * `----- TMRIRQ: 1 - positive, 0 - negative
                                             */

    /* Time parameters */
    volatile uint64_t   int_st_cc;          /* Interrupt start clock-cycles */
    volatile uint64_t   int_ed_cc;          /* Interrupt end clock-cycles */
    volatile uint64_t   int_iv_cc;          /* Interrupt interval clock-cycles */
    double              int_time;           /* Interrupt time (in sec) */
    uint64_t            read_iv_cc;         /* Read interval (in clock-cycles) */
    double              read_time;          /* Read interval (in sec) */
    uint64_t            write_iv_cc;        /* Write interval (in clock-cycles) */
    double              write_time;         /* Write interval (in sec) */

    /* Misc */
    int                         verbose;
    int                         busscan;    /* BUS scanning mode flag */
    uint64_t                    irqsources; /* User selected IRQs (see DCMD_IOADM_SET_IRQ_SOURCE) */
    uint64_t                    irqpolar;   /* User selected IRQs (see DCMD_IOADM_SET_IRQ_POLARITY) */

} __attribute__ ((__packed__)) piod64_dev_t;


/* Funcs */

/* init.c */
int dev_parse_options( piod64_dev_t *dev, char *options );
void * io_adm_drv_init( char *options );
uint8_t io_adm_drv_busscan_result( void );
char * io_adm_drv_devname( void *device );
uint32_t io_adm_drv_devid( void *device );
uint64_t io_adm_drv_devsubid( void *device );
void * io_adm_drv_devstat( void *device );
int io_adm_drv_open( void *device );
void io_adm_drv_close( void *device );
void io_adm_drv_destroy( void *device );

/* io.c */
int io_adm_drv_read( void *device, void *msg, uint32_t size );
int io_adm_drv_write( void *device, void *msg, uint32_t size );
int io_adm_drv_devctl( void *device, io_devctl_t *msg, void *data );

/* event.c */
void init_isr( piod64_dev_t *device );
const struct sigevent * irq_handler( void *area, int id );

/* busscan.c */
int piod64_busscan( piod64_dev_t *dev, uint16_t vid, uint16_t did, int pci_id );
void piod64_busscan_detach( piod64_dev_t *dev );
int piod64_busscan_attached( uint16_t vid, uint16_t did, int idx );
int piod64_busscan_result();

/* in.c */
uint32_t piod64_read32( piod64_dev_t *dev );
uint16_t piod64_read16( piod64_dev_t *dev );
uint8_t piod64_read8( piod64_dev_t *dev, uint8_t iline );
uint8_t piod64_read1( piod64_dev_t *dev, uint8_t iline );

/* out.c */
void piod64_write32( piod64_dev_t *dev, uint32_t val );
void piod64_write16( piod64_dev_t *dev, uint16_t val );
void piod64_write8( piod64_dev_t *dev, uint8_t oline, uint8_t val );


#endif  /* _CBD_BC_IO_ADM_PIOD64_H_ */
