/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 05/10/2010
 * Dev:  A. Docuchaev
 */


/* in.c */


#include "pio.h"


void piod64_write32( piod64_dev_t *dev, uint32_t val )
{
    out8( dev->base + PIO_D64_DIO_BYTE0, (uint8_t)val );
    out8( dev->base + PIO_D64_DIO_BYTE1, (uint8_t)(val >> 8) );
    out8( dev->base + PIO_D64_DIO_BYTE2, (uint8_t)(val >> 16) );
    out8( dev->base + PIO_D64_DIO_BYTE3, (uint8_t)(val >> 24) );
}

void piod64_write16( piod64_dev_t *dev, uint16_t val )
{
    out8( dev->base + PIO_D64_DIO_BYTE0, (uint8_t)val );
    out8( dev->base + PIO_D64_DIO_BYTE1, (uint8_t)(val >> 8) );
}

void piod64_write8( piod64_dev_t *dev, uint8_t oline, uint8_t val )
{
    if ( oline < 8 )
        out8( dev->base + PIO_D64_DIO_BYTE0, (val & 0x1) << oline );
    else if ( oline < 16 )
        out8( dev->base + PIO_D64_DIO_BYTE1, (val & 0x1) << (oline - 8) );
    else if ( oline < 24 )
        out8( dev->base + PIO_D64_DIO_BYTE2, (val & 0x1) << (oline - 16) );
    else if ( oline < 32 )
        out8( dev->base + PIO_D64_DIO_BYTE3, (val & 0x1) << (oline - 24) );
}

