/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 04/10/2010
 * Dev:  A. Docuchaev
 */


/* event.c */


#include "pio.h"


/*
 * Init ISR notify event
 */
void init_isr( piod64_dev_t *device )
{
    piod64_dev_t            *dev = (piod64_dev_t *)device;

    dev->irq_notifier.sigev_notify = SIGEV_INTR;
}

/*
 * Interrupt handler
 */
const struct sigevent * irq_handler( void *area, int id )
{
    register piod64_dev_t   *dev        = (piod64_dev_t *)area;
    register uint8_t        reply       = 0;
    register uint8_t        aux_status  = 0,
                            tmp         = 1;

    /* Identify source */
    {
        dev->irq_source = 0;
        aux_status      = in8( dev->base + PIO_D64_AUX_PIN_STATUS );

        while ( tmp <= 0x04 ) {
            if ( dev->int_mask & tmp )              /* Is IRQ source enabled? */
                if ( dev->int_polarity & tmp ) {    /* Positive edge: 0->1 */
                    if ( aux_status & tmp ) {       /* IRQ exists */
                        dev->irq_source |= tmp;
                        dev->irq_edge   |= tmp;
                    }
                } else                              /* Negative edge: 1->0 */
                    /* Inverse signal */
                    if ( !(aux_status & tmp) ) {    /* IRQ exists */
                        dev->irq_source |= tmp;
                        dev->irq_edge   &= !tmp;
                    }

            tmp <<= 1;
        }
    }

    /* Process interrupt */
    #define CALC_TM                                             \
        if ( dev->int_st_cc == 0 )                              \
            dev->int_st_cc = ClockCycles();                     \
        else {                                                  \
            dev->int_ed_cc = ClockCycles();                     \
            dev->int_iv_cc = dev->int_ed_cc - dev->int_st_cc;   \
            dev->int_st_cc = dev->int_ed_cc;                    \
        }
    
    if ( dev->irqpolar == PIOD64_IRQ_ANY_POLARITY ) {
        dev->descriptor.data_received += 4 /* Size of received data */;
        reply = 1;

        /* Get time between 2 interrupts */
        CALC_TM
    } else {
        tmp = 1;

        while ( tmp <= 0x04 ) {
            if ( (dev->irq_source & tmp == dev->irqsources & tmp) && 
                 (dev->irq_edge & tmp   == dev->irqpolar & tmp) ) {
                dev->descriptor.data_received += 4 /* Size of received data */;
                reply = 1;

                /* Get time between 2 interrupts */
                CALC_TM
                break;
            }

            tmp <<= 1;
        }
    }
    #undef  CALC_TM

    /* Inverts the IRQ polarity */
    dev->int_polarity ^= dev->irq_source;
    out8( dev->base + PIO_D64_INT_POLARITY, dev->int_polarity );

    if ( reply )
        return ( &dev->irq_notifier );
    else
        return (NULL);
}
