/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 23/11/2009
 * Dev:  A. Docuchaev
 */


/* io.c */


#include "dev.h"


/* Defines */

#define DEVCTL_RET( cond, devctl_status )       \
    if ( cond ) {                               \
        msg->o.ret_val = (devctl_status);       \
        break;                                  \
    }


/* Funcs */

/*
 * _IO_READ handler
 *
 * In: Device ptr
 *     Message ptr (Message size >= 4)
 *     Size to read
 * Out: n - count of readed bytes
 *      0 - error
 */
int io_adm_drv_read( void *device, void *msg, uint32_t size )
{
    sample_dev_t            *dev  = (sample_dev_t *)device;
    int                     read_sz = 0;

    read_sz = strlen( "devadc-sample.so: read" ) + 1;

    /* Process */
    if ( size < read_sz )
        return (0);

    strcpy( (char *)msg, "devadc-sample.so: read" );

    dev->descriptor.data_readed += read_sz;
    return (read_sz);
}

/*
 * _IO_WRITE handler
 *
 * In: Device ptr
 *     Message ptr
 *     Message size
 * Out: -1 - error
 */
int io_adm_drv_write( void *device, void *msg, uint32_t size )
{
    /*sample_dev_t            *dev = (sample_dev_t *)device;*/

    /* Process */
    fprintf( stderr, "devadc-sample.so: write %u b\n", size );

    return (0);
}

/*
 * _IO_DEVCTL handler
 *
 * In: Device ptr
 *     io_devctl_t message ptr
 *     Buffer ptr
 * Out: 0 - ok
 */
int io_adm_drv_devctl( void *device, io_devctl_t *msg, void *data )
{
    sample_dev_t            *dev = (sample_dev_t *)device;

    switch ( msg->i.dcmd ) {

        case DCMD_IOADM_GET_BUFF_MODE: {

            /* Process DCMD_IOADM_GET_BUFF_MODE */
            msg->o.ret_val = LIBMODE_SIMPLE | LIBMODE_BUFPERM_R | LIBMODE_BUFPERM_W;
            break;

        }

        case DCMD_IOADM_START: {

            /* Emnable device */
            dev->descriptor.device_state |= IO_ADM_DRV_STATE_DEV_STARTED;

            /* Enable IRQ */
            dev->descriptor.device_state |= IO_ADM_DRV_STATE_IRQ_ENABLED;

            msg->o.nbytes  = 0;
            msg->o.ret_val = 0;
            break;
        }

        case DCMD_IOADM_STOP: {

            /* Disable device */
            dev->descriptor.device_state &= ~IO_ADM_DRV_STATE_DEV_STARTED;

            /* Disable IRQ */
            dev->descriptor.device_state &= ~IO_ADM_DRV_STATE_IRQ_ENABLED;

            msg->o.nbytes  = 0;
            msg->o.ret_val = 0;
            break;
        }

        case DCMD_IOADM_GET_AVAIL_DATA_SZ: {
            *(uint32_t *)data = strlen( "devadc-sample.so: read" ) + 1;

            msg->o.nbytes  = sizeof( uint32_t );
            msg->o.ret_val = 0;
            break;
        }

        case DCMD_IOADM_GET_LAST_RECV_TIME: {
            *(uint64_t *)data = ClockCycles();

            msg->o.nbytes  = sizeof( uint64_t );
            msg->o.ret_val = 0;
            break;
        }

        default:
            msg->o.ret_val = 0xff;  /* Error status */
            msg->o.nbytes  = 0;

    }

    return (0);
}
