/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 22/11/2009
 * Dev:  A. Docuchaev
 */


/* init.c */


#include "dev.h"


static  char                *sample_dev_opts [] = {
    "verbose",              /* 0 */
    "idx",                  /* 1 */
    NULL
};


/*
 * Called from io_adm_drv_init()
 * Out: EOK - ok
 */
int dev_parse_options( sample_dev_t *dev, char *options )
{
    char                    *value, *restore, *c;
    int                     opt;
    int                     rc = 0;
    int                     err = EOK;

    if ( !options )
        return EOK;

    restore = NULL;

    while ( options && *options != '\0' ) {

        c = options;
        restore = strchr( options, ',' );
        opt = getsubopt( &options, sample_dev_opts, &value );

        switch ( opt ) {
            case  0:    /* "verbose" */
                if ( value )
                    dev->verbose = strtoul( value, 0, 0 );
                else
                    dev->verbose = 1;
                break;

            case 1:     /* "idx" */
                if ( value )
                    dev->descriptor.device_idx = strtoul( value, 0, 0 );
                break;

            default:
                MSG( STDF, "devadc-sample.so: Undefined option\n" );
                return EINVAL;
                break;
        }   /* switch */

        if (restore != NULL)
            *restore = ',';

    }   /* while */

    errno = err;
    return (rc);
}


/*
 * io-adm entry point - initialize driver
 */
void * io_adm_drv_init( char *options )
{
    sample_dev_t            *dev = (sample_dev_t *)malloc( sizeof( sample_dev_t ) );
    if ( !dev ) {
        fprintf( stderr, "devadc-sample.so: Can't allocate sample_dev_t\n" );
        return (NULL);
    }
    dev->verbose                 = 0;

    /* Init drv-descriptor */
    IO_ADM_DRV_DESCRIPTOR_INIT( dev->descriptor )
    dev->descriptor.io_adm_drv_open    = io_adm_drv_open;
    dev->descriptor.io_adm_drv_close   = io_adm_drv_close;
    dev->descriptor.io_adm_drv_destroy = io_adm_drv_destroy;
    dev->descriptor.io_adm_drv_write   = io_adm_drv_write;
    dev->descriptor.io_adm_drv_read    = io_adm_drv_read;
    dev->descriptor.io_adm_drv_devctl  = io_adm_drv_devctl;
    dev->descriptor.io_adm_drv_devname = io_adm_drv_devname;
    dev->descriptor.io_adm_drv_devid   = io_adm_drv_devid;
    dev->descriptor.io_adm_drv_devstat = io_adm_drv_devstat;
    dev->descriptor.device_idx         = 0;

    /* Parse options */
    if ( dev_parse_options( dev, options ) != EOK ) {
        free( dev );
        return NULL;
    }

    if ( dev->verbose )
        MSG( STDF, "\nio-adm sample driver started\n" );

    ThreadCtl( _NTO_TCTL_IO, 0 );

    /* Identify device */
    dev->descriptor.device_state |= IO_ADM_DRV_STATE_DEV_DETECTED;

    /* Init IRQ */
    init_isr();
    /* Enable IRQ in HW */
    /*dev->iid = InterruptAttach( (int)dev->InterruptLine,
                                  irq_handler,
                                  (const void *)dev,
                                  sizeof( sample_dev_t * ),
                                  _NTO_INTR_FLAGS_TRK_MSK );
    if ( dev->iid < 0 ) {
        MSG( STDF, "devadc-sample.so: InterruptAttach() failed\n" );
        return NULL;
    }*/

    /* Allocate memory */
    dev->descriptor.device_state |= IO_ADM_DRV_STATE_DEV_MEM_ALLOCATED;

    /* Init device */
    dev->descriptor.device_state |= IO_ADM_DRV_STATE_DEV_INITED;

    dev->descriptor.device_state |= IO_ADM_DRV_STATE_READY;

    dev->descriptor.caps = IO_ADM_DRV_CAPS_DEVNAME |
                           IO_ADM_DRV_CAPS_DEVID |
                           IO_ADM_DRV_CAPS_DEVSTATS;

    return dev;
}

char * io_adm_drv_devname( void *device )
{
    return "Sample io-adm driver";
}

uint32_t io_adm_drv_devid( void *device )
{
    sample_dev_t            *dev = (sample_dev_t *)device;

    return dev->descriptor.device_idx;
}

void * io_adm_drv_devstat( void *device )
{
    /* Not realized yet */
    return NULL;
}

int io_adm_drv_open( void *device )
{
    sample_dev_t            *dev = (sample_dev_t *)device;

    /* Prepare device */

    /* Clear stats */
    IO_ADM_DRV_DESCRIPTOR_CLEAR_STATS( dev->descriptor )

    return (0);
}

void io_adm_drv_close( void *device )
{
    /*sample_dev_t            *dev = (sample_dev_t *)device;*/

    /* Disable IRQ */

    /* Disable device */

    /* Close device */
}

void io_adm_drv_destroy( void *device )
{
    /*sample_dev_t            *dev = (sample_dev_t *)device;*/

    io_adm_drv_close( device );
}
