/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 26/11/2009
 * Dev:  A. Docuchaev
 */


/* event.c */


#include "dev.h"


struct sigevent             irq_notifier;


/*
 * Init ISR notify event
 */
void init_isr( void )
{
    irq_notifier.sigev_notify = SIGEV_INTR;
}

/*
 * Interrupt handler
 */
const struct sigevent * irq_handler( void *area, int id )
{
    sample_dev_t            *dev    = (sample_dev_t *)area;
    int                     reply   = 0;

    /* Mask interrupts */
    InterruptMask( (int)dev->InterruptLine, dev->iid );

    /* Process interrupt */
    dev->descriptor.data_received += 100 /* Size of received data */;
    reply = 1;

    /* Clear IRQ source */

    /* Unmask interrupts */
    InterruptUnmask( (int)dev->InterruptLine, dev->iid );

    if ( reply )
        return ( &irq_notifier );
    else
        return (NULL);
}
