/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 24/11/2009
 * Dev:  A. Docuchaev
 */


/* L-CARD.h */


#ifndef _CBD_BC_IO_ADM_L_CARD_H_
#define _CBD_BC_IO_ADM_L_CARD_H_


/* Defs */

/* PCI */
#define PCI_VENDOR_ID_PLX                   0x10b5
#define PCI_DEVICE_ID_PLX_PCI9030           0x9030
#define PCI_SUB_VENDOR_ID_L783M             0x3833
#define PCI_SUB_DEVICE_ID_L783M             0x4c37

/* PLX PCI9030 - PCI BAR1 */
#define PLX_REG_LAS0RR                      0x00                /* Local Address Space 0 Range Register */
#define PLX_REG_LAS1RR                      0x04                /* Local Address Space 1 Range Register */
#define PLX_REG_LAS2RR                      0x08                /* Local Address Space 2 Range Register */
#define PLX_REG_LAS3RR                      0x0C                /* Local Address Space 3 Range Register */
#define PLX_REG_EROMRR                      0x10                /* Expansion ROM Range Register */
#define PLX_REG_LAS0_BASE                   0x14                /* Local Address Space 0 Local Base Address */
#define PLX_REG_LAS1_BASE                   0x18                /* Local Address Space 1 Local Base Address */
#define PLX_REG_LAS2_BASE                   0x1C                /* Local Address Space 2 Local Base Address */
#define PLX_REG_LAS3_BASE                   0x20                /* Local Address Space 3 Local Base Address */
#define PLX_REG_XROM_BASE                   0x24                /* Expansion ROM Local Base Address (Remap) */
#define PLX_REG_LAS0BRD                     0x28                /* Local Address Space 0 Bus Region Descriptor */
#define PLX_REG_LAS1BRD                     0x2C                /* Local Address Space 1 Bus Region Descriptor */
#define PLX_REG_LAS2BRD                     0x30                /* Local Address Space 2 Bus Region Descriptor */
#define PLX_REG_LAS3BRD                     0x34                /* Local Address Space 3 Bus Region Descriptor */
#define PLX_REG_EROMBRD                     0x38                /* Expansion ROM Bus Region Descriptor */
#define PLX_REG_CS0BASE                     0x3C                /* Chip Select 0 Base Address */
#define PLX_REG_CS1BASE                     0x40                /* Chip Select 1 Base Address */
#define PLX_REG_CS2BASE                     0x44                /* Chip Select 2 Base Address */
#define PLX_REG_CS3BASE                     0x48                /* Chip Select 3 Base Address */
#define PLX_REG_INTCSR                      0x4C                /* Interrupt Control/Status Register */
#define PLX_REG_CNTRL                       0x50                /* User I/O, PCI Target Response, EEPROM, Initialization Control */
#define PLX_REG_LCR_EXTENT                  0x54
/* PLX_REG_CNTRL bits */
#define PLX_REG_CNTRL_USER0PS               0x00000001          /* User I/O 0 or WAITO# Pin Select */
#define PLX_REG_CNTRL_USER0D                0x00000002          /* User I/O 0 Direction */
#define PLX_REG_CNTRL_USER0                 0x00000004          /* User I/O 0 Data */
#define PLX_REG_CNTRL_USER1PS               0x00000008          /* User I/O 1 or LLOCK Pin Select */
#define PLX_REG_CNTRL_USER1D                0x00000010          /* User I/O 1 Direction */
#define PLX_REG_CNTRL_USER1                 0x00000020          /* User I/O 1 Data */
#define PLX_REG_CNTRL_USER2PS               0x00000040          /* User I/O 2 or CS2 Pin Select */
#define PLX_REG_CNTRL_USER2D                0x00000080          /* User I/O 2 Direction */
#define PLX_REG_CNTRL_USER2                 0x00000100          /* User I/O 2 Data */
#define PLX_REG_CNTRL_USER3PS               0x00000200          /* User I/O 3 or CS3 Pin Select */
#define PLX_REG_CNTRL_USER3D                0x00000400          /* User I/O 3 Direction */
#define PLX_REG_CNTRL_USER3                 0x00000800          /* User I/O 3 Data */
#define PLX_REG_CNTRL_PCIBAR                0x00003000          /* PCIBAR Enables */
#define PLX_REG_CNTRL_PCIR                  0x00004000          /* PCI Read Mode */
#define PLX_REG_CNTRL_PCIRWF                0x00008000          /* PCI Read with Write Flush Mode */
#define PLX_REG_CNTRL_PCIRNF                0x00010000          /* PCI Read No Flush Mode */
#define PLX_REG_CNTRL_PCIRNW                0x00020000          /* PCI Read No Write Mode */
#define PLX_REG_CNTRL_PCIW                  0x00040000          /* PCI Write Mode */
#define PLX_REG_CNTRL_TRDC                  0x00780000          /* PCI Target Retry Delay Clocks */
#define PLX_REG_CNTRL_DSLE                  0x00800000          /* Direct Slave Lock Enable */
#define PLX_REG_CNTRL_EESK                  0x01000000          /* EEPROM Serial Data Clock */
#define PLX_REG_CNTRL_EECS                  0x02000000          /* EEPROM Chip Select */
#define PLX_REG_CNTRL_EEWD                  0x04000000          /* EEPROM Write Data */
#define PLX_REG_CNTRL_EERD                  0x08000000          /* EEPROM Read Data */
#define PLX_REG_CNTRL_EECHK                 0x10000000          /* EEPROM Present */
#define PLX_REG_CNTRL_RCR                   0x20000000          /* EEPROM Reload */
#define PLX_REG_CNTRL_RESET                 0x40000000          /* PCI Adapter Software Reset */
/* PLX_REG_INTCSR bits */
#define PLX_REG_INTCSR_LI1E                 0x00000001          /* Local Interrupt 1 Enable */
#define PLX_REG_INTCSR_LI1P                 0x00000002          /* Local Interrupt 1 Polarity */
#define PLX_REG_INTCSR_LI1S                 0x00000004          /* Local Interrupt 1 Status */
#define PLX_REG_INTCSR_LI2E                 0x00000008          /* Local Interrupt 2 Enable */
#define PLX_REG_INTCSR_LI2P                 0x00000010          /* Local Interrupt 2 Polarity */
#define PLX_REG_INTCSR_LI2S                 0x00000020          /* Local Interrupt 2 Status */
#define PLX_REG_INTCSR_PIE                  0x00000040          /* PCI Interrupt Enable */
#define PLX_REG_INTCSR_SI                   0x00000080          /* Software Interrupt */

/* EEPROM control bits */
#define L780_EESK                           0x04000000          /* EEPROM Serial Data Clock */
#define L780_EEWD                           0x01000000          /* EEPROM Write Data */
#define L780_EERD                           0x08000000          /* EEPROM Read Data */
#define L780_EECS                           0x00000004          /* EEPROM Chip Select */

/* IDMA */
#define IDMA_ADDR                           0x02
#define IDMA_EXTENT                         0x08

/* DSP BIOS variables */
#define BIOS_VARIABLE_CONTROL_TABLE         0x0A00
#define BIOS_VARIABLE_SCALE                 0x0D00
#define BIOS_VARIABLE_ZERO                  0x0D04
#define BIOS_VARIABLE_CONTROL_HEIGHT        0x0D08
#define BIOS_VARIABLE_BOARD_REVISION        0x0D3F
#define BIOS_VARIABLE_READY                 0x0D40
#define BIOS_VARIABLE_TMODE1                0x0D41
#define BIOS_VARIABLE_TMODE2                0x0D42
#define BIOS_VARIABLE_DSP_TYPE              0x0D48
#define BIOS_VARIABLE_COMMAND               0x0D49
#define BIOS_VARIABLE_FIRST_SAMPLE          0x0D4A
#define BIOS_VARIABLE_TTL_OUT               0x0D4C
#define BIOS_VARIABLE_TTL_IN                0x0D4D
#define BIOS_VARIABLE_DAC_FIFO_PTR          0x0D4F
#define BIOS_VARIABLE_ADC_FIFO_PTR          0x0D50
#define BIOS_VARIABLE_TEST_LOAD             0x0D52
#define BIOS_VARIABLE_ADC_RATE              0x0D53
#define BIOS_VARIABLE_ADC_INTERFRAME        0x0D54
#define BIOS_VARIABLE_DAC_RATE              0x0D55
#define BIOS_VARIABLE_DAC_VALUE             0x0D56
#define BIOS_VARIABLE_ENABLE_IRQ            0x0D57
#define BIOS_VARIABLE_IRQ_STEP              0x0D58
#define BIOS_VARIABLE_IRQ_FIFO_ADDRESS      0x0D5A
#define BIOS_VARIABLE_ENABLE_IRQ_VALUE      0x0D5B
#define BIOS_VARIABLE_ADC_SAMPLE            0x0D5C
#define BIOS_VARIABLE_ADC_CHANNEL           0x0D5D
#define BIOS_VARIABLE_DAC_SCLK_DIV          0x0D5E
#define BIOS_VARIABLE_CORRECTION_ENABLE     0x0D60
#define BIOS_VARIABLE_ADC_ENABLE            0x0D62
#define BIOS_VARIABLE_ADC_FIFO_BASE         0x0D63
#define BIOS_VARIABLE_ADC_FIFO_BASE_INDEX   0x0D64
#define BIOS_VARIABLE_ADC_FIFO_LENGTH       0x0D65
#define BIOS_VARIABLE_ADC_NEW_FIFO_LENGTH   0x0D66
#define BIOS_VARIABLE_DAC_ENABLE            0x0D67
#define BIOS_VARIABLE_DAC_FIFO_BASE         0x0D68
#define BIOS_VARIABLE_DAC_FIFO_LENGTH       0x0D69
#define BIOS_VARIABLE_DAC_NEW_FIFO_LENGTH   0x0D6A
#define BIOS_VARIABLE_SYNC_TYPE             0x0D70
#define BIOS_VARIABLE_SYNC_CHANNEL          0x0D73
#define BIOS_VARIABLE_SYNC_LEVEL            0x0D74
#define BIOS_VARIABLE_SYNC_MODE             0x0D75
#define BIOS_VARIABLE_SYNC_EDGE             0x0D76
/* DSP BIOS Commands */
#define BIOS_COMMAND_TEST                   0x0000
#define BIOS_COMMAND_LOAD_CONTROL_TABLE     0x0001
#define BIOS_COMMAND_ENABLE_ADC             0x0002
#define BIOS_COMMAND_ADC_FIFO_CFG           0x0003
#define BIOS_COMMAND_SET_ADC_FRAME          0x0004
#define BIOS_COMMAND_ENABLE_DAC             0x0005
#define BIOS_COMMAND_DAC_FIFO_CFG           0x0006
#define BIOS_COMMAND_SET_DAC_RATE           0x0007
#define BIOS_COMMAND_ADC_SAMPLE             0x0008
#define BIOS_COMMAND_TTL_IN                 0x0009
#define BIOS_COMMAND_TTL_OUT                0x000A
#define BIOS_COMMAND_SYNC_CONFIG            0x000B
#define BIOS_COMMAND_ENABLE_IRQ             0x000C
#define BIOS_COMMAND_IRQ_TEST               0x000D
#define BIOS_COMMAND_SET_DSP_TYPE           0x000E
#define BIOS_COMMAND_NULL                   0x000F

/* Board names */
#define LCARD_TIGR                          "TIGR"
#define LCARD_760                           "L760"
#define LCARD_761                           "L761"
#define LCARD_780                           "L780"
#define LCARD_783                           "L783"
#define LCARD_UN                            "Unknown"


#endif  /* _CBD_BC_IO_ADM_L_CARD_H_ */
