/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 25/11/2009
 * Dev:  A. Docuchaev
 */


/* eeprom.c */


#include "l783m.h"


/*
 * Raise/lower EEPROM Chip Select
 */
static int eeprom_cs( l783m_t *l783m, int n )
{
    int                        x;

    x = in32( l783m->board_info.bi.eecs );
    if ( n )
        x |= L780_EECS;
    else
        x &= ~L780_EECS;
    out32( l783m->board_info.bi.eecs, x );

    return (0);
}


/*
 * Read EEPROM words
 */
static int eeprom_read_data_block( l783m_t *l783m, uint32_t addr, uint16_t *buf, int n )
{
    unsigned                x, d, i;

    eeprom_cs( l783m, 1 );

    x = in32( l783m->board_info.bi.cntrl );
    x = x & ~L780_EESK & ~L780_EEWD;
    out32( l783m->board_info.bi.cntrl, x );

    d = 0x180 | (addr & 0x3F);  /* 110XXXXXX */
    for( i = 0; i < 9; i++ ) {
        if ( d & 0x100 )
            x |= L780_EEWD;
        else
            x &= ~L780_EEWD;
        out32( l783m->board_info.bi.cntrl, x );
        x |= L780_EESK;
        out32( l783m->board_info.bi.cntrl, x );
        x &= ~L780_EESK;
        out32( l783m->board_info.bi.cntrl, x );
        d <<= 1;
    }

    x = in32( l783m->board_info.bi.cntrl );
    x &= ~L780_EEWD;
    out32( l783m->board_info.bi.cntrl, x );

    while ( n > 0 ) {
        d = 0;
        for ( i = 0; i < 16; i++ ) {
            d <<= 1;
            x |= L780_EESK;
            out32( l783m->board_info.bi.cntrl, x );
            x &= ~L780_EESK;
            out32( l783m->board_info.bi.cntrl, x );
            x = in32( l783m->board_info.bi.cntrl );
            if ( x & L780_EERD )
                d |= 1;
        }
        *(buf++) = d;
        n--;
    }

    eeprom_cs( l783m, 0 );

    return d;
}


/*
 * Read EEPROM data
 *
 * In: Device ptr
 *     Buffer
 *     size in uint16_t
 * Out: 0 - ok
 */
int eeprom_read_data( l783m_t *l783m, uint32_t addr, uint16_t *buf, uint32_t size )
{
    int                     i, c;

    for( i = 0; i < size; i++ ) {
        c = eeprom_read_data_block( l783m, addr, buf, 1 );  /* Read 1 word */
        if( c < 0 )
            return c;
        buf++;
        addr++;
    }

    return 0;
}
