/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf.timeouts;

import com.ibm.rational.rhapsody.oxf.RiJEvent;
import com.ibm.rational.rhapsody.oxf.RiJEventDispatcher;
import com.ibm.rational.rhapsody.oxf.RiJOXF;
import com.ibm.rational.rhapsody.oxf.RiJThread;
import com.ibm.rational.rhapsody.oxf.services.RiJSimpleTimer;
import com.ibm.rational.rhapsody.oxf.services.RiJTimer;
import com.ibm.rational.rhapsody.oxf.services.RiJTimerFactory;
import com.ibm.rational.rhapsody.oxf.services.RiJTimerListener;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJSimulatedTimer;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJTimeout;
import com.ibm.rational.rhapsody.oxf.timeouts.RiJTimeoutComparator;
import com.ibm.rational.rhapsody.oxfinst.AnimServices;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RiJTimeoutManager
implements RiJTimerListener {
    public static final long DEF_MAX_TIME = 9223372036854765807L;
    public static final long DEF_TIME_TICK = 50L;
    protected long currentTime;
    protected static RiJTimeoutManager m_instance;
    protected long maxTime = 9223372036854765807L;
    protected Vector postedTimeouts;
    protected boolean simulatedTime = false;
    protected long timeTick = 50L;
    protected Hashtable unpostedTimeouts;
    protected RiJTimer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RiJTimeoutManager(long timeTick, long maxTime, boolean simulatedTime) {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            this.currentTime = 0L;
            if (timeTick != 0L) {
                this.timeTick = timeTick;
            }
            if (maxTime != 0L) {
                this.maxTime = maxTime;
            }
            this.simulatedTime = simulatedTime;
            RiJTimeoutComparator tC = new RiJTimeoutComparator();
            this.unpostedTimeouts = new Hashtable();
            this.postedTimeouts = new Vector();
            RiJTimerFactory timerFactory = RiJOXF.getTheTimerFactory();
            this.timer = simulatedTime ? timerFactory.createSimulatedTimeTimer(this) : timerFactory.createRealTimeTimer(this, this.timeTick, false);
            if (this.timer != null) {
                this.timer.start();
            }
        }
    }

    public RiJTimeoutManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeTime(int interval, int step) {
        if (this.simulatedTime) {
            int phases = interval / step;
            for (int i = 0; i < phases; ++i) {
                RiJTimeoutManager riJTimeoutManager = this;
                synchronized (riJTimeoutManager) {
                    this.currentTime += (long)step;
                    this.post();
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decNonIdleCount() {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            if (this.timer instanceof RiJSimulatedTimer) {
                ((RiJSimulatedTimer)this.timer).decNonIdleCount();
            }
        }
    }

    protected synchronized RiJTimeout findInPosted(RiJTimeout timeout) {
        Enumeration li = this.postedTimeouts.elements();
        while (li.hasMoreElements()) {
            RiJTimeout tm = (RiJTimeout)li.nextElement();
            if (!tm.equals(timeout)) continue;
            return tm;
        }
        return null;
    }

    public Thread getThread() {
        Thread thread = null;
        if (this.timer != null && this.timer instanceof RiJSimpleTimer) {
            thread = ((RiJSimpleTimer)this.timer).getThread();
        }
        return thread;
    }

    protected void goNext() {
        if (!this.unpostedTimeouts.isEmpty()) {
            RiJTimeout timeout = (RiJTimeout)this.unpostedTimeouts.elements().nextElement();
            this.currentTime = timeout.getDueTime();
        }
    }

    public void goNextAndPost() {
        this.goNext();
        this.post();
    }

    public void handleTimerInterrupt(RiJSimpleTimer timer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incNonIdleCount() {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            if (this.timer instanceof RiJSimulatedTimer) {
                ((RiJSimulatedTimer)this.timer).incNonIdleCount();
            }
        }
    }

    protected void incrementTime() {
        if (this.simulatedTime) {
            this.goNext();
        } else {
            this.currentTime += this.timeTick;
        }
        if (this.currentTime >= this.maxTime) {
            this.currentTime = 0L;
            this.resetTimeouts();
        }
    }

    public static RiJTimeoutManager instance(long tickTime, long maxTime) {
        return RiJTimeoutManager.instance(tickTime, maxTime, false);
    }

    public static RiJTimeoutManager instance() {
        return RiJTimeoutManager.instance(50L, 9223372036854765807L);
    }

    public static RiJTimeoutManager instance(long tickTime, long maxTime, boolean simulatedTime) {
        if (m_instance == null) {
            m_instance = new RiJTimeoutManager(tickTime, maxTime, simulatedTime);
        }
        return m_instance;
    }

    public boolean isSimulatedTime() {
        return this.simulatedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTime() {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            this.incrementTime();
            this.post();
        }
    }

    protected void post() {
        RiJTimeout timeout;
        while (!this.unpostedTimeouts.isEmpty() && (timeout = (RiJTimeout)this.unpostedTimeouts.keys().nextElement()).getDueTime() <= this.currentTime) {
            RiJEventDispatcher dispatcher = (RiJEventDispatcher)this.unpostedTimeouts.get(timeout);
            RiJEvent ev = AnimServices.initAnimEvent(timeout, timeout.getCreatingThread());
            dispatcher.queueEvent(ev);
            this.unpostedTimeouts.remove(timeout);
            this.postedTimeouts.addElement(timeout);
        }
    }

    public void promoteSimulatedTime() {
        RiJSimulatedTimer st;
        int rc;
        if (this.simulatedTime && this.timer instanceof RiJSimulatedTimer && (rc = (st = (RiJSimulatedTimer)this.timer).getNonIdleThreadsCounter()) == 0) {
            this.incrementTime();
            this.unsynchPost();
        }
    }

    protected void removeExpiredTimeout(RiJTimeout timeout) {
        this.postedTimeouts.removeElement(timeout);
    }

    protected void resetTimeouts() {
        Enumeration iter = this.unpostedTimeouts.elements();
        while (iter.hasMoreElements()) {
            ((RiJTimeout)iter.nextElement()).resetDueTime(this.currentTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedTimeout(RiJTimeout timeout, RiJEventDispatcher dispatcher) {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            timeout.resetDueTime(this.currentTime);
            timeout.setTimeoutManager(this);
            this.unpostedTimeouts.put(timeout, dispatcher);
        }
    }

    public void setSimulatedTime(boolean simulateTime) {
        this.currentTime = 0L;
        this.resetTimeouts();
        this.simulatedTime = simulateTime;
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedTimeout(RiJTimeout theTimeout) {
        RiJTimeoutManager riJTimeoutManager = this;
        synchronized (riJTimeoutManager) {
            int index = this.postedTimeouts.indexOf(theTimeout);
            if (index >= 0) {
                RiJTimeout tm = (RiJTimeout)this.postedTimeouts.elementAt(index);
                tm.cancel();
                this.postedTimeouts.removeElementAt(index);
                return;
            }
            if (this.unpostedTimeouts.remove(theTimeout) == null) {
                // empty if block
            }
        }
    }

    protected void unsynchPost() {
        RiJTimeout timeout;
        while (!this.unpostedTimeouts.isEmpty() && (timeout = (RiJTimeout)this.unpostedTimeouts.elements().nextElement()).getDueTime() <= this.currentTime) {
            try {
                RiJThread dispatcher = (RiJThread)this.unpostedTimeouts.get(timeout);
                RiJEvent ev = AnimServices.initAnimEvent(timeout, timeout.getCreatingThread());
                dispatcher.unsynchQueueEvent(ev);
                this.unpostedTimeouts.remove(timeout);
                this.postedTimeouts.addElement(timeout);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public long getCurrentTime() {
        return this.currentTime;
    }
}

