/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf.states;

import com.ibm.rational.rhapsody.oxf.RiJEvent;
import com.ibm.rational.rhapsody.oxf.RiJInformer;
import com.ibm.rational.rhapsody.oxf.RiJReactive;
import com.ibm.rational.rhapsody.oxf.RiJThread;
import com.ibm.rational.rhapsody.oxf.services.RiJMutex;
import com.ibm.rational.rhapsody.oxf.states.RiJImplicitState;
import com.ibm.rational.rhapsody.oxf.states.RiJOrState;
import com.ibm.rational.rhapsody.oxf.states.RiJState;
import com.ibm.rational.rhapsody.oxf.states.StateEnterException;

public class RiJStateReactive
extends RiJReactive {
    public static final int DEF_MAX_NULL_STEPS = 32;
    public static final int TAKE_EVENT_COMPLETE = 0;
    public static final int TAKE_EVENT_NOT_CONSUMED = -3;
    public static final int TAKE_EVENT_REACHED_TERMINATOR = -1;
    public static final int TAKE_EVENT_UNKNOWN_FAIL = -2;
    private Boolean busy = Boolean.FALSE;
    public RiJEvent event;
    private RiJMutex eventMutex = null;
    private boolean isBehaviorStarted = false;
    protected RiJThread m_thread;
    protected int maxNullSteps = 32;
    protected boolean mutualExclusionOfTrigOp = true;
    protected int nullStepsCounter;
    protected boolean shouldCompleteStartBehavior = false;
    protected boolean terminated = false;
    protected RiJImplicitState rootState;

    public RiJStateReactive(RiJThread thread) {
        super(thread);
        this.maxNullSteps = 32;
    }

    public RiJStateReactive() {
    }

    protected int _takeEvent(RiJEvent event) {
        RiJEvent prevEvent = this.event;
        this.event = event;
        int res = -3;
        if (this.shouldCompleteStartBehavior) {
            this.shouldCompleteStartBehavior = false;
            if (!this.mutualExclusionOfTrigOp) {
                this.runToCompletion();
            } else {
                this.doBusy();
                this.runToCompletion();
                this.undoBusy();
            }
        }
        if (event.getID() != -5L) {
            if (!this.mutualExclusionOfTrigOp) {
                res = this.consumeEvent(event);
                if (this.shouldCompleteRun()) {
                    this.runToCompletion();
                }
            } else if (!this.isBusy()) {
                this.doBusy();
                res = this.consumeEvent(event);
                if (this.shouldCompleteRun()) {
                    this.runToCompletion();
                }
                this.undoBusy();
            }
        }
        return res;
    }

    protected int consumeEvent(RiJEvent event) {
        int res = -3;
        if (this.terminated) {
            return -1;
        }
        if (event.getID() != -1L || this.shouldCompleteRun()) {
            // empty if block
        }
        res = this.rootState_dispatchEvent(event);
        return res;
    }

    public void createEventMutex() {
        this.eventMutex = new RiJMutex();
    }

    public void doBusy() {
        this.busy = Boolean.TRUE;
    }

    public short freeEventMutex() {
        short res = -3;
        if (this.eventMutex != null) {
            res = this.eventMutex.free();
        }
        return res;
    }

    public RiJOrState getRootState() {
        return this.rootState;
    }

    public void handleEventNotConsumed(RiJEvent event) {
    }

    public void handleTONotConsumed(RiJEvent event) {
    }

    public boolean isBusy() {
        boolean res = true;
        if (this.busy.equals(Boolean.FALSE)) {
            res = false;
        }
        return res;
    }

    public boolean isPort(Object port) {
        boolean res = false;
        if (this.event != null && port != null) {
            res = this.event.getPort() == port;
        }
        return res;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void lockEventMutex() {
        if (this.eventMutex != null) {
            try {
                this.eventMutex.lock();
            }
            catch (InterruptedException e) {
                System.err.println("Faild to lock");
                System.err.println("Exception : " + e);
            }
        }
    }

    public synchronized void popNullConfig() {
        if (this.nullStepsCounter == 0) {
            System.err.println("Error : NullStepsUnderflow");
            System.exit(1);
        }
        --this.nullStepsCounter;
    }

    public synchronized void pushNullConfig() {
        if (this.nullStepsCounter >= this.maxNullSteps) {
            System.err.println(this.nullStepsCounter + "Error : NullStepsOverflow");
            System.exit(1);
        }
        ++this.nullStepsCounter;
    }

    protected int rootState_dispatchEvent(RiJEvent event) {
        RiJState active;
        if (this.rootState == null) {
            short id = (short)event.getID();
            return this.rootState_dispatchEvent(id);
        }
        if (this.rootState != null && (active = this.rootState.getItsActiveState()) != null) {
            return active.takeEvent(event);
        }
        return -2;
    }

    public int rootState_dispatchEvent(short id) {
        return -2;
    }

    public void rootState_entDef() throws StateEnterException {
        if (this.rootState != null) {
            this.rootState.entDef();
        }
    }

    public synchronized void runToCompletion() {
        int localCounter = 0;
        RiJStateReactive dest = this;
        RiJEvent nullEvent = new RiJEvent(-1L, dest);
        RiJEvent originalEvent = this.event;
        this.event = nullEvent;
        while (this.consumeEvent(nullEvent) >= 0) {
            if ((localCounter = (int)((short)(localCounter + 1))) > this.maxNullSteps) {
                RiJInformer.instance().printMsg(this, "Error : Infinite Loop");
                break;
            }
            if (!this.terminated) continue;
        }
        this.event = originalEvent;
        nullEvent = null;
    }

    protected boolean shouldCompleteRun() {
        return this.nullStepsCounter != 0;
    }

    public boolean startBehavior() {
        try {
            if (!this.isBehaviorStarted) {
                this.isBehaviorStarted = true;
                this.rootState_entDef();
                if (this.shouldCompleteRun()) {
                    this.shouldCompleteStartBehavior = true;
                    RiJEvent ev = new RiJEvent(-5L, this);
                    this._gen(ev);
                }
            }
        }
        catch (StateEnterException stateEE) {
            RiJInformer.instance().printMsg(this, "Exception: " + stateEE);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int takeEvent(RiJEvent event) {
        if (this.terminated) {
            return -1;
        }
        int res = -3;
        if (this.eventMutex != null) {
            RiJMutex riJMutex = this.eventMutex;
            synchronized (riJMutex) {
                return this._takeEvent(event);
            }
        }
        res = this._takeEvent(event);
        if (res == -3) {
            if (event.getIsTriggeredOperation()) {
                this.handleTONotConsumed(event);
            } else {
                this.handleEventNotConsumed(event);
            }
        }
        return res;
    }

    public int takeTrigger(RiJEvent event) {
        event.setIsTriggeredOperation(true);
        return this.takeEvent(event);
    }

    public void terminate() {
        this.terminated = true;
    }

    public void undoBusy() {
        this.busy = Boolean.FALSE;
    }

    public void setMaxNullSteps(int p_maxNullSteps) {
        this.maxNullSteps = p_maxNullSteps;
    }

    public boolean getMutualExclusionOfTrigOp() {
        return this.mutualExclusionOfTrigOp;
    }

    public void setMutualExclusionOfTrigOp(boolean p_mutualExclusionOfTrigOp) {
        this.mutualExclusionOfTrigOp = p_mutualExclusionOfTrigOp;
    }

    public void setRootState(RiJImplicitState p_RiJImplicitState) {
        this.rootState = p_RiJImplicitState;
    }
}

