/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.rhapsody.oxf.services;

import com.ibm.rational.rhapsody.oxf.services.RiJTimer;
import com.ibm.rational.rhapsody.oxf.services.RiJTimerListener;

public class RiJSimpleTimer
implements RiJTimer,
Runnable {
    protected boolean oneShot;
    protected Thread thread;
    private long tmInterval;
    protected RiJTimerListener timeoutListener;

    public RiJSimpleTimer(RiJTimerListener i_tmListener, long i_mSecs, boolean i_oneShot) {
        this.timeoutListener = i_tmListener;
        this.tmInterval = i_mSecs;
        this.oneShot = i_oneShot;
    }

    public RiJSimpleTimer(RiJTimerListener i_tmListener, long i_tmInterval) {
        this(i_tmListener, i_tmInterval, false);
    }

    public RiJSimpleTimer() {
    }

    public Thread getThread() {
        return this.thread;
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    public void run() {
        if (this.oneShot) {
            this.tm();
        } else {
            while (this.thread == Thread.currentThread()) {
                this.tm();
            }
        }
    }

    public void start() {
        if (this.timeoutListener == null || this.tmInterval == 0L) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        this.thread = null;
    }

    private void tm() {
        try {
            Thread.sleep(this.tmInterval);
            this.timeoutListener.notifyTime();
        }
        catch (InterruptedException e) {
            this.timeoutListener.handleTimerInterrupt(this);
        }
    }

    public RiJTimerListener getTimeoutListener() {
        return this.timeoutListener;
    }
}

