@echo off
rem
rem	Open Watcom Installer. Windows Host. QNX4 Target.
rem	CBD BC (C) 2008. All rights reserved.
rem	Author: Michael Kolesov
rem

echo.
echo ########################################################
echo #                                                      #
echo # Open Watcom Installer for QNX4 Target. Windows Host. #
echo # V1.00, 19 Dec 2008                                   #
echo #                                                      #
echo # CBD BC (C) 2008. All rights reserved.                #
echo # For bugs and issues please mail to support@kpda.ru   #
echo #                                                      #
echo ########################################################
pause


rem ######################################################
rem #							 #
rem #		Configuration Area			 #
rem #							 #
rem ######################################################

rem Path to watcom qnx4 target headers place
set W_Q4_H=%WATCOM%\h\qnx4

rem Path to watcom qnx4 target libraries place
set W_Q4_L=%WATCOM%\lib386\qnx4

rem Path to original qnx4 headers
set Q4_ORIG_H=C:\QNX4\include

rem Path to original qnx4 libraries
set Q4_ORIG_L=C:\QNX4\lib

rem Path to watcom osi (os independent) headers (c++, math, emu)
set W_H=%WATCOM%\h

rem Path to watcom osi (os independent) libraries (c++, math, emu)
set W_L=%WATCOM%\lib386

rem Path to rebuilded qnx4 binaries (debug server, trap file)
set W_Q4_B=%WATCOM%\binq

rem Path to watcom binary 
set W_B=%WATCOM%\binnt

rem ######################################################

echo.
echo At first, clear all instalation paths (if exist):
pause

if exist %W_Q4_H%\nul rmdir /s %W_Q4_H%
if exist %W_Q4_L%\nul rmdir /s %W_Q4_L%
if exist %W_Q4_B%\nul rmdir /s %W_Q4_B%
echo Done.

echo.
echo Create qnx4 target directories in WATCOM tree
pause

mkdir %W_Q4_H%
echo Directory %W_Q4_H% is created
mkdir %W_Q4_L%
echo Directory %W_Q4_L% is created
mkdir %W_Q4_B%
echo Directory %W_Q4_B% is created

echo Done.

echo.
echo Copy QNX4 original headers
pause

xcopy /s /f %Q4_ORIG_H% %W_Q4_H%

echo Done.

echo.
echo Copy QNX4 original libraries
pause

xcopy /s /f %Q4_ORIG_L% %W_Q4_L%

echo Done.

echo.
echo Copy Watcom C++ headers
pause

xcopy /f /y %W_H%\complex.h %W_Q4_H%
xcopy /f /y %W_H%\complex %W_Q4_H%
xcopy /f /y %W_H%\except.h %W_Q4_H%
xcopy /f /y %W_H%\fstream.h %W_Q4_H%
xcopy /f /y %W_H%\fstream %W_Q4_H%
xcopy /f /y %W_H%\generic.h %W_Q4_H%
xcopy /f /y %W_H%\iomanip.h %W_Q4_H%
xcopy /f /y %W_H%\iomanip %W_Q4_H%
xcopy /f /y %W_H%\iostream.h %W_Q4_H%
xcopy /f /y %W_H%\iostream %W_Q4_H%
xcopy /f /y %W_H%\new.h %W_Q4_H%
xcopy /f /y %W_H%\new %W_Q4_H%
xcopy /f /y %W_H%\stdiobuf.h %W_Q4_H%
xcopy /f /y %W_H%\streambu.h %W_Q4_H%\streambuf.h
xcopy /f /y %W_H%\streambu %W_Q4_H%
xcopy /f /y %W_H%\string.hpp %W_Q4_H%
xcopy /f /y %W_H%\strstrea.h %W_Q4_H%\strstream.h
xcopy /f /y %W_H%\wcdefs.h %W_Q4_H%
xcopy /f /y %W_H%\strstrea.h %W_Q4_H%\strstream.h
xcopy /f /y %W_H%\strstrea %W_Q4_H%
xcopy /f /y %W_H%\wcexcept.h %W_Q4_H%
xcopy /f /y %W_H%\wchash.h %W_Q4_H%
xcopy /f /y %W_H%\wchbase.h %W_Q4_H%
xcopy /f /y %W_H%\wchiter.h %W_Q4_H%
xcopy /f /y %W_H%\wclbase.h %W_Q4_H%
xcopy /f /y %W_H%\wclcom.h %W_Q4_H%
xcopy /f /y %W_H%\wclibase.h %W_Q4_H%
xcopy /f /y %W_H%\wclist.h %W_Q4_H%
xcopy /f /y %W_H%\wclistit.h %W_Q4_H%
xcopy /f /y %W_H%\wcqueue.h %W_Q4_H%
xcopy /f /y %W_H%\wcsbase.h %W_Q4_H%
xcopy /f /y %W_H%\wcsibase.h %W_Q4_H%
xcopy /f /y %W_H%\wcskip.h %W_Q4_H%
xcopy /f /y %W_H%\wcskipit.h %W_Q4_H%
xcopy /f /y %W_H%\wcstack.h %W_Q4_H%
xcopy /f /y %W_H%\wcvbase.h %W_Q4_H%
xcopy /f /y %W_H%\wcvector.h %W_Q4_H%
xcopy /f /y %W_H%\ios.h %W_Q4_H%
xcopy /f /y %W_H%\ios %W_Q4_H%
xcopy /f /y %W_H%\istream.h %W_Q4_H%
xcopy /f /y %W_H%\istream %W_Q4_H%
xcopy /f /y %W_H%\ostream.h %W_Q4_H%
xcopy /f /y %W_H%\ostream %W_Q4_H%
xcopy /f /y %W_H%\cstring %W_Q4_H%

rem ..and some not c++..
xcopy /f /y %W_H%\_comdef.h %W_Q4_H%
xcopy /f /y %W_H%\cstddef %W_Q4_H%
xcopy /f /y %W_H%\stddef.h %W_Q4_H%
xcopy /f /y %W_H%\ctype.h %W_Q4_H%
xcopy /f /y %W_H%\cctype %W_Q4_H%

echo Done.

echo.
echo Copy Watcom C++ libraries
pause

xcopy /f /y %W_L%\cplx3r.lib %W_Q4_L%
xcopy /f /y %W_L%\cplx3s.lib %W_Q4_L%
xcopy /f /y %W_L%\cplx73r.lib %W_Q4_L%
xcopy /f /y %W_L%\cplx73s.lib %W_Q4_L%
xcopy /f /y %W_L%\plbx3r.lib %W_Q4_L%
xcopy /f /y %W_L%\plbx3s.lib %W_Q4_L%
xcopy /f /y %W_L%\plbxmt3r.lib %W_Q4_L%
xcopy /f /y %W_L%\plbxmt3s.lib %W_Q4_L%
xcopy /f /y %W_L%\plib3r.lib %W_Q4_L%
xcopy /f /y %W_L%\plib3s.lib %W_Q4_L%
xcopy /f /y %W_L%\plibmt3r.lib %W_Q4_L%
xcopy /f /y %W_L%\plibmt3s.lib %W_Q4_L%

echo Done.

echo. 
echo Copy Additional QNX and CBD_BC Utilities
pause

xcopy /f /y "%CD%\binnt\cc.bat" %W_B%
xcopy /f /y "%CD%\binnt\wdc_tcp.exe" %W_B%
xcopy /f /y "%CD%\binq\std.trp" %W_Q4_B%
xcopy /f /y "%CD%\binq\tcpserv" %W_Q4_B%

echo Done.

echo.
echo Installation complete!
pause