/**************************************************************************
 *                                                                        *
 *  Filename  : msg.c                                                     *
 *  Comment   : Tester for the SRR engine                                 *
 *  Copyright : (c) CBD BC, Oleg Bolshakov, 2011                          *
 *                                                                        *
 **************************************************************************/

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/kernel.h>

#include "msg.h"

srr_msg_t	smsg = { SRR_SEND, 0, "Send message" };
srr_msg_r_t	rmsg = { 0, SRR_REPL, "Repl message" };


int main( int argc, char *argv[] )
{
	int		pid;
	int		ret;

	printf( PROG": my pid is %d\n", getpid() );

#ifndef IS_recv
	if ( argc < 2 )
	{
		fprintf( stderr, "Please, specify the process ID\n" );
		exit( -1 );
	}
	pid = atol( argv[1] );
#else
recv:
	pid = Receive( 0, &rmsg, sizeof( rmsg ) );
	if ( pid == -1 )
	{
		perror( PROG": Receive()" );
		exit( -1 );
	}
#endif

	printf( PROG": remote pid is %d\n", pid );

#ifdef IS_send
	ret = Send( pid, &smsg, &rmsg, sizeof( smsg ), sizeof( rmsg ) );
	if ( ret == -1 )
	{
		perror( PROG": Send()" );
		exit( -1 );
	}
#endif

#ifdef IS_repl
	ret = Reply( pid, &rmsg, sizeof( rmsg ) );
	if ( ret == -1 )
	{
		perror( PROG": Peply()" );
		exit( -1 );
	}
#endif

#ifdef IS_recv
	goto recv;
#endif

	printf( PROG": exiting\n" );

	return ( 0 );
}
