/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 22/11/2009
 * Dev:  A. Docuchaev
 */


/* io-adm-drv.h */


#include <io-adm-msg.h>
#include <sys/iofunc.h>
#include <sys/dispatch.h>


#ifndef _CBD_BC_IO_ADM_DRV_H_
#define _CBD_BC_IO_ADM_DRV_H_


/* Defs */

/* Driver states */
#define IO_ADM_DRV_STATE_READY                      0x00000001ul    /* _IO_READ, _IO_WRITE, IO_DEVCTL allowed */
#define IO_ADM_DRV_STATE_IRQ_ENABLED                0x00000002ul    /* IRQ enabled */
#define IO_ADM_DRV_STATE_DEV_STARTED                0x00000004ul    /* Device is started */
#define IO_ADM_DRV_STATE_DEV_DETECTED               0x00000100ul
#define IO_ADM_DRV_STATE_DEV_INITED                 0x00000200ul
#define IO_ADM_DRV_STATE_DEV_MEM_ALLOCATED          0x00000400ul

/* Driver capabilities */
#define IO_ADM_DRV_CAPS_BUSSCAN                     0x00000001ul
#define IO_ADM_DRV_CAPS_DEVNAME                     0x00000002ul
#define IO_ADM_DRV_CAPS_DEVID                       0x00000004ul
#define IO_ADM_DRV_CAPS_DEVSUBID                    0x00000008ul
#define IO_ADM_DRV_CAPS_DEVSTATS                    0x00000010ul

#define IO_ADM_DRV_DESCRIPTOR_INIT( desc )              \
    desc.io_adm_drv_init           = io_adm_drv_init;   \
    desc.io_adm_drv_busscan_result = NULL;              \
    desc.io_adm_drv_devname        = NULL;              \
    desc.io_adm_drv_devid          = NULL;              \
    desc.io_adm_drv_devsubid       = NULL;              \
    desc.io_adm_drv_devstat        = NULL;              \
    desc.io_adm_drv_destroy        = NULL;              \
    desc.io_adm_drv_open           = NULL;              \
    desc.io_adm_drv_close          = NULL;              \
    desc.io_adm_drv_write          = NULL;              \
    desc.io_adm_drv_read           = NULL;              \
    desc.io_adm_drv_devctl         = NULL;              \
    desc.device_idx                = 0;                 \
    desc.device_state              = 0;                 \
    desc.data_received             = 0;                 \
    desc.data_readed               = 0;                 \
    desc.data_transmitted          = 0;

#define IO_ADM_DRV_DESCRIPTOR_CLEAR_STATS( desc )       \
    desc.data_received             = 0;                 \
    desc.data_readed               = 0;                 \
    desc.data_transmitted          = 0;


/* Types */

/*
 * In: Options
 * Out: Driver descriptor == Device descriptor
 */
typedef void *(*io_adm_drv_init_t)( char * );

/*
 * Out: 0 - there is no available device found
 *      1 - device found (bus-scan needed)
 */
typedef uint8_t (*io_adm_drv_busscan_result_t)( void );

/*
 * In: Device descriptor
 * Out: Device name string
 */
typedef char *(*io_adm_drv_devname_t)( void * );

/*
 * In: Device descriptor
 * Out: Device id vid:did=[0..15]:[16..31]
 */
typedef uint32_t (*io_adm_drv_devid_t)( void * );

/*
 * In: Device descriptor
 * Out: Device sub-id (device specific id)
 */
typedef uint64_t (*io_adm_drv_devsubid_t)( void * );

/*
 * In: Device descriptor
 * Out: Device stats pointer
 */
typedef void *(*io_adm_drv_devstat_t)( void * );

/*
 * In: Device descriptor
 */
typedef void  (*io_adm_drv_destroy_t)( void * );

/*
 * In: Device descriptor
 * Out: 0 - ok
 *      !0 - error
 */
typedef int   (*io_adm_drv_open_t)( void * );

/*
 * In: Device descriptor
 */
typedef void  (*io_adm_drv_close_t)( void * );

/*
 * In: Device descriptor
 *     Message pointer
 *     Message size
 * Out: 0 - ok
 *      !0 - error
 */
typedef int   (*io_adm_drv_write_t)( void *, void *, uint32_t );

/*
 * In: Device descriptor
 *     Message pointer
 *     Message size
 * Out: N - number of bytes
 *      0 - error
 */
typedef int   (*io_adm_drv_read_t)( void *, void *, uint32_t );

/*
 * In: Device descriptor
 *     Message pointer
 *     Data pointer
 * Out: 0 - ok
 */
typedef int   (*io_adm_drv_devctl_t)( void *, io_devctl_t *, void * );

/*
 * Driver descriptor (header of device descriptor)
 */
typedef struct io_adm_drv_descriptor {

    /* Device */
    uint8_t                         device_idx;
    uint32_t                        device_state;
    uint32_t                        caps;                       /* Capability */

    /* Statistics */
    volatile uint64_t               data_received;
    volatile uint64_t               data_readed;
    volatile uint64_t               data_transmitted;

    /* Primary callbacks (used by io-adm) */
    io_adm_drv_init_t               io_adm_drv_init;
    io_adm_drv_busscan_result_t     io_adm_drv_busscan_result;  /* see IO_ADM_DRV_CAPS_BUSSCAN */
    io_adm_drv_devname_t            io_adm_drv_devname;         /* see IO_ADM_DRV_CAPS_DEVNAME */
    io_adm_drv_devid_t              io_adm_drv_devid;           /* see IO_ADM_DRV_CAPS_DEVID */
    io_adm_drv_devsubid_t           io_adm_drv_devsubid;        /* see IO_ADM_DRV_CAPS_DEVSUBID */
    io_adm_drv_devstat_t            io_adm_drv_devstat;         /* see IO_ADM_DRV_CAPS_DEVSTATS */
    /* Secondary callbacks */
    io_adm_drv_destroy_t            io_adm_drv_destroy;
    io_adm_drv_open_t               io_adm_drv_open;
    io_adm_drv_close_t              io_adm_drv_close;
    io_adm_drv_write_t              io_adm_drv_write;
    io_adm_drv_read_t               io_adm_drv_read;
    io_adm_drv_devctl_t             io_adm_drv_devctl;

} __attribute__ ((__packed__)) io_adm_drv_descriptor_t;


#endif  /* _CBD_BC_IO_ADM_DRV_H_ */
