/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 07/10/2010
 * Dev:  A. Docuchaev
 */


/* in.c */


#include "piso.h"


uint8_t piso725_read8( piso725_dev_t *dev, uint8_t iline )
{
    if ( iline < 8 )
        return (uint8_t)in8( dev->base + PISO725_DI );

    return (0x0);
}


uint8_t piso725_readback8( piso725_dev_t *dev, uint8_t oline )
{
    if ( oline < 8 )
        return (~(uint8_t)in8( dev->base + PISO725_DO ));

    return (0x0);
}


uint8_t piso725_read1( piso725_dev_t *dev, uint8_t iline )
{
    if ( iline < 8 )
        return ((uint8_t)in8( dev->base + PISO725_DI ) >> iline) & 0x1;

    return (0x0);
}
