/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 22/11/2009
 * Dev:  A. Docuchaev
 */


/* dev.h */


#include <io-adm-drv.h>
#include <io-adm-msg.h>
#include <ioadm.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
//#include <malloc.h>
//#include <unistd.h>
#include <devctl.h>
#include <fcntl.h>
//#include <sys/neutrino.h>
//#include <sys/syspage.h>
#include <sys/mman.h>
//#include <hw/pci.h>
//#include <hw/inout.h>


#ifndef _CBD_BC_IO_ADM_SAMPLE_H_
#define _CBD_BC_IO_ADM_SAMPLE_H_


/* Defs */
#define MSG                             fprintf
#define ERRF                            stderr
#define STDF                            stdout


/* Types */

typedef struct sample_dev {

    io_adm_drv_descriptor_t     descriptor;     /* MUST BE FIRST */

    /* Misc */
    int                         verbose;
    int                         iid;                /* Interrupt ID */
    int                         InterruptLine;

} __attribute__ ((__packed__)) sample_dev_t;


/* Funcs */

/* init.c */
int dev_parse_options( sample_dev_t *dev, char *options );
void * io_adm_drv_init( char *options );
char * io_adm_drv_devname( void *device );
uint32_t io_adm_drv_devid( void *device );
void * io_adm_drv_devstat( void *device );
int io_adm_drv_open( void *device );
void io_adm_drv_close( void *device );
void io_adm_drv_destroy( void *device );

/* io.c */
int io_adm_drv_read( void *device, void *msg, uint32_t size );
int io_adm_drv_write( void *device, void *msg, uint32_t size );
int io_adm_drv_devctl( void *device, io_devctl_t *msg, void *data );

/* event.c */
void init_isr( void );
const struct sigevent * irq_handler( void *area, int id );

#endif  /* _CBD_BC_IO_ADM_SAMPLE_H_ */
