/* Y o u r   D e s c r i p t i o n                       */
/*                            AppBuilder Photon Code Lib */
/*                                         Version 2.03  */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Local headers */
#include "ablibs.h"
#include "abimport.h"
#include "proto.h"

#include "my.h"

ioadm_device_t              l783m = IOADM_DEVICE_INIT;
char                        device[6] = "l783m";
l783m_msg_channel_t         ch_msg;
l783m_buff_info_t           bi;
int			    timer1_st = 0;

int
B2onClick( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )

	{

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;
	int pci_index = 0;
	char *text;

	if ( timer1_st ) {
	    LOG( "Warning: Device already opened\n" );
	    return( Pt_CONTINUE );
	}

	PtGetResource( ABW_PtText1, Pt_ARG_TEXT_STRING, &text, 0 );
	pci_index = strtoul( text, 0, 0 );

	/* Try to open device l783m */
	if ( ioadm_open_pci( &l783m, device, pci_index ) ) {
	    LOG( "Error: can't open device\n" );
	    return( Pt_CONTINUE );
	}
	
	/* Set channels number */
	if ( ioadm_set_channels_number( &l783m, 1 ) ) {
	    LOG( "Error: can't set channel number\n" );
	    return( Pt_CONTINUE );
	}
	
	/* Set channels */
	ch_msg.index = 0;
	ch_msg.mode  = L783M_CHANNEL_SINGLE_ENDED;
	ch_msg.input = 0;
	ch_msg.gain  = 0;
	if ( ioadm_custom_dcmd( &l783m, DCMD_IOADM_SET_CHANNEL, (void *)&ch_msg, sizeof( ch_msg ) ) != 0 ) {
	    LOG( "Error: can't set channel's metric\n" );
	    return( Pt_CONTINUE );
	}
	
	/* Set buffer size */
	bi.frag_sz = 8 * 350 * 2;
	bi.buf_sz  = 0; /* Max */
	if ( ioadm_set_buff( &l783m, (void *)&bi, sizeof( bi ) ) != 0 ) {
	    LOG( "Error: can't set buffer\n" );
	    return( Pt_CONTINUE );
        }

        {
    	    l783m_msg_timing_params_t   tp;
            tp.channel_rate = 8 * 100 * 1000;
            tp.frame_rate   = 0;

            if ( ioadm_set_timing( &l783m, &tp, sizeof( tp ) ) != 0 ) {
	        LOG( "Error: can't set timing parameters\n" );
                return( Pt_CONTINUE );
            }
        }

        /* Set calibration multipliers */
        if ( ioadm_set_calibration_multipliers( &l783m, NULL, 0 ) != 0 ) {
            LOG( "Error: can't set calibration multipliers\n" );
            return( Pt_CONTINUE );
        }

        /* Enable calibration */
        if ( ioadm_enable_calibration( &l783m, 1 ) != 0 ) {
            LOG( "Error: can't enable calibration\n" );
            return( Pt_CONTINUE );
        }

        /* Prepare lib to I/O operations */
        if ( ioadm_lib_prepare_io( &l783m ) != 0 ) {
            LOG( "Error: can't prepare lib-i/o\n" );
            return( Pt_CONTINUE );
        }

	/* Unblock controls */
        long                *f;
        PtGetResource( ABW_PtButton5, Pt_ARG_FLAGS, &f, 0 );
        *f &= ~(unsigned long)Pt_BLOCKED;
        PtSetResource( ABW_PtButton5, Pt_ARG_FLAGS, *f, 0 );
        PtReRealizeWidget( ABW_PtButton5 );
        PtGetResource( ABW_PtButton4, Pt_ARG_FLAGS, &f, 0 );
        *f &= ~(unsigned long)Pt_BLOCKED;
        PtSetResource( ABW_PtButton4, Pt_ARG_FLAGS, *f, 0 );
        PtReRealizeWidget( ABW_PtButton4 );

        PtSetResource( ABW_PtButton4, Pt_ARG_COLOR, PgRGB( 0, 0, 0 ), 0 );
        PtSetResource( ABW_PtButton5, Pt_ARG_COLOR, PgRGB( 0, 0, 0 ), 0 );

	LOG( "Device opened successfully\n" );
	
	timer1_st = 1;

	return( Pt_CONTINUE );

	}

