/* Y o u r   D e s c r i p t i o n                       */
/*                            AppBuilder Photon Code Lib */
/*                                         Version 2.03  */

/* Standard headers */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* Local headers */
#include "ablibs.h"
#include "abimport.h"
#include "proto.h"

#include "my.h"

uint8_t			*dbuf   = NULL;
int			dbuf_sz = 0;

int
B10onClick( PtWidget_t *widget, ApInfo_t *apinfo, PtCallbackInfo_t *cbinfo )

	{

	/* eliminate 'unreferenced' warnings */
	widget = widget, apinfo = apinfo, cbinfo = cbinfo;

	int			*sz;
	int			cur_sz = 0;
	uint8_t			*dbuf_ptr;
	char			txt[40];
	struct timespec 	start, stop;
	double          	interval;
	struct sched_param	sched_param;

	if ( timer1_st == 0 ) {
	    LOG( "Error: device not started\n" );
	    return( Pt_CONTINUE );
	}

	sched_param.sched_priority = 27;
        pthread_setschedparam( pthread_self(), SCHED_RR, &sched_param );

	PtGetResource( ABW_PtNI1, Pt_ARG_NUMERIC_VALUE, &sz, 0 );
	dbuf_sz = *sz;
	
	if ( dbuf ) {
	    free( dbuf );
	    dbuf = NULL;
	}
	dbuf = (uint8_t *)malloc( dbuf_sz );
	if ( dbuf == NULL ) {
	    LOG( "Error: can't allocate buffer\n" );
	    return ( Pt_CONTINUE );
	}
	dbuf_ptr = dbuf;
	
	sprintf( txt, "Started" );
	PtSetResource( ABW_PtL30, Pt_ARG_TEXT_STRING, txt, 0 );
	PtReRealizeWidget( ABW_PtL30 );
	PtFlush();
	
	clock_gettime( CLOCK_REALTIME, &start );
	
	while ( cur_sz < dbuf_sz ) {

	    int		sz;
	    uint8_t	*ptr;

	    sz = ioadm_read_fragment_wc( &l783m, (void *)&ptr );
	    if ( sz < 0 ) {
		LOG( "Error: can't read from device\n" );
		return( Pt_CONTINUE );
	    }

	    if ( cur_sz + sz > dbuf_sz )
		sz = dbuf_sz - cur_sz;
	    memcpy( dbuf_ptr, ptr, sz );
	    dbuf_ptr += sz;
	    cur_sz   += sz;

	}

	clock_gettime( CLOCK_REALTIME, &stop );

	sprintf( txt, "Done" );
	PtSetResource( ABW_PtL30, Pt_ARG_TEXT_STRING, txt, 0 );
	PtReRealizeWidget( ABW_PtL30 );
	PtFlush();

	interval = (stop.tv_sec - start.tv_sec) + 
	           (double)(stop.tv_nsec - start.tv_nsec) / (double)(1000000000L);
	sprintf( txt, "Read time: %f s\n", interval );
	LOG( "Data readed\n" );
	LOG( txt );

	if ( draw_pos == 0 ) {
	    PtArg_t                     args[20];
            int                         i = 0;
            PtMTrendAttr_t              graph1_attr;
	        graph1_attr.state = Pt_MTREND_STATE_SHOWN;
    	        graph1_attr.color = Pg_RED;
		graph1_attr.line_thickness = 1;
	        graph1_attr.join_type = Pg_MITER_JOIN;
		graph1_attr.min = -5300;
	        graph1_attr.max =  5300;
    		graph1_attr.draw_f = NULL;
	    PtSetArg( &args[i++], Pt_ARG_MTREND_GRAPH_ATTR, &graph1_attr, 0 );
            PtSetResources( ABW_PtMTrend1, 1, args );
        }
	draw_pos = 1;
	draw_gr( dbuf, draw_pos, dbuf_sz / 5600 );

	return( Pt_CONTINUE );

	}

