/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 22/11/2009
 * Dev:  A. Docuchaev
 */


/* io-adm-drv.h */


#include <io-adm-msg.h>
#include <sys/iofunc.h>
#include <sys/dispatch.h>


#ifndef _CBD_BC_IO_ADM_DRV_H_
#define _CBD_BC_IO_ADM_DRV_H_


/* Defs */
#define IO_ADM_DRV_STATE_READY                      0x00000001ul    /* _IO_READ, _IO_WRITE, IO_DEVCTL allowed */
#define IO_ADM_DRV_STATE_IRQ_ENABLED                0x00000002ul    /* IRQ enabled */
#define IO_ADM_DRV_STATE_DEV_STARTED                0x00000004ul    /* Device is started */
#define IO_ADM_DRV_STATE_DEV_DETECTED               0x00000100ul
#define IO_ADM_DRV_STATE_DEV_INITED                 0x00000200ul
#define IO_ADM_DRV_STATE_DEV_MEM_ALLOCATED          0x00000400ul

#define IO_ADM_DRV_DESCRIPTOR_INIT( desc )          \
    desc.io_adm_drv_init        = io_adm_drv_init;  \
    desc.io_adm_drv_destroy     = NULL;             \
    desc.io_adm_drv_open        = NULL;             \
    desc.io_adm_drv_close       = NULL;             \
    desc.io_adm_drv_write       = NULL;             \
    desc.io_adm_drv_read        = NULL;             \
    desc.io_adm_drv_devctl      = NULL;             \
    desc.device_idx             = 0;                \
    desc.device_state           = 0;                \
    desc.adc_data_received      = 0;                \
    desc.adc_data_readed        = 0;                \
    desc.dac_data_transmitted   = 0;

#define IO_ADM_DRV_DESCRIPTOR_CLEAR_STATS( desc )   \
    desc.adc_data_received      = 0;                \
    desc.adc_data_readed        = 0;                \
    desc.dac_data_transmitted   = 0;


/* Types */

/*
 * In: Options
 * Out: Driver descriptor == Device descriptor
 */
typedef void *(*io_adm_drv_init_t)( char * );

/*
 * In: Device descriptor
 */
typedef void  (*io_adm_drv_destroy_t)( void * );

/*
 * In: Device descriptor
 * Out: 0 - ok
 *      !0 - error
 */
typedef int   (*io_adm_drv_open_t)( void * );

/*
 * In: Device descriptor
 */
typedef void  (*io_adm_drv_close_t)( void * );

/*
 * In: Device descriptor
 *     Message pointer
 *     Message size
 * Out: 0 - ok
 *      !0 - error
 */
typedef int   (*io_adm_drv_write_t)( void *, void *, uint32_t );

/*
 * In: Device descriptor
 *     Message pointer
 *     Message size
 * Out: N - number of bytes
 *      0 - error
 */
typedef int   (*io_adm_drv_read_t)( void *, void *, uint32_t );

/*
 * In: Device descriptor
 *     Message pointer
 *     Data pointer
 * Out: 0 - ok
 */
typedef int   (*io_adm_drv_devctl_t)( void *, io_devctl_t *, void * );

typedef struct io_adm_drv_descriptor {

    /* Device */
    uint8_t                 device_idx;
    uint32_t                device_state;

    /* Statistics */
    volatile uint64_t       adc_data_received;
    volatile uint64_t       adc_data_readed;
    volatile uint64_t       dac_data_transmitted;

    /* Callbacks */
    io_adm_drv_init_t       io_adm_drv_init;
    io_adm_drv_destroy_t    io_adm_drv_destroy;
    io_adm_drv_open_t       io_adm_drv_open;
    io_adm_drv_close_t      io_adm_drv_close;
    io_adm_drv_write_t      io_adm_drv_write;
    io_adm_drv_read_t       io_adm_drv_read;
    io_adm_drv_devctl_t     io_adm_drv_devctl;

} __attribute__ ((__packed__)) io_adm_drv_descriptor_t;


#endif  /* _CBD_BC_IO_ADM_DRV_H_ */
