/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 20/11/2009
 * Dev:  A. Docuchaev
 */


/* resmgr.c */


#include "io-adm-internal.h"

#include <ioadm.h>


dispatch_t                  *dpp;
resmgr_attr_t               resmgr_attr;
resmgr_context_t            *ctp;
int                         id;
resmgr_connect_funcs_t      connect_funcs;
resmgr_io_funcs_t           io_funcs;
iofunc_attr_t               attr;

void io_adm_termninate( int sig )
{
    int                     i = 0;

    for ( i = 0; i < io_adm->drivers; i++ ) {
        if ( io_adm->dll_desc[i].drv_descriptor->io_adm_drv_destroy )
            io_adm->dll_desc[i].drv_descriptor->io_adm_drv_destroy(
                        (void *)io_adm->dll_desc[i].drv_descriptor );
        io_adm->dll_desc[i].drv_descriptor->io_adm_drv_destroy = NULL;
    }

    signal( sig, SIG_DFL );
    kill( getpid(), sig );
}

void io_adm_init( io_adm_t *io_adm )
{
    char                    dev[100];
    int                     i = 0;

    /* Set signal-handlers */
    signal( SIGTERM, io_adm_termninate );
    signal( SIGINT,  io_adm_termninate );
    signal( SIGABRT, io_adm_termninate );

    /* Initialize dispatch interface */
    if ( (dpp = dispatch_create()) == NULL ) {
       MSG( ERRF, "Error: Unable to allocate dispatch handle\n" );
       exit( -1 );
    }

    /* Initialize resource manager attributes */
    memset( &resmgr_attr, 0, sizeof resmgr_attr );
    resmgr_attr.nparts_max = 1;
    resmgr_attr.msg_max_size = 2048;

    /* Initialize functions for handling messages */
    iofunc_func_init( _RESMGR_CONNECT_NFUNCS, &connect_funcs,
                      _RESMGR_IO_NFUNCS, &io_funcs );

    /* Override functions */
    connect_funcs.open = io_adm_open;
    io_funcs.close_dup = io_adm_close;
    io_funcs.read      = io_adm_read;
    io_funcs.write     = io_adm_write;
    io_funcs.stat      = io_adm_stat;
    io_funcs.devctl    = io_adm_devctl;

    /* Initialize attribute structure */
    iofunc_attr_init( &attr, S_IFDIR | 0777, 0, 0 );
    attr.inode  = IO_ADM_MAX_DEVICE_COUNT + 12;
    attr.nbytes = /*io_adm->mem_sz*/IO_ADM_MAX_DEVICE_COUNT;

    for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {
        iofunc_attr_init( &io_adm->dll_desc[i].attr, S_IFREG | 0666, 0, 0 );
        io_adm->dll_desc[i].attr.inode  = i + 1;
        io_adm->dll_desc[i].attr.nbytes = io_adm->mem_sz;
    }

    /* Attach device name */
    sprintf( dev, "/dev/io-adm" );
    if ( (id = resmgr_attach( dpp, &resmgr_attr,
                              dev, _FTYPE_ANY, _RESMGR_FLAG_DIR, &connect_funcs,
                              &io_funcs, &attr)) == -1 ) {
        MSG( ERRF, "Error: Unable to attach name\n" );
        exit( -1 );
    }

    /* Allocate a context structure */
    ctp = resmgr_context_alloc( dpp );
}

void io_adm_event( io_adm_t *io_adm )
{
    /* Start the resource manager message loop */
    while ( 1 ) {
        if ( (ctp = resmgr_block( ctp )) == NULL )
           exit( -1 );
        resmgr_handler( ctp );
    }
}

int io_adm_open( resmgr_context_t *ctp, io_open_t *msg, RESMGR_HANDLE_T *handle, void *extra )
{
    int                     i = 0;

    if ( msg->connect.path[0] == 0 )
        return iofunc_open_default( ctp, msg, handle, extra );

    for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

        if ( io_adm->dll_desc[i].loaded )
            if ( strstr( io_adm->dll_desc[i].devname, msg->connect.path ) != NULL )
                return io_adm_drv_open( ctp, msg, &io_adm->dll_desc[i].attr, extra, &io_adm->dll_desc[i] );

    }

    return (EINVAL);
}

int io_adm_close( resmgr_context_t *ctp, io_close_t *msg, RESMGR_OCB_T *ocb )
{
    int                     i = 0;

    if ( S_ISDIR( ocb->attr->mode ) )
        iofunc_close_dup_default( ctp, msg, ocb );

    for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

        if ( ocb->attr->inode == io_adm->dll_desc[i].attr.inode )
            if ( io_adm->dll_desc[i].loaded ) {
                return io_adm_drv_close( ctp, msg, ocb, &io_adm->dll_desc[i] );
            } else return (EINVAL);

    }

    return (EINVAL);
}

int io_adm_read( resmgr_context_t *ctp, io_read_t *msg, RESMGR_OCB_T *ocb )
{
    int                     i   = 0;

    if ( (i = iofunc_read_verify( ctp, msg, ocb, NULL )) != EOK )
        return (i);

    if ( S_ISDIR( ocb->attr->mode ) ) {             /* Directory */

        int                 nbytes     = 0;
        int                 nleft      = 0;
        struct dirent       *dp        = NULL;
        char                *reply_msg = NULL;

        #define dirent_align( x )                           \
            ( ( ( x ) + 3 ) & ~3 )
        #define dirent_sz( dev_name )                       \
            ( dirent_align( sizeof( struct dirent ) - 4 + strlen( dev_name ) ) )
        #define dirent_cpy( dp, inode, offset, devname )    \
            dp->d_ino    = inode;                           \
            dp->d_offset = offset;                          \
            strcpy( dp->d_name, devname );                  \
            dp->d_namelen = strlen( dp->d_name );           \
            dp->d_reclen = dirent_sz( dp->d_name );

        /* Get directory content */
        reply_msg = calloc( 1, msg->i.nbytes );
        if ( reply_msg == NULL )
            return (ENOMEM);

        dp = (struct dirent *)reply_msg;
        nleft = msg->i.nbytes;

        for ( i = ocb->offset; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

            if ( io_adm->dll_desc[i].loaded ) {

                nbytes = dirent_sz( io_adm->dll_desc[i].devname );

                if ( nleft - nbytes >= 0 ) {

                    dirent_cpy( dp, io_adm->dll_desc[i].attr.inode, ocb->offset, io_adm->dll_desc[i].devname );
                    dp = ((struct dirent *)((char *)dp + dp->d_reclen));
                    ocb->offset++;
                    nleft -= nbytes;
                    break;

                } else break;

            }

        }


        MsgReply( ctp->rcvid, (char *)dp - reply_msg, reply_msg, (char *)dp - reply_msg );
        free( reply_msg );
        return (_RESMGR_NOREPLY);

        #undef dirent_cpy
        #undef dirent_sz
        #undef dirent_align

    } else if ( S_ISREG( ocb->attr->mode ) ) {      /* Device file */

        for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

            if ( ocb->attr->inode == io_adm->dll_desc[i].attr.inode )
                if ( io_adm->dll_desc[i].loaded ) {
                    return io_adm_drv_read( ctp, msg, ocb, &io_adm->dll_desc[i] );
                } else return (EINVAL);

        }

    }

    return (EBADF);
}

int io_adm_write( resmgr_context_t *ctp, io_write_t *msg, RESMGR_OCB_T *ocb )
{
    int                     i   = 0;

    if ( (i = iofunc_write_verify( ctp, msg, ocb, NULL )) != EOK )
        return (i);

    if ( S_ISDIR( ocb->attr->mode ) )               /* Directory */
        return (EINVAL);
    else if ( S_ISREG( ocb->attr->mode ) ) {      /* Device file */

        for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

            if ( ocb->attr->inode == io_adm->dll_desc[i].attr.inode )
                if ( io_adm->dll_desc[i].loaded ) {
                    return io_adm_drv_write( ctp, msg, ocb, &io_adm->dll_desc[i] );
                } else return (EINVAL);

        }

    }

    return (EBADF);
}

int io_adm_stat( resmgr_context_t *ctp, io_stat_t *msg, RESMGR_OCB_T *ocb )
{
    int                     i   = 0;

    if ( S_ISDIR( ocb->attr->mode ) )               /* Directory */
        return  iofunc_stat_default( ctp, msg, ocb );
    else if ( S_ISREG( ocb->attr->mode ) ) {        /* Device file */

        for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

            if ( ocb->attr->inode == io_adm->dll_desc[i].attr.inode ) {

                if ( io_adm->dll_desc[i].loaded ) {
                    io_devctl_t msg1;

                    /* File mode */
                    ocb->attr->mode &= ~0777;
                    msg1.i.dcmd = DCMD_IOADM_GET_BUFF_MODE;
                    io_adm->dll_desc[i].drv_descriptor->io_adm_drv_devctl( NULL, &msg1, NULL );
                    if ( msg1.o.ret_val & LIBMODE_BUFPERM_R )
                        ocb->attr->mode |= 0444;
                    if ( msg1.o.ret_val & LIBMODE_BUFPERM_W )
                        ocb->attr->mode |= 0222;

                    /* File size */
                    uint32_t    sz = 0;
                    msg1.i.dcmd = DCMD_IOADM_GET_AVAIL_DATA_SZ;
                    io_adm->dll_desc[i].drv_descriptor->io_adm_drv_devctl( NULL, &msg1, &sz );
                    ocb->attr->nbytes = sz;
                } else {
                    ocb->attr->mode = 0;
                    ocb->attr->nbytes = 0;
                }
                break;

            }

        }

        return  iofunc_stat_default( ctp, msg, ocb );

    }

    return (EINVAL);
}

int io_adm_devctl( resmgr_context_t *ctp, io_devctl_t *msg, RESMGR_OCB_T *ocb )
{
    int                     status = 0;
    struct {
        int                 data;
    }                       *internal_io_adm_data;

    if ( (status = iofunc_devctl_default( ctp, msg, ocb )) != _RESMGR_DEFAULT )
        return status;

    status               = 0;
    internal_io_adm_data = ((void *)(16 + (int)(msg)));

    switch ( msg->i.dcmd ) {
        /*case ???_???_???:
            internal_io_adm_data = ...;
            break;*/
        default:
            if ( S_ISREG( ocb->attr->mode ) ) {
                int         i = 0;

                for ( i = 0; i < IO_ADM_MAX_DEVICE_COUNT; i++ ) {

                    if ( ocb->attr->inode == io_adm->dll_desc[i].attr.inode )
                        if ( io_adm->dll_desc[i].loaded ) {
                            return io_adm_drv_devctl( ctp, msg, ocb, &io_adm->dll_desc[i] );
                        } else return (EINVAL);

                }
                return (EINVAL);

            }

            if ( io_adm->verbose )
                MSG ( ERRF, "Error: unsupported DCMD\n" );
            return (EINVAL);
    }

    return (_RESMGR_PTR( ctp, &msg->o, sizeof( msg->o ) + msg->o.nbytes ));
}
