/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 20/11/2009
 * Dev:  A. Docuchaev
 */


/* io-adm-internal.h */


#include "version.h"

#include <io-adm-msg.h>
#include <io-adm-drv.h>
#include <ioadm.h>

#include <stdint.h>
#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>
#include <errno.h>
#include <dlfcn.h>
#include <signal.h>
#include <pthread.h>
#include <process.h>
#include <devctl.h>
#include <dirent.h>
#include <sys/neutrino.h>
#include <sys/types.h>
#include <sys/procmgr.h>
#include <sys/iofunc.h>
#include <sys/dispatch.h>



#ifndef _CBD_BC_IO_ADM_INTERNAL_H_
#define _CBD_BC_IO_ADM_INTERNAL_H_


/* Defs */
#define IO_ADM_MAX_DEVICE_COUNT         16

#define IO_ADM_ATTR_NB_DEFAULT          4096
#define IO_ADM_ATTR_PRIORITY_DEFAULT    30
#define IO_ADM_ATTR_POLICY_DEFAULT      SCHED_RR

#define IO_ADM_DRV_PATH                 "/lib/dll/"

#define MSG                             fprintf
#define ERRF                            stderr
#define STDF                            stdout


/* Types */

typedef struct io_adm {

    /* Resmgr */
    int                             priority;
    int                             policy;

    /* Mode */
    uint8_t                         verbose     : 1;
    uint32_t                        mem_sz;

    /* Drivers */
    uint8_t                         drivers;                    /* Count of loaded drivers */
    struct io_adm_driver {

        char                        *dll_name;                  /* Driver DLL name */
        char                        *dll_options;               /* Driver options */
        void                        *dll;                       /* DLL ptr */
        char                        devname[_POSIX_PATH_MAX];   /* Device name */
        io_adm_drv_descriptor_t     *drv_descriptor;            /* Driver descriptor record */
        uint8_t                     blocked     : 1;            /* Driver is opened */
        uint8_t                     loaded      : 1;            /* Driver is loaded */

        /* Resmgr */
        iofunc_attr_t                   attr;

    }                               dll_desc[ IO_ADM_MAX_DEVICE_COUNT ];

} __attribute__ ((__packed__)) io_adm_t;


/* Variables */

extern io_adm_t                     *io_adm;


/* Functions */

/* resmgr.c */
void io_adm_init( io_adm_t *io_adm );
void io_adm_event( io_adm_t *io_adm );
int io_adm_open( resmgr_context_t *ctp, io_open_t *msg, RESMGR_HANDLE_T *handle, void *extra );
int io_adm_close( resmgr_context_t *ctp, io_close_t *msg, RESMGR_OCB_T *ocb );
int io_adm_read( resmgr_context_t *ctp, io_read_t *msg, RESMGR_OCB_T *ocb );
int io_adm_write( resmgr_context_t *ctp, io_write_t *msg, RESMGR_OCB_T *ocb );
int io_adm_stat( resmgr_context_t *ctp, io_stat_t *msg, RESMGR_OCB_T *ocb );
int io_adm_devctl( resmgr_context_t *ctp, io_devctl_t *msg, RESMGR_OCB_T *ocb );

/* drvpool.c */
void io_adm_drv_init( struct io_adm_driver *drv );
int io_adm_drv_open( resmgr_context_t *ctp, io_open_t *msg, RESMGR_HANDLE_T *handle, void *extra, struct io_adm_driver *drv_ );
int io_adm_drv_close( resmgr_context_t *ctp, io_close_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ );
int io_adm_drv_read( resmgr_context_t *ctp, io_read_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ );
int io_adm_drv_write( resmgr_context_t *ctp, io_write_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ );
int io_adm_drv_devctl( resmgr_context_t *ctp, io_devctl_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ );


#endif  /* _CBD_BC_IO_ADM_INTERNAL_H_ */
