/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 11/01/2010
 * Dev:  A. Docuchaev
 */


/* drvpool.c */


#include "io-adm-internal.h"


void io_adm_drv_init( struct io_adm_driver *drv )
{
    sprintf( drv->devname, "%s%u", drv->dll_name, drv->drv_descriptor->device_idx );

    drv->loaded = 1;
}

int io_adm_drv_open( resmgr_context_t *ctp, io_open_t *msg, RESMGR_HANDLE_T *handle, void *extra, struct io_adm_driver *drv_ )
{
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( drv->blocked )
        return (ENOMEM);

    drv->blocked = 1;

    if ( drv->drv_descriptor->io_adm_drv_open )
        if ( drv->drv_descriptor->io_adm_drv_open(
           (void *)drv->drv_descriptor ) != 0 )
            return (EINVAL);

    return iofunc_open_default( ctp, msg, handle, extra );
}

int io_adm_drv_close( resmgr_context_t *ctp, io_close_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    drv->blocked = 0;

    if ( drv->drv_descriptor->io_adm_drv_close )
        drv->drv_descriptor->io_adm_drv_close(
                    (void *)drv->drv_descriptor );

    return iofunc_close_dup_default( ctp, msg, ocb );
}

int io_adm_drv_read( resmgr_context_t *ctp, io_read_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status      = iofunc_read_verify( ctp, msg, ocb, NULL );
    int                     nbytes      = 0;
    void                    *io_adm_msg = (void *)((int)msg + 16);
    struct io_adm_driver    *drv        = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0) ||
         ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) )
        return ( EACCES );

    if ( status != EOK )
        return status;

    if ( (msg->i.xtype & _IO_XTYPE_MASK) != _IO_XTYPE_NONE )
        return (ENOSYS);

    if ( !drv->drv_descriptor->io_adm_drv_read )
        return (EINVAL);

    status = drv->drv_descriptor->io_adm_drv_read( (void *)drv->drv_descriptor,
                                                   io_adm_msg,
                                                   msg->i.nbytes );

    if ( status == 0 )
        return (EINVAL);

    nbytes = min( msg->i.nbytes, status );
    nbytes = min( nbytes, ocb->attr->nbytes - ocb->offset );

    if ( nbytes > 0 ) {

        SETIOV( ctp->iov, io_adm_msg, nbytes );
        _IO_SET_READ_NBYTES( ctp, nbytes );

    } else
        _IO_SET_READ_NBYTES( ctp, 0 );

    if ( msg->i.nbytes > 0 )
        ocb->attr->flags |= IOFUNC_ATTR_ATIME;

    if ( nbytes > 0 )
        return (_RESMGR_NPARTS( 1 ));
    else
        return (_RESMGR_NPARTS( 0 ));
}

int io_adm_drv_write( resmgr_context_t *ctp, io_write_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status      = iofunc_write_verify( ctp, msg, ocb, NULL );
    void                    *io_adm_msg = (void *)((int)msg + 16);
    struct io_adm_driver    *drv        = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0) ||
         ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) )
        return ( EACCES );

    if ( status != EOK )
        return status;

    if ( (msg->i.xtype & _IO_XTYPE_MASK) != _IO_XTYPE_NONE )
        return (ENOSYS);

    if ( !drv->drv_descriptor->io_adm_drv_write )
        return (EINVAL);

    status = drv->drv_descriptor->io_adm_drv_write( (void *)drv->drv_descriptor,
                                                    io_adm_msg,
                                                    msg->i.nbytes );

    if ( status != 0 )
        return (EINVAL);

    return (EOK);
}

int io_adm_drv_devctl( resmgr_context_t *ctp, io_devctl_t *msg, RESMGR_OCB_T *ocb, struct io_adm_driver *drv_ )
{
    int                     status = 0;
    struct {
        int                 data;
    }                       *internal_io_adm_data;
    struct io_adm_driver    *drv = drv_;

    if ( drv == NULL )
        return (ENOMEM);

    if ( (status = iofunc_devctl_default( ctp, msg, ocb )) != _RESMGR_DEFAULT )
        return status;

    status               = 0;
    internal_io_adm_data = ((void *)(16 + (int)(msg)));

    switch ( msg->i.dcmd ) {
        /*case ???_???_???:
            internal_io_adm_data = ...;
            break;*/
        default:
            if ( (drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_READY) == 0 )
                return ( EACCES );
            if ( ((drv->drv_descriptor->device_state & IO_ADM_DRV_STATE_DEV_STARTED) == 0) && 
                 (msg->i.dcmd == DCMD_IOADM_GET_SHMOBJECT_RD) )
                return ( EACCES );

            if ( !drv->drv_descriptor->io_adm_drv_devctl )
                return (EINVAL);
            if ( drv->drv_descriptor->io_adm_drv_devctl( (void *)drv->drv_descriptor,
                                                         msg,
                                                         (void *)internal_io_adm_data ) != 0 )
                return (EINVAL);
    }

    return (_RESMGR_PTR( ctp, &msg->o, sizeof( msg->o ) + msg->o.nbytes ));
}
