/*
 * (c) CBD BC, Russia, Spb.
 *
 * Mail: support@kpda.ru
 *
 * Date: 23/11/2009
 * Dev:  A. Docuchaev
 */


/* l783m_msg.h */


#include <io-adm-msg.h>


#ifndef _CBD_BC_IO_ADM_L783M_MSG_H_
#define _CBD_BC_IO_ADM_L783M_MSG_H_


    /* Defines */

    /* see DCMD_IOADM_SET_CHANNEL and <l783m_msg_channel_t>.mode */
    #define L783M_CHANNEL_PRESET                0x80    /* Do not calculate hex-code (use "x" field)  */
    #define L783M_CHANNEL_DIFFERENTIAL          0x01    /* Differential-in */
    #define L783M_CHANNEL_SINGLE_ENDED          0x02    /* Single-ended-in */
    #define L783M_CHANNEL_CALIBRATION           0x10    /* Zero calibration */

    /* see DCMD_IOADM_SET_SYNC and <l783m_msg_>.mode */
    /* Type of Sync */
    #define L783M_SYNC_MODE_NONE                0x00    /* Default */
    #define L783M_SYNC_MODE_DIGITAL             0x10    /* Digital Sync */
    #define L783M_SYNC_MODE_ANALOG              0x20    /* Analog Sync */
    #define L783M_SYNC_MODE_FRAME               0x80    /* Per-Frame Sync */
    /* Sub-type of Sync */
    #define L783M_SYNC_MODE_HIGH                0x00    /* High level */
    #define L783M_SYNC_MODE_LOW                 0x01    /* Low level */
    #define L783M_SYNC_MODE_RISE                0x02    /* Rising edge */
    #define L783M_SYNC_MODE_FALL                0x03    /* Falling edge */


    /* Types */

    /* Custom message */
    typedef struct l783m_msg {

        char                    data[256];              /* Any data */

    } __attribute__ ((__packed__)) l783m_msg_t;

    /* DCMD_IOADM_SET_CHANNEL message */
    typedef struct l783m_msg_channel {
        int                         index;              /* Channel index in the table */
        int                         mode;               /* Channel mode */
        int                         input;              /* Channel number */
        int                         gain;               /* Gain */
        int                         ctrl;               /* Digital lines */
        int                         sample;             /* Sample value */
        int                         x;                  /* see L783M_CHANNEL_PRESET */
    } __attribute__ ((__packed__)) l783m_msg_channel_t;

    /* DCMD_IOADM_SET_IN_BUFF message */
    typedef struct l783m_buff_info {
        int                         frag_sz;            /* Fragmentation size */
        int                         buf_sz;             /* Buffer size */
    } __attribute__ ((__packed__)) l783m_buff_info_t;

    /* DCMD_IOADM_SET_TIMING message */
    typedef struct l783m_msg_timing_params {
        int                         channel_rate;       /* Channel rate */
        int                         frame_rate;         /* Frame rate */
    } __attribute__ ((__packed__)) l783m_msg_timing_params_t;

    /* DCMD_IOADM_SET_SYNC message */
    typedef struct l783m_msg_sync {
        int                         mode;               /* Sync mode */
        int                         channel;            /* Number of the channel */
        int                         threshold;          /* Threshold */
    } __attribute__ ((__packed__)) l783m_msg_sync_t;

    /* DCMD_IOADM_GET_SAMPLE_RANGES message */
    typedef struct l783m_msg_sample_ranges {
        int                         gain;               /* In: channel gain */
        int                         sample_val_min;     /* Out: Min sample value */
        int                         sample_val_max;     /* Out: Max sample value */
        int                         u_min;              /* Out: Min voltage */
        int                         u_max;              /* Out: Max voltage */
    } __attribute__ ((__packed__)) l783m_msg_sample_ranges_t;


#endif  /* _CBD_BC_IO_ADM_L783M_MSG_H_ */
