{ ********************************************************************  }
{  ᭮ ணࠬ  ࠡ c ⮩ L-783                  			}
{ ********************************************************************  }
.MODULE/ABS=0/SEG=int_pm_user                 main_program;

#include "const.h"
#include "var.h"

{ ********************************************************************  }
{    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  }
{ *********************************************************************	}
{ 	RESET 																					}
StartLab:
	JUMP Start; NOP; NOP; NOP;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 IRQ2	(  )									}
{ *********************************************************************	}
	JUMP Irq2Handler; NOP; NOP; NOP;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 IRQL1     	                              		}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 IRQL0   	                              		}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 SPORT0 Transmit ()									}
{ *********************************************************************	}
	SI=PM(I4, M4);	TX0=SI; DM(DacFifoPointer)=I4; RTI;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 SPORT0 Receive											}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ *********************************************************************	}
{ 	ࠡ稪 뢠 IRQE  												}
{ *********************************************************************	}
IrqE_Handler:
	RTI;
	IO(SetChannel)=MR1;
	MR1=IO(ReadADC);
	DM(I3, M3)=MR1;

{ *********************************************************************	}
{	ࠡ稪 뢠 BDMA															}
{ *********************************************************************	}
BDMA_Handler:
	RTI;	NOP; NOP; NOP;

{ *********************************************************************	}
{ ࠡ稪 뢠 SPORT1 Transmit  IRQ1 ( ᨭ஭)}
{ *********************************************************************	}
	DM(Sport1_Ctrl_Reg)=MY0; RTI; NOP; NOP;

{ *********************************************************************	}
{ ࠡ稪 뢠 SPORT1 Receive  IRQ0                  			}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ *********************************************************************	}
{	ࠡ稪 뢠 Timer														}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ *********************************************************************	}
{	ࠡ稪 뢠 Powerdown													}
{ *********************************************************************	}
	RTI; NOP; NOP; NOP;

{ After DSP RESET we appear to be here                                  }
Start:
	DIS SEC_REG;			{ ३    ॣ஢					}

	AR=0x5555; DM(TMode1)=AR;
	AR=0xAAAA; DM(TMode2)=AR;

{ Set Wait State for ALL External Devices                   				}
	AR = 0x0001;						{ 0000 0000 0000 0001 						}
	DM(Dm_Wait_Reg) = AR;			{ 0x3FFE - Waitstate Control Register 	}

{ SPORT0 - disable, SPORT1 - disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1}
	AR=0x0;
	DM(Sys_Ctrl_Reg)=AR;				{ 0x3FFF - System Control Register 		}

{ *********************************************************************	}
{ 	Set SPORT0 for transmit digital codes in DAC                    	 	}
{ 	SCLK and Transmit Frame - internal, word = 16 bits                	}
{ 	Serial Clock Divide Modulus 														}
	AR = DM(SCLK0_DIV);				{ SCLK0 period = 400 ns						}
	DM(Sport0_Sclkdiv) = AR;		{ 0x3FF5 - Serial Clock Divide Modulus	}

{ Receive Frame Sync Divide Modulus 												}
	AR = DM(DAC_Rate);		{ ।  뢮 ⮢  '	}
	DM(Sport0_Rfsdiv) = AR; { 0x3FF4 - Receive Frame Sync Divide Modulus }

{ Control word for SPORT1 : SCLK - internal 										}
{ low level, alternate internal receive frame on each word(16 bit) 		}
{ low level, alternate external transmit frame on each word(16 bit)		}
	AR = 0x7DCF;						{ 0111 1101 1100 1111						}
	DM(Sport0_Ctrl_Reg) = AR;		{ 0x3FF6 - SPORT0 Control Register		}
{ *********************************************************************	}

{ *********************************************************************	}
{ * Set SPORT1 for start of ADC chip	                           	 *	}
{ Serial Clock Divide Modulus 														}
	AR = DM(ADC_Rate);			{  ᪠ 							}
	DM(Sport1_Sclkdiv) = AR;	{ 0x3FF1 - Serial Clock Divide Modulus		}

{ Receive Frame Sync Divide Modulus 												}
	AR = 0xF;					{ RFS period = 16 SCLK	 							}
	DM(Sport1_Rfsdiv) = AR;	{ 0x3FF0 - Receive Frame Sync Divide Modulus	}

{ Control word for SPORT1 : SCLK - external 										}
{ high level, alternate internal receive frame on each word(16 bit)		}
{ high level, alternate internal transmit frame on each word(16 bit)		}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}
{ *********************************************************************	}

{ IRQ0, IRQ1, IRQ2 - negative front, disable Interrupt Nesting 			}
	ICNTL=0x07;

{ প  0.35 , ⮡ ਫ ᫥ 						}
	CNTR=14;
	DO DelayAdc UNTIL CE;
DelayAdc: NOP;

{ ⨬    뢠													}
	IFC = 0xFF; NOP; NOP;

{ ⠭ 䫠 FLx  室 ﭨ										}
	RESET FL0;
	SET FL2;

{ ⠭ 䫠 PFx: PF0-PF2, PF4/IRQE, PF7/IRQ2 - 室				}
	AR=0x68;							{	0110 1000										}
	DM(Prog_Flag_Comp_Sel_Ctrl)=AR;

{  㬮砭 㬠,  ࠡ⠥  ADSP-2184									}
	DMOVLAY = 0x1; PMOVLAY = 0x1;

{ 稬 ஡ ० 㬭⥫													}
	DIS M_MODE;

{ ࠧ訬 뢠 IRQ2																}
	IMASK=DM(IMASK_VALUE); NOP;

{ ந樠㥬 室 㪠⥫  ६						}
	CALL InitAdcPointers;
	CALL InitDacPointers;

{  ᨫ     ⥪饣   ᫥饣 ⮢	}
	AR = DM(I2, M2); IO(SetChannel) = AR;
	SET FL0;	RESET FL0;
	AR = DM(I2, M2); IO(SetChannel) = AR;

{ প  0.35 , ⮡ ⠭  ࠪ					}
	CNTR = 14;
	DO DelayAdc1 UNTIL CE;
DelayAdc1: NOP;

{   ᭮ ணࠬ,    ⮢  ࠡ	}
	AR=0x1; DM(Ready)=AR;

{ SPORT0 enable, SPORT1 disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1		}
	AR = 0x1000;					 { 0001 1100 0000 0000 							}
	DM(Sys_Ctrl_Reg) = AR;      {	0x3FFF - System Control Register 		}

{ ᫨ 饭 ࠡ ,   SCLK   㤥					}
	AR=DM(ADC_Enable);
	AR= PASS AR;
	IF EQ JUMP LowFreqLoop;

{ 訬  稢 , .. ᤥ SCLK1 ७					}
	AR = 0x7F1F; 						{ 0111 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ --------------------------------------------------------------------- }
{ ᭮ 横 ணࠬ     1000.0 						}
{ --------------------------------------------------------------------- }
LowFreqLoop:
{	ய⨬   ⮬,   									}
IgnoreSample1:
	IF FLAG_IN JUMP IgnoreSample1;
	AR=DM(I2, M2);
IgnoreSample2:
	IF NOT FLAG_IN JUMP IgnoreSample2;
	IO(SetChannel)=AR;

GetKadr:
{ ⠥  ⮢  															}
	CNTR=DM(Control_Table_Lenght_2);
	DO KadrLoop UNTIL CE;
KadrLoop1:
		IF FLAG_IN JUMP KadrLoop1;
		AR=DM(I2, M2);
KadrLoop2:
		IF NOT FLAG_IN JUMP KadrLoop2;
{ 		 ᨫ     ᫥饣 				}
		IO(SetChannel)=AR;
{ 		 ஢ 祭   									}
		AR=IO(ReadADC);
		AR=AR+AY1, AY1=DM(I1,M1);
		MR=AR*MY1(SU), MY1=DM(I5,M5);
		DM(I3, M3)=MR1;

{ 		᫨ 㦭 ᣥਬ 뢠  											}
		AF=AF+1;
		AR=AX1-AF;
		IF EQ CALL MakeIrqPC;

KadrLoop:	DM(AdcFifoPointer)=I3;

KadrLoop3:
	IF FLAG_IN JUMP KadrLoop3;
Lab1:
	NOP;
	AR=DM(I2, M2);
KadrLoop4:
	IF NOT FLAG_IN JUMP KadrLoop4;
{	 ᨫ     ᫥饣 				}
	IO(SetChannel)=AR;
{	 ஢ 祭   									}
	AR=IO(ReadADC);
	AR=AR+AY1, AY1=DM(I1,M1);
	MR=AR*MY1(SU), MY1=DM(I5,M5);
	DM(I3, M3)=MR1;
	DM(AdcFifoPointer)=I3;

{	᫨ 㦭 ᣥਬ 뢠  											}
	AF=AF+1;
	AR=AX1-AF;
	IF EQ CALL MakeIrqPC;

KadrLoop5:
	IF FLAG_IN JUMP KadrLoop5;
	AR=DM(I2, M2);
KadrLoop6:
	IF NOT FLAG_IN JUMP KadrLoop6;
{	 ᨫ     ᫥饣 				}
	IO(SetChannel)=AR;
{	 ஢ 祭   									}
	AR=IO(ReadADC);
	AR=AR+AY1, AY1=DM(I1,M1);
	MR=AR*MY1(SU), MY1=DM(I5,M5);
	DM(I3, M3)=MR1;
	DM(AdcFifoPointer)=I3;

{	᫨ 㦭 ᣥਬ 뢠  											}
	AF=AF+1;
	AR=AX1-AF;
	IF EQ CALL MakeIrqPC;

Lab2:
{ ᫨ 㦭 ᤥ ஢ প										}
	JUMP GetKadr;
	DO DelayLoop UNTIL CE;
DelayLoop1:
		IF FLAG_IN JUMP DelayLoop1;
DelayLoop2:
		IF NOT FLAG_IN JUMP DelayLoop2;
DelayLoop: NOP;

Ignore1:
DelayLoop3:
	IF FLAG_IN JUMP DelayLoop3;

	I2 = ^Control_Table;
	AR = DM(I2, M2);
DelayLoop4:
	IF NOT FLAG_IN JUMP DelayLoop4;
	IO(SetChannel) = AR;
	SET FL0; RESET FL0;
	AR = DM(I2, M2); IO(SetChannel) = AR;

	JUMP LowFreqLoop;

{ *********************************************************************	}
{ 	ਬ 뢠  PC																}
{ *********************************************************************	}
MakeIrqPC:
{ 㧨 稪 ⮢  ࠧ襭 ஢ IRQ  PC		}
	AR= ABS AR;
	AF= PASS AR;

{ ⠭ ,  ண  뢠  祭  	}
	DM(IrqDataAddress)=I0; MODIFY(I0, M0);

{ ਬ 뢠  PC																}
IRQ_PC:
	SET FL2;
	SET FL2;

	RTS;

{ --------------------------------------------------------------------- }
{ ᭮ 横 ணࠬ     1000.0 						}
{ --------------------------------------------------------------------- }
HighFreqLoop:
	DM(AdcFifoPointer)=I3;
	AR=AX1-AF;
	IF LE CALL MakeIrqPC;
	JUMP HighFreqLoop;

{ *********************************************************************	}
{ ࠡ稪 뢠 IRQ2 (ࠡ稪  )						}
{ *********************************************************************	}
Irq2Handler:
	ENA SEC_REG;			{ ३  ன  ॣ஢					}

{   뢮  														}
	AR=DM(DAC_Value); AR= TSTBIT 15 OF AR;	IF NE JUMP SetDacSample;

	AR=DM(Command);
	AF=PASS AR;
	IF EQ JUMP Test_cmd;       				{   0					}
	AF=AF-1;
	IF EQ JUMP Load_Control_Table_cmd;		{   1					}
	AF=AF-1;
	IF EQ JUMP Enable_ADC_cmd;					{   2					}
	AF=AF-1;
	IF EQ JUMP ADC_Fifo_Config_cmd;    		{   3   				}
	AF=AF-1;
	IF EQ JUMP Set_ADC_Kadr_cmd; 				{   4					}
	AF=AF-1;
	IF EQ JUMP Enable_DAC_Stream_cmd;		{   5					}
	AF=AF-1;
	IF EQ JUMP DAC_Fifo_Config_cmd;    		{   6   				}
	AF=AF-1;
	IF EQ JUMP Set_DAC_Rate_cmd; 				{   7					}
	AF=AF-1;
	IF EQ JUMP Ad_Channel_cmd;   				{   8					}
	AF=AF-1;
	IF EQ JUMP Get_TTL_cmd;   					{   9					}
	AF=AF-1;
	IF EQ JUMP Put_TTL_cmd;   					{   10				}
	AF=AF-1;
	IF EQ JUMP Synchro_Config_cmd; 			{   11				}
	AF=AF-1;
	IF EQ JUMP Enable_IRQ_PC_cmd; 			{   12				}
	AF=AF-1;
	IF EQ JUMP IRQ_Test_cmd;   				{   13				}
	AF=AF-1;
	IF EQ JUMP Set_DSP_Type_cmd; 				{   14				}

	AR=-1;
	DM(Command)=AR;

	RTI;

{ *********************************************************************	}
{ ⭮ ⠭ ஢  '										}
{ *********************************************************************	}
SetDacSample:
	AR=DM(DAC_Value); AY0=0x1FFF; AR= AR AND AY0; DM(DAC_Value)=AR;
	TX0=AR;

	RTI;

{ *********************************************************************	}
{ ⮢ .                                                   	}
{ ᫥ 室  祩	  TestLoadVar								}
{  													  ᫮ 0xAA55		}
{ *********************************************************************	}
Test_cmd:
	AR=0xAA55;
	DM(TestLoadVar)=AR;

{ *********************************************************************	}
{ 室  ࠡ稪 뢠 IRQ2.											}
{ ᫥ 室  祩	  Command   ᫮ 0			}
{ *********************************************************************	}
EndOfCommand:
	AR=0;
	DM(Command)=AR;

	RTI;

{ *********************************************************************	}
{  㧪 ࠢ饩 ⠡												}
{ *********************************************************************	}
Load_Control_Table_cmd:
{ ⠭  몫稢 , .. ᤥ SCLK1 譨					}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

Restart_ADC:
{ প  0.35 , ⮡ ਫ ᫥ 						}
	CNTR=14;
	DO RestartLoop UNTIL CE;
RestartLoop: NOP;

{ ந樠㥬 㪠⥫  ६  								}
	CALL InitAdcPointers;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}

{  ᨫ     ᫥饣 						}
	AR = DM(I2, M2); IO(SetChannel) = AR;
	SET FL0; RESET FL0;
	AR = DM(I2, M2); IO(SetChannel) = AR;

{ 쭠 প, ⮡ ⠭  ࠪ					}
	AR=DM(FirstSampleDelay);
	CNTR=AR;
	DO RestartLoop2 UNTIL CE;
RestartLoop2: NOP;

{ ⪠ 㦭 ⥪																	}
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;
	POP PC, POP CNTR, POP LOOP;

	AR=DM(ADC_Rate);		{  ᪠ 									}
	AY0=19;              { ᫮ 19 ᮮ⢥  1000 			}
	AF=AR-AY0;
	IF LT CALL SetHighFreqLoop;
	AF= PASS AF;
	IF GE	CALL SetLowFreqLoop;

{ ⨬   뢠, ஬ SPORT0 Transmit ()				}
	IFC=0xBF; NOP;

	AR=DM(TopStack);
	TOPPCSTACK=AR;			{ ᥬ  믮塞 楤  		}

	AR=DM(ADC_Enable);
	AR= PASS AR;
	IF EQ JUMP EndOfCommand;

{ 訬  稢 , .. ᤥ SCLK1 ७					}
	AR = 0x7F1F;						{ 0111 1101 1100 1111						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

	JUMP EndOfCommand;

{ *********************************************************************	}
{ ⠭    뢠  楤 HighFreqLoop			}
{ *********************************************************************	}
SetHighFreqLoop:
	AR=^HighFreqLoop;		{ 室  楤 HighFreqLoop				}
	DM(TopStack)=AR;

{ ⠭ BDMA, ᫨  ⮣ 뫨  -஢ ᨭ஭樨		}
	CALL ResetBdmaHandler;

{ ᫨ 室, ⨬ 뢮   									}
	AR=DM(ADC_Enable);
	NONE= PASS AR;
	IF EQ RTS;

{ ᨬ 䫠 ࠧ襭 뢮    							}
	AR=0x0; DM(EnableDacStream)=AR;

{    ॣ IMASK   祭								}
	DIS INTS;
	POP STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	AY0=ASTAT;
	AR=DM(IMASK_VALUE);
	AR= SETBIT 4 OF AR;	{ ࠧ訬 뢠 IRQE								}
	AR= CLRBIT 6 OF AR;	{ ⨬ 뢠 SPORT0 Transmit ()		}
	DM(IMASK_VALUE)=AR;
	IMASK=AR;
	ASTAT=AY0;
	DIS SEC_REG;			{ ३    ॣ஢					}
	PUSH STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	IMASK=0x0; NOP; NOP;
	ENA INTS;

{ ନ㥬   AF=AF+1, MR1=DM(I2, M2) 								}
{   ⪨ IrqE_Handler															}
	AR=^IrqE_Handler;						{ 稬  ⪨ IrqE_Handler	}
	I6=AR;
	M6=1;
	L6=0;

	SR0=0xCA;
	PX=SR0;									{ 稫 8   樨	}
	SR0=0x6630;
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

{ ⨬    뢠													}
	IFC = 0xFF; NOP; NOP;

	RTS;

{ *********************************************************************	}
{ ⠭    뢠  楤 SetLowFreqLoop			}
{ *********************************************************************	}
SetLowFreqLoop:
	AR=^LowFreqLoop;		{ 室  楤 SetLowFreqLoop			}
	DM(TopStack)=AR;

{    ॣ IMASK   祭								}
	DIS INTS;
	POP STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	AY0=ASTAT;
	AR=DM(IMASK_VALUE);
	AR= CLRBIT 4 OF AR;	{ ⨬ 뢠 IRQE								}
	DM(IMASK_VALUE)=AR;
	IMASK=AR;
	ASTAT=AY0;
	DIS SEC_REG;			{ ३    ॣ஢					}
	PUSH STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	IMASK=0x0; NOP;
	ENA INTS;

{ ନ㥬   RTI   ⪨ IrqE_Handler						}
	AR=^IrqE_Handler;						{ 稬  ⪨ IrqE_Handler	}
	I6=AR;
	M6=1;
	L6=0;

	SR0=0x1F;
	PX=SR0;									{ 稫 8   樨	}
	SR0=0x0A00;
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	RTS;

{ *********************************************************************	}
{  ࠧ襭/饭 ࠡ ,  ⠪							}
{ 				 ࠧ襭/饭 ஢ 뢠  PC	}
{ *********************************************************************	}
Enable_ADC_cmd:
Enable_IRQ_PC_cmd:
{ ⠭  몫稢 , .. ᤥ SCLK1 譨					}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ ᫨ ࠧ襭,  ⨬   											}
	JUMP Restart_ADC;

{ *********************************************************************	}
{  ⠭ ६ ࠬ஢ :   								}
{ 			 ᡮ     ஢ প  	}
{ *********************************************************************	}
Set_ADC_Kadr_cmd:
{ ⠭  몫稢 , .. ᤥ SCLK1 譨					}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ Serial Clock Divide Modulus 														}
	AR = DM(ADC_Rate);			{  ᪠ 							}
	DM(Sport1_Sclkdiv) = AR;	{ 0x3FF5 - Serial Clock Divide Modulus		}

{ ⨬   																	}
	JUMP Restart_ADC;

{ *********************************************************************	}
{  ࠧ襭/饭 뢮    						}
{ *********************************************************************	}
Enable_DAC_Stream_cmd:
	AR=DM(ADC_Rate);		{  ᪠ 									}
	AY0=19;              { ᫮ 19 ᮮ⢥  1000 			}
	NONE=AR-AY0;
	IF LT CALL Set_ADC_Off;

	AR=DM(EnableDacStream);
	AR= PASS AR;
	AX0=DM(IMASK_VALUE);
	IF EQ AF= CLRBIT 6 OF AX0;
	AR= PASS AR;
	IF NE AF= SETBIT 6 OF AX0;
	AR= PASS AF;
	DM(IMASK_VALUE)=AR;

{    ॣ IMASK   祭								}
	DIS INTS;
	POP STS;
	IMASK=DM(IMASK_VALUE); NOP; NOP;
	DIS SEC_REG;			{ ३    ॣ஢					}
	PUSH STS;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	IMASK=0x0; NOP; NOP;
	ENA INTS;

{ ⠭ 㪠⥫  砫 FIFO  									}
	CALL InitDacPointers;

{ ⨬   뢠  SPORT0	Transmit								}
	IFC=0x40; NOP;

	JUMP EndOfCommand;

{ *********************************************************************	}
{ ⨬ ࠡ 																	}
{ *********************************************************************	}
Set_ADC_Off:
	AR=DM(EnableDacStream);
	AR= PASS AR;
	IF EQ RTS;

{ ⠭  몫稢 , .. ᤥ SCLK1 譨					}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{ ⨬ 																				}
	AR=0x0;
	DM(ADC_Enable)=AR;

{ প  0.4 , ⮡ ਫ ᫥ 						}
	CNTR=16;
	DO SetADCOffLoop UNTIL CE;
SetADCOffLoop: NOP;

{ ⨬    뢠													}
	IFC = 0xFF; NOP; NOP;

	RTS;

{ *********************************************************************	}
{  ⠭  뢮   								}
{ *********************************************************************	}
Set_DAC_Rate_cmd:
{ SPORT0 disable, SPORT1 disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1		}
	AR=0x0;
	DM(Sys_Ctrl_Reg)=AR;				{ 0x3FFF - System Control Register 		}

{ ⠭ 㪠⥫  砫 FIFO  									}
	CALL InitDacPointers;

{ Receive Frame Sync Divide Modulus 												}
	AR=DM(DAC_Rate);			{ ।  뢮 ⮢  	}
	AY0=17;
	AF=AR-AY0;
	IF LT AR = PASS AY0;
	DM(DAC_Rate)=AR;
	DM(Sport0_Rfsdiv) = AR;	{ 0x3FF0 - Receive Frame Sync Divide Modulus	}

{ SPORT0 enable, SPORT1 disable, SPORT1 - FI, FO, IRQ0, IRQ1, SCLK1		}
	AR = 0x1000;						{ 0001 1100 0000 0000 						}
	DM(Sys_Ctrl_Reg) = AR;        { 0x3FFF - System Control Register 		}

{ ⨬   뢠  SPORT0	Transmit								}
	IFC=0x40; NOP;

	JUMP EndOfCommand;

{ *********************************************************************	}
{	⠭ 㪠⥫	 														}
{ *********************************************************************	}
InitAdcPointers:
{  ⨯ ⠭   DSP											}
{  ADSP-2184 㦭 DSP_Type=0,      	                     			}
{   ADSP-2185 - DSP_Type=1, 		     	                     			}
{   ADSP-2186 - DSP_Type=2  		  			                    			}
	AR=DM(DSP_Type);
	AR= ABS AR;
	AF=AR-2;         		{ ६ DSP_Type  : 0, 1  2	}
	IF GT AR= PASS 0;		{  ⠭ ࠢ 0, .. ADSP-2184	}
	DM(DSP_Type)=AR;
{ ⠭ 㦭 DMOVLAY  PMOVLAY												}
	AF=AR-1;
	IF NE AR= PASS 1;
	AF= PASS AF;
	IF EQ AR= PASS 0;
	DMOVLAY=AR;
	PMOVLAY=AR;

{ ⠭ ࠬ  ४஢ 室 						}
	I0=^Control_Table;
	M0=0x1;
	L0=0x0;

	I1=^ZeroOffsetArray;
	M1=0x1;
	L1=DM(Control_Table_Lenght);

	I5=^ScaleFactorArray;
	M5=0x1;
	L5=DM(Control_Table_Lenght);
	L2=0x0;

	AR=DM(IsCorrectionEnable);
	AR= PASS AR;				{ ࠧ襭  ४஢ 室 	}
	IF EQ JUMP NoCorrection;	{ ᫨ , ⮢ ᮮ⢥騩 ᨢ	}

	CNTR=DM(Control_Table_Lenght);
	DO CtrlLoop UNTIL CE;
		AR=DM(I0, M0);
		SR=LSHIFT AR BY -6 (LO);
		M2=SR0;

{	 	Set ZeroOffset																		}
		I2=^ZeroOffset;

		MODIFY(I2,M2);
		AR=DM(I2,M2);
		DM(I1,M1)=AR;

{	 	Set ScaleFactor																	}
		I2=^ScaleFactor;
		MODIFY(I2,M2);
		AR=DM(I2,M2);
		DM(I5,M5)=AR;

CtrlLoop:  	NOP;

ContinueAdcPar:
{ Set pointer to Control_Table														}
	I2=^Control_Table;
	M2=0x1;
	L2=DM(Control_Table_Lenght);

{ Set ADC Fifo Parameters																}
	I3=DM(AdcFifoBaseAddress);
	M3=0x1;
	L3=DM(AdcFifoLength);
	DM(AdcFifoPointer)=I3;

{ ࠢ  㪠⥫, ᫨    1000.0 				}
	AR=DM(ADC_Rate);		{  ᪠ 									}
	AY0=19;              { ᫮ 19 ᮮ⢥  1000 			}
	NONE=AR-AY0;
	IF GE JUMP SkipChangeAdcPointer;
	AR=I3;
	AY0=DM(AdcFifoLength);
	AR=AR+AY0;
	AR=AR-1;
	I3=AR;

SkipChangeAdcPointer:
{ 㪠⥫    ࠡ  뢠ﬨ									}
	I0=DM(AdcFifoBaseAddress);
	M0=DM(IrqStep);
	L0=DM(AdcFifoLength);

{ 㫨 稪 ⮢  													}
	AR=0x0; DM(Counter)=AR;

{ 襬 ᮮ⢥騥 樨  横 							}
	AR=DM(Control_Table_Lenght);
	AR=AR-1;
	IF EQ JUMP KadrSizeIs1;
	AR=AR-1;
	IF EQ JUMP KadrSizeIs2;
	DM(Control_Table_Lenght_2)=AR;
	CALL KadrSizeOver2;

SetInterKadrDelay:
	AR=DM(Inter_Kadr_Delay);
	AR=PASS AR;
	IF EQ JUMP InterDelayIs0;
	AR=AR-1;
	IF EQ JUMP InterDelayIs1;
	AR=AR-1;
	IF EQ JUMP InterDelayIs2;
	CALL InterDelayOver2;

ContinueAdcPar1:
{ ᨢ 樥⮢  ४஢ ᬥ饭  					}
	I1=^ZeroOffsetArray;
	M1=0x1;
	L1=DM(Control_Table_Lenght);

{ ᨢ 樥⮢  ४஢ ⠡ 							}
	I5=^ScaleFactorArray;
	M5=0x1;
	L5=DM(Control_Table_Lenght);

{ 㫨 稪 ⮢  ࠧ襭 ஢ IRQ  PC			}
	AR=DM(AdcFifoBaseAddress);	DM(IrqDataAddress)=AR;
	AR=DM(EnableIrqValue); DM(EnableIrq)=AR;
	AR= PASS AR;
	IF NE JUMP SetIRQ;
	CALL ResetIRQ;

ContinueAdcPar2:
	DIS SEC_REG;			{ ३    ॣ஢					}
	AF= PASS 0;				{ AF - 稪 ⮢  							}
	AX1=DM(IrqStep);		{  AX1 ࠭  蠣 뢠  				}

{ 	Get ZeroOffset																			}
	AY1=DM(I1,M1);
{ 	Get Scale																				}
	MY1=DM(I5,M5);

	RTS;

{ *********************************************************************	}
{ ᫨ ४஢  㦭, ⮢ ᮮ⢥騩 ᨢ				}
{ *********************************************************************	}
NoCorrection:
	CNTR=DM(Control_Table_Lenght);
	DO CtrlLoop1 UNTIL CE;
{	 	Set ZeroOffset																		}
		AR=0x0;
		DM(I1,M1)=AR;

{	 	Set ScaleFactor																	}
		AR=0x7FFF;
		DM(I5,M5)=AR;

CtrlLoop1: 	NOP;

	JUMP ContinueAdcPar;

{ *********************************************************************	}
{ ᫨ ࠧ  1,    ⪨ GetKadr ⨬					}
{  JUMP KadrLoop5															}
{ *********************************************************************	}
KadrSizeIs1:
{ ନ㥬   JUMP KadrLoop5   ⪨ GetKadr				}
	AR=^GetKadr;							{ 稬  ⪨ GetKadr			}
	I6=AR;
	M6=1;
	L6=0;

	AR=^KadrLoop5;							{ 稬  ⪨ KadrLoop5		}
	SR1=0x0018;								{ ---- ---- 0001 10xx -  .	}
	SR0=0x000F;								{ xxxx xxxx xxxx 1111 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP SetInterKadrDelay;

{ *********************************************************************	}
{ ᫨ ࠧ  2,    ⪨ GetKadr ⨬					}
{  JUMP KadrLoop3															}
{ *********************************************************************	}
KadrSizeIs2:
{ ନ㥬   JUMP KadrLoop3   ⪨ GetKadr				}
	AR=^GetKadr;							{ 稬  ⪨ GetKadr			}
	I6=AR;
	M6=1;
	L6=0;

	AR=^KadrLoop3;							{ 稬  ⪨ KadrLoop3		}
	SR1=0x0018;								{ ---- ---- 0001 10xx -  .	}
	SR0=0x000F;								{ xxxx xxxx xxxx 1111 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP SetInterKadrDelay;

{ *********************************************************************	}
{ ᫨ ࠧ   2,    ⪨ GetKadr ⨬			}
{  CNTR=DM(Control_Table_Lenght_2)										}
{ *********************************************************************	}
KadrSizeOver2:
{ ନ㥬   CNTR=DM(Control_Table_Lenght_2)						}
{															  ⪨ GetKadr		}
	AR=^GetKadr;							{ 稬  ⪨ GetKadr			}
	I6=AR;
	M6=1;
	L6=0;

	AR=DM(Control_Table_Lenght_2);	{ 稬 ࠧ  - 2				}
	SR1=0x003C;								{ ---- ---- 0011 11xx -  .	}
	SR0=0x0005;								{ xxxx xxxx xxxx 0101      			}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	RTS;

{ *********************************************************************	}
{ ᫨ ஢ প ,    ⪨ Lab2 ⨬			}
{  JUMP GetKadr													 			}
{ *********************************************************************	}
InterDelayIs0:
{ ନ㥬   NOP   ⪨ Lab1 								}
	AR=^Lab1;								{ 稬  ⪨ Lab1				}
	I6=AR;
	M6=1;
	L6=0;

	AR=0x0;
	PX=AR;									{ 稫 8   樨	}
	PM(I6,M6)=AR;							{ ࠭  24-⮢ ᫮ 	}

{ ନ㥬   JUMP GetKadr   ⪨ Lab2						}
	AR=^Lab2;								{ 稬  ⪨ Lab2				}
	I6=AR;
	M6=1;
	L6=0;

	AR=^GetKadr;							{ 稬  ⪨ GetKadr			}
	SR1=0x0018;								{ ---- ---- 0001 10xx -  .	}
	SR0=0x000F;								{ xxxx xxxx xxxx 1111 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP ContinueAdcPar1;

{ *********************************************************************	}
{ ᫨ ஢ প ࠢ 1  SCLK1, :							}
{  -   ⪨ Lab1 ⨬  I2=^Control_Table				}
{  -   ⪨ Lab2 ⨬  JUMP LowFreqLoop	 			}
{ *********************************************************************	}
InterDelayIs1:
{ ନ㥬   I2=^Control_Table   ⪨ Lab1 				}
	AR=^Lab1;								{ 稬  ⪨ Lab1				}
	I6=AR;
	M6=1;
	L6=0;

	I7=^Control_Table;					{ 稬  ⪨ Control_Table	}
	AR=I7;
	SR1=0x0034;								{ ---- ---- 0011 01xx -  .	}
	SR0=0x0002;								{ xxxx xxxx xxxx 0010 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

{ ନ㥬   JUMP LowFreqLoop   ⪨ Lab2 				}
	AR=^Lab2;								{ 稬  ⪨ Lab2				}
	I6=AR;
	M6=1;
	L6=0;

	AR=^LowFreqLoop;						{ 稬  ⪨ LowFreqLoop	}
	SR1=0x0018;								{ ---- ---- 0001 10xx -  .	}
	SR0=0x000F;								{ xxxx xxxx xxxx 1111 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP ContinueAdcPar1;

{ *********************************************************************	}
{ ᫨ ஢ প ࠢ 2  SCLK1,    ⪨ 		}
{ Lab2 ⨬  JUMP Ignore1	 										}
{ *********************************************************************	}
InterDelayIs2:
{ ନ㥬   NOP   ⪨ Lab1 								}
	AR=^Lab1;								{ 稬  ⪨ Lab1				}
	I6=AR;
	M6=1;
	L6=0;

	AR=0x0;
	PX=AR;									{ 稫 8   樨	}
	PM(I6,M6)=AR;							{ ࠭  24-⮢ ᫮ 	}

{ ନ㥬   JUMP Ignore1   ⪨ Lab2						}
	AR=^Lab2;								{ 稬  ⪨ Lab2				}
	I6=AR;
	M6=1;
	L6=0;

	AR=^Ignore1;							{ 稬  ⪨ Ignore1			}
	SR1=0x0018;								{ ---- ---- 0001 10xx -  .	}
	SR0=0x000F;								{ xxxx xxxx xxxx 1111 -     JUMP		}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP ContinueAdcPar1;

{ *********************************************************************	}
{ ᫨ ஢ প  2  SCLK1,    ⪨ 	}
{ Lab2 ⨬  CNTR=Inter_Kadr_Delay-2								}
{ *********************************************************************	}
InterDelayOver2:
{ ନ㥬   NOP   ⪨ Lab1 								}
	AR=^Lab1;								{ 稬  ⪨ Lab1				}
	I6=AR;
	M6=1;
	L6=0;

	AR=0x0;
	PX=AR;									{ 稫 8   樨	}
	PM(I6,M6)=AR;							{ ࠭  24-⮢ ᫮ 	}

{ ନ㥬   CNTR=Inter_Kadr_Delay-2   ⪨ Lab2 		}
	AR=^Lab2;								{ 稬  ⪨ Lab2				}
	I6=AR;
	M6=1;
	L6=0;

	AR=DM(Inter_Kadr_Delay);			{ 稬 ᫮  প		}
	AR=AR-2;
	SR1=0x003C;								{ ---- ---- 0011 11xx -  .	}
	SR0=0x0005;								{ xxxx xxxx xxxx 0101      			}
	SR=SR OR LSHIFT AR BY 4(LO);
	PX=SR0;									{ 稫 8   樨	}
	AR=SR1;
	SR=LSHIFT SR0 BY -8(LO);
	SR=SR OR LSHIFT AR BY -8(HI);		{ 稫 訥 16  				}
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	RTS;

{ *********************************************************************	}
{	 ࠧ襭 ஢ IRQ     ⪨ IRQ_PC:			}
{														襬  RESET FL2	}
{ *********************************************************************	}
SetIRQ:
{ ନ㥬   RESET FL2   ⪨ IRQ_PC 						}
	AR=^IRQ_PC;								{ 稬  ⪨ IRQ_PC			}
	I6=AR;
	M6=1;
	L6=0;

	SR0=0x0F;
	PX=SR0;									{ 稫 8   樨	}
	SR0=0x0208;
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP ContinueAdcPar2;

{ *********************************************************************	}
{	 饭 ஢ IRQ     ⪨ IRQ_PC:			}
{															襬  SET FL2	}
{ *********************************************************************	}
ResetIRQ:
{ ନ㥬   SET FL2   ⪨ IRQ_PC 						}
	AR=^IRQ_PC;								{ 稬  ⪨ IRQ_PC			}
	I6=AR;
	M6=1;
	L6=0;

	SR0=0x0F;
	PX=SR0;									{ 稫 8   樨	}
	SR0=0x020C;
	PM(I6,M6)=SR0;							{ ࠭  24-⮢ ᫮ 	}

	JUMP ContinueAdcPar2;

{ *********************************************************************	}
{	⠭ 㪠⥫  														}
{ *********************************************************************	}
InitDacPointers:
{   砫   FIFO      ணࠬ PM DSP		}
{	ADSP-2184:  - PM 0x0C00 (3072), .  - 0x400 (1024)		}
{	ADSP-2185:  - PM 0x3000 (12288), .  - 0x1800 (6144)		}
{	ADSP-2186:  - PM 0x1800 (6144), .  - 0x800 (2048)		}
	AR=DM(DSP_Type);
	AF=PASS AR;
	AR=0xC00;			{  FIFO    ADSP-2184					}
	AY0=0x400;			{ ᨬ쭠  FIFO    ADSP-2184	}
   IF EQ JUMP SetDacFifoParam;
   AR=0x3000;			{  FIFO    ADSP-2185					}
	AY0=0x1000;			{ ᨬ쭠  FIFO    ADSP-2185	}
	AF=AF-1;
	IF EQ JUMP SetDacFifoParam;
	AR=0x1800;			{  FIFO    ADSP-2186					}
	AY0=0x800;			{ ᨬ쭠  FIFO    ADSP-2186	}

SetDacFifoParam:
	DM(DacFifoBaseAddress)=AR;	{  FIFO  							}
	DM(DacFifoPointer)=AR;		{ 㪠⥫  ⥪騩 뢮 				}
	AR=DM(DacFifoLength);		{ ⥪  FIFO  				}
	AF=AR-AY0;
	IF GT AR= PASS AY0;
	DM(DacFifoLength)=AR;		{  FIFO  							}

	I4=DM(DacFifoBaseAddress);
	M4=1;
	L4=DM(DacFifoLength);

	RTS;

{***********************************************************************}
{  ஢ ஢ 뢠 								}
{***********************************************************************}
IRQ_Test_cmd:
	DIS INTS;	 				{ ⨬  뢠							}

{ ⨬  ⥪ 																		}
ClearStacksIRQTest:
	POP STS, POP PC, POP CNTR, POP LOOP;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	AR=SSTAT;
	AY0=0x55;
	AR=AR AND AY0;
	AR=AR XOR AY0;
	IF NE JUMP ClearStacksIRQTest;	{ ᫨   ⥪ ⨫, 		}
												{  ਬ								}
	IMASK=0x0; NOP;      { ᪨㥬  뢠							}
	ENA INTS;  				{ ࠧ訬  뢠								}

	AR=^IRQ_PC_Test;
   AY0=^Start;
   AX0=DM(EnableIrq);
	NONE= PASS AX0;
	IF EQ	AR= PASS AY0;
	TOPPCSTACK=AR;
	DIS SEC_REG;			{ ३    ॣ஢					}
	PUSH STS;
  	ENA SEC_REG;			{ ३  ன  ॣ஢					}

	JUMP EndOfCommand;

{***********************************************************************}
{ ஢ ஢ 뢠	                        		}
{***********************************************************************}
IRQ_PC_Test:
	DIS SEC_REG;
{ ࠧ訬 ⮫쪮  뢠 IRQ2										}
	IMASK=0x200; NOP; NOP;

Loop_IRQ:
	cntr=1000;
	DO IrqPCLoop1 UNTIL CE;
		cntr=100;
		Do IrqPCLoop2 until ce;
	IrqPCLoop2: 		nop;
IrqPCLoop1:		NOP;

	RESET FL2;
	SET FL2;

	JUMP Loop_IRQ;

{-----------------------------------------------------------------------}
#include "adchanel.h"
#include "fifo.h"
#include "ttl.h"
#include "synchro.h"
{-----------------------------------------------------------------------}

{***********************************************************************}
{ ன ணࠬ  ᮮ⢥騩 ⨯ DSP                    		}
{***********************************************************************}
Set_DSP_Type_cmd:
{ ⠭  몫稢 , .. ᤥ SCLK1 譨					}
	AR = 0x3F1F; 						{ 0011 1111 0001 1111 						}
	DM(Sport1_Ctrl_Reg) = AR;		{ 0x3FF2 - SPORT1 Control Register		}

{  ⨯ ⠭   DSP											}
{  ADSP-2184 㦭 DSP_Type=0,      	                     			}
{   ADSP-2185 - DSP_Type=1, 		     	                     			}
{   ADSP-2186 - DSP_Type=2  		  			                    			}
   AR=0x3000;					{  ADSP-2185  ADSP-2186						}
   AY0=DM(DSP_Type);
   AF= PASS AY0;
   IF EQ	AR= PASS 0x2000;	{  ADSP-2184				 						}
   SI=AR;			{  ,  ।  㭪 䨪樨  	}

{ 㥬  ।⢥ ⥭   						}
{					/  , .. Reg=DM(xxxx)  DM(xxxx)=Reg	}
	I4=0x0; M4=1; L4=0; M5=1;
	AR=^Set_DSP_Type_cmd;
	CNTR=AR;
	DO ReadWriteDMLoop UNTIL CE;
		I5=I4;
		AR=PM(I4, M4);
	   AF= TSTBIT 15 OF AR;
	   IF NE CALL Test14BitDM;
ReadWriteDMLoop: NOP;

{ 㥬  ।⢥   ॣ 樨 (I0, I1, ...)		}
	I4=0x0; M4=1; L4=0; M5=1;
   AR=^Set_DSP_Type_cmd;
	CNTR=AR;
	DO LoadRegLoop UNTIL CE;
		I5=I4;
		AR=PM(I4, M4);
		AF= TSTBIT 15 OF AR;
		IF EQ CALL Test14BitI;
LoadRegLoop: NOP;

	AY0=DM(DSP_Type);
	AF= PASS AY0;
	IF EQ	JUMP SkipCopyDmData;	{  ADSP-2184			 						}

	I4=0x2800; M4=1; L4=0;
	I5=0x3800; M5=1; L5=0;
	CNTR=0x7E0;
	DO CopyDmData UNTIL CE;
		AR=DM(I4, M4);
CopyDmData:	DM(I5, M5)=AR;

SkipCopyDmData:
	DIS INTS;	 				{ ⨬  뢠							}

{ ⨬  ⥪ 																		}
ClearStacksSetDSP:
	POP STS, POP PC, POP CNTR, POP LOOP;
	ENA SEC_REG;			{ ३  ன  ॣ஢					}
	AR=SSTAT;
	AY0=0x55;
	AR=AR AND AY0;
	AR=AR XOR AY0;
	IF NE JUMP ClearStacksSetDSP;		{ ᫨   ⥪ ⨫, 		}
												{  ਬ								}
	IMASK=0x0; NOP;      { ᪨㥬  뢠							}
	ENA INTS;  				{ ࠧ訬  뢠								}

	AR=0x0;					{ ᪠ ணࠬ 							}
	TOPPCSTACK=AR;			{ ᥬ    		  					}
	IFC=0xFF; NOP; NOP;	{ ⨬    뢠					}
	DIS SEC_REG;			{ ३    ॣ஢					}
	PUSH STS;				{   ⥪										}
	ENA SEC_REG;			{ ३  ன  ॣ஢					}

{ ᫥ 室  祩	  Command   ᫮ 0			}
	AR=0;
	DM(Command)=AR;

	RTI;

{***********************************************************************}
{ ஢ઠ 14   ॣ AR	 樨 Type 3						}
{***********************************************************************}
Test14BitDM:
	   AF= TSTBIT 14 OF AR;
	   IF EQ CALL Test13BitDM;
      RTS;

{***********************************************************************}
{ ஢ઠ 13   ॣ AR	 樨 Type 3						}
{***********************************************************************}
Test13BitDM:
	   AF= TSTBIT 13 OF AR;
	   IF EQ CALL ModifyReadWriteDM;
      RTS;

{ *********************************************************************	}
{   PM     Reg=DM(0x(3/2)xxx) 			}
{						   DM(0x(3/2)xxx)=Reg ᫨   Control Register	}
{ 室:                                                     	  			}
{      I5 - , 㤠 뢠              					}
{      SI -   0x(3/2)xxx	(୥ 訥  )			}
{ *********************************************************************	}
ModifyReadWriteDM:
{ ᫨    Memory-Maped Control Register,   멤	}
	SR=LSHIFT AR BY 6 (LO);
	SR=LSHIFT SR0 BY -2 (LO);	{ 뤥   樨					}
	AY0=0x3FE0;
	NONE=SR0-AY0;
	IF GE RTS;		{ ᫨  Memory-Maped Control Register,  멤	}

{ ନ㥬   																}
   AR= CLRBIT 9 OF AR;
   AR= CLRBIT 8 OF AR;
	SR0=AR;
	SR=SR OR LSHIFT SI BY -4 (LO);
	PM(I5,M5)=SR0;							{ ࠭  24-⮢ ᫮ 	}
	RTS;

{***********************************************************************}
{ ஢ઠ 14   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test14BitI:
	   AF= TSTBIT 14 OF AR;
	   IF EQ CALL Test13BitI;
      RTS;

{***********************************************************************}
{ ஢ઠ 13   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test13BitI:
	   AF= TSTBIT 13 OF AR;
	   IF NE CALL Test12BitI;
      RTS;

{***********************************************************************}
{ ஢ઠ 12   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test12BitI:
	   AF= TSTBIT 12 OF AR;
	   IF NE CALL Test11BitI;
      RTS;

{***********************************************************************}
{ ஢ઠ 11   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test11BitI:
		MX1=AR;
		AF= TSTBIT 11 OF AR;
		IF NE CALL Test10BitIP;
		AR=MX1;
	   AF= TSTBIT 11 OF AR;
	   IF EQ CALL Test10BitID;
      RTS;

{***********************************************************************}
{ ஢ઠ 10   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test10BitIP:
	   AF= TSTBIT 10 OF AR;
	   IF EQ CALL ModifyLoadNonDataRegister;
      RTS;

{***********************************************************************}
{ ஢ઠ 10   ॣ AR	 樨 Type 7						}
{***********************************************************************}
Test10BitID:
	   AF= TSTBIT 10 OF AR;
	   IF NE CALL ModifyLoadNonDataRegister;
      RTS;

{ *********************************************************************	}
{ 㥬  ।⢥    ॣ I0...I7	}
{   PM     Ix=<data>							}
{ 室:                                                     	  			}
{      I5 - , 㤠 뢠              					}
{      SI -  祭 <data>	(୥ 訥 )					}
{ *********************************************************************	}
ModifyLoadNonDataRegister:
{ 뤥塞  ᭮ ॣ I0...I7										}
   AX0=PX;
   AY0=0x0F;
   AF=AX0 AND AY0;
   AX0=0x3;
   AF=AX0-AF;
   IF LT RTS;  { ᫨    ॣ I0...I7,  室			}

{ ନ㥬   																}
   AR= CLRBIT 9 OF AR;
   AR= CLRBIT 8 OF AR;
	SR0=AR;
	SR=SR OR LSHIFT SI BY -4 (LO);
	PM(I5,M5)=SR0;							{ ࠭  24-⮢ ᫮ 	}
	RTS;

.ENDMOD;
