#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>

#include "ramdisk.h"

char	ibuf[LZF_BUF_SIZE];
char	obuf[LZF_BUF_SIZE];

int bin2c( char *fin, char *fout )
{
	int			ch;
	unsigned	d = 0;
	int			i;
	short		icnt, ocnt;
	FILE		*ifd, *ofd;

	if ( ( ifd = fopen( fin, "rb" ) ) == NULL )
	{
		perror( "fopen()" );
		exit( -1 );
	}

	if ( ( ofd = fopen( fout, "wb" ) ) == NULL )
	{
		perror( "fopen()" );
		exit( -1 );
	}

	fprintf( ofd, "char ram_file[] = {\n" );

	while ( ! feof( ifd ) )
	{
		icnt = fread( ibuf, 1, LZF_BUF_SIZE, ifd );
		if ( icnt < 0 )
		{
			perror( "fread()" );
			exit( -1 );
		}
		if ( ! icnt )
			continue;

		// FIXME: Check compression error
		ocnt = lzf_compress( ibuf, icnt, &obuf[2], LZF_BUF_SIZE - 2 );
		obuf[1] = ( ocnt >> 8 ) & 0xFF;
		obuf[0] = ocnt & 0xFF;
//fprintf( stderr, "%d %d %d %d\n", icnt, ocnt, obuf[1], obuf[0] );

		d += ocnt + 2;

		for ( i = 0; i < ocnt + 2; i++ )
		{	
			fprintf( ofd, "0x%02X, ", obuf[i] );
			if ( !( i % 16 ) )
				fprintf( ofd, "\n" );
		}
	}

	fprintf( ofd, "};\n\n" );

	fprintf( ofd, "unsigned ram_size = %d;\n\n", d );

	fclose( ifd );
	fclose( ofd );

	return ( 0 );
}

int main( int argc, char *argv[] )
{
	if ( argc < 3 )
	{
		fprintf( stderr, "Usage: %s <binary file> <c file>\n" );
		exit( -1 );
	}

	bin2c( argv[1], argv[2] );

	return ( 0 );
}
