////////////////////////////////////////////////////
//                                                //
//               QNX 4.25 - threads               //
//                 (Realization)                  //
//                   v.1.0.0.1                    //
//                                                //
//                                                //
//    file name : pthread.h                       //
//    date : 14.03.08                             //
//                                                //
//    Description :                               //
//         ,       //
//          QNX 4,        //
//       QNX 4:                                   //
//             - pthread_mutex_*                  //
//             - pthread_*                        //
//                                                //
////////////////////////////////////////////////////

////////////////////////////////////////////////////
///////////////////// HEADERS //////////////////////
////////////////////////////////////////////////////

	// QNX headers
		#include <sys/types.h>
		#include <sys/sched.h>
		#include <process.h>
		#include <unistd.h>
		#include <signal.h>
		#include <stdio.h>
	// Author's headers
		#include "porting_signal.h"
		#include "pthread.h"

////////////////////////////////////////////////////
////////////////////// FUNCS ///////////////////////
////////////////////////////////////////////////////

	///////////////////////////////////////////////
	////////////////// THREADS ////////////////////
	///////////////////////////////////////////////

		////// "struct TThread_procedure"  "thread()"   "pthread_create"
				// !!!  :  "tfork"  3-   ,      
				//                  (    "tfork")   "int",   "Rhapsody"
				//                   "void - "
				//      :     "tfork"   ,    "int".
				//                  ("thread")         
				//                "TThread_procedure".       "void - ",   
				//                   . "thread"  "EOk"      "EFault"  
				//                .
					struct TThread_procedure {

						// Procedure address
							void *(*proc_ptr)(void *);
						// Param address
							void *									param_ptr;

					};

					int thread(void *arg) {

						try {

							TThread_procedure *							thread_procedure;
							thread_procedure = ( TThread_procedure * ) arg;
								thread_procedure -> proc_ptr( thread_procedure -> param_ptr );
							delete thread_procedure;
						return EOk;

						}
						catch ( ... ) {

							return EFault;

						}

					}


		int pthread_create(pthread_t *__thr, pthread_attr_t *__attr, void *(*__start_routine)(void *), void *__arg)
		{

			try {

				//  "tfork"
						//#include <process.h>
							//pid_t tfork( char *stk_addr, 
								//unsigned stk_size,
								//int (*func)(void *),
								//void *arg,
								//int flags );
				// !!!  :    stdout
				//      :      "flushAll()"
								//setvbuf( stdout, NULL, _IONBF, 0 );
				//      "pthread_attr_setstacksize()"
				//  
					TThread_procedure * 						thread_procedure;
						thread_procedure = new TThread_procedure;
							thread_procedure -> proc_ptr = __start_routine;
							thread_procedure -> param_ptr = __arg;
					( *__thr ) = tfork( ( char* )( __attr -> stackaddr ), __attr -> stacksize, &thread, thread_procedure, 0 );
					// !!!  :   "pthread_attr_t"       ,
					//                       "policy"  "struct sched_param".
					//      :        
						if ( __attr->inheritsched != PTHREAD_INHERIT_SCHED ) {

							sched_setscheduler( *__thr, __attr->policy, &(__attr->param) );

						}
					if ( *__thr != -1 ) {

						return EOk;

					} else {

						return EFault;

					}

			}
			catch ( ... ) {

				return EFault;

			}

		}

		pthread_t pthread_self( void )
		{

			//  "getpid"
					//#include <sys/types.h>
					//#include <unistd.h>
						//pid_t getpid( void );
			return getpid();

		}

		int pthread_cancel( pthread_t thread )
		{

			return kill( thread, SIGTERM );

		}

		void pthread_exit(void *__value_ptr)
		{

			try {

				exit ( (int) __value_ptr );

			}
			catch ( ... ) {

				exit( 0 );

			}

		}

		int pthread_kill( pthread_t thread, int sig )
		{

			return kill( thread, sig );

		}



		int pthread_attr_init(pthread_attr_t *__attr)
		{

			__attr -> flags = 0;
			__attr -> stacksize = 4*1024;		// Default stack size for QNX 6 = 4 Kb
			__attr -> stackaddr = NULL;
			__attr -> exitfunc = NULL;
			__attr -> detachstate = 0;
			__attr -> policy = 0;
			__attr -> guardsize = 0;
			__attr -> prealloc = 0;
			__attr -> spare[0] = 0;
			__attr -> spare[1] = 0;
			return EOk;

		}

		int pthread_attr_setstacksize(pthread_attr_t *__attr, size_t __stacksize)
		{

			try {

			//       "__attr"
				if ( __attr -> stackaddr != NULL ) {

					free( __attr );
					__attr = NULL;

				}

			//     
				__attr -> stacksize = __stacksize;
				__attr -> stackaddr = ( char * ) malloc( __stacksize * sizeof( char ) );
				return EOk;

			}
			catch ( ... ) {

				return EFault;

			}

		}

		int pthread_attr_setdetachstate(pthread_attr_t *__attr, int __detachstate)
		{

			__attr -> detachstate = __detachstate;
			return EOk;

		}

		int pthread_attr_setinheritsched(pthread_attr_t *__attr, int __inheritsched)
		{

			__attr -> inheritsched = __inheritsched;
			return EOk;

		}

	///////////////////////////////////////////////
	/////////////////// SHED //////////////////////
	///////////////////////////////////////////////

		int pthread_setschedparam(pthread_t __thr, int __policy, struct sched_param *__param)
		{

				//  "sched_setparam"
						//#include <sys/sched.h>
							//int sched_setscheduler( pid_t pid, int policy, struct sched_param *param );
				return sched_setscheduler( __thr, __policy, __param );

		}

		int pthread_getschedparam( const pthread_t thread, int * policy, struct sched_param * param )
		{

				//  "sched_getscheduler" -    
						//#include <sys/sched.h>
							//int sched_getscheduler( pid_t pid );
				//  "sched_getparam" -    
						//#include <sys/sched.h>
							//int sched_getparam( pid_t pid, struct sched_param *param );
				( *policy ) = sched_getscheduler( thread );
				if ( ( *policy ) != -1 )
					if ( sched_getparam( thread, param ) != -1 )
						return EOk;
				return EFault;

		}

	///////////////////////////////////////////////
	////////////////// ACCESS /////////////////////
	///////////////////////////////////////////////

		int pthread_mutex_lock( pthread_mutex_t * mutex )
		{

			//  -    
			mutex = NULL;
			return 0;

		}

		int pthread_mutex_unlock( pthread_mutex_t * mutex )
		{

			//  -    
			mutex = NULL;
			return 0;

		}

		int pthread_mutex_destroy( pthread_mutex_t * mutex )
		{

			//  -    
			mutex = NULL;
			return 0;

		}

		int pthread_mutex_init(pthread_mutex_t *__mutex, const pthread_mutexattr_t *__attr)
		{

			//  -    
			__mutex = NULL;
			__attr = NULL;
			return 0;

		}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////   SIGNALS   /////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////

		int sigpause(int __sig)
		{

			// !!!  :   "sigpause"  QNX 6  QNX 4 :
			//                QNX 6 :      int sigpause(int mask);
			//                QNX 4 :      sigset_t sigpause(sigset_t mask).
			//                ,  sizeof(sigset_t)=sizeof(int)=4,   "sigset_t":
			//                         typedef struct {
			//                                         long    nrt;
			//                                         long   rt;
			//                                        } sigset_t;*/
			//      :    -   "porting_signal.h" -> "sigpause2"
			int *							result =( int * )sigpause2( &__sig );
			return ( * result );

		}