//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OXF
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/oxf.cpp $
//!	File version	: $Revision: 1.103 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:21 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: oxf.cpp 1.103 2007/04/06 07:08:21 ilgiga Exp $";
#endif
//#]

#include "oxf.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFDllGuards.h"
#include "IOxfActive.h"
#include "IOxfMemoryAllocator.h"
#include "IOxfTickTimerFactory.h"
#include "OMAnimHelper.h"
#include "OMDelay.h"
#include "OMMainThread.h"
#include "os.h"
#include "omreactive.h"
#include "OMTimerManager.h"

//----------------------------------------------------------------------------
// oxf.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Initialization 

//## class OXF 


// Static class member attribute
bool OXF::managedTimeoutCanceling = false;
// Static class member attribute
bool OXF::rhp5CompatibleAPI = false;
// Static class member attribute
IOxfActive* OXF::theDefaultActiveClass = 0;
// Static class member attribute
IOxfMemoryAllocator* OXF::theMemoryManager = 0;
// Static class member attribute
const IOxfTickTimerFactory* OXF::theTickTimerFactory = 0;

void OXF::animDeregisterForeignThread(void * aomArg(theHandle)) {
    //#[ operation animDeregisterForeignThread(void *) 
    #ifdef _OMINSTRUMENT
    AnimServices::deregisterForeignThread(theHandle);
    #endif
    //#]
}

void OXF::animRegisterForeignThread(char* aomArg(name), void * aomArg(theHandle)) {
    //#[ operation animRegisterForeignThread(char*,void *) 
    #ifdef _OMINSTRUMENT
    AnimServices::registerForeignThread(theHandle, name);
    #endif
    //#]
}

void OXF::delay(OxfTimeUnit t) {
    //#[ operation delay(OxfTimeUnit) 
    OMDelay d(t);
    //#]
}

void OXF::end() {
    //#[ operation end() 
    #ifdef FRAMEWORK_DLL
    OXFRefLock aLock(theRefManager, false);
    if (theRefManager.Decrement() != 0)
    {
    	// Not the last reference so just return
    	return;
    }
    // Last reference so do the necessary cleanup
    theRefManager.setOxfStarted(false);
    #endif 
    
    OMOS::endProlog();
    OMThread* currentThread = OMThread::cleanupAllThreads();
    if (OMMainThread::instance(0))
    {
    	static_cast<OMThread*>(OMMainThread::instance(0))->destroyThread();
    }
    if (currentThread)
    {
    	delete currentThread;
    }
    //#]
}

bool OXF::init(int numProgArgs, char** progArgs, unsigned defaultPort, const char * defaultHost, OxfTimeUnit ticktime, 
unsigned maxTM, bool isRealTimeModel) {
    //#[ operation init(int,char*,unsigned ,const char * ,OxfTimeUnit,unsigned ,bool) 
    // activate the backward compatibility	
    setRhp5CompatibleAPI(true);
    setManagedTimeoutCanceling(true);
    supportExplicitReactiveDeletion();
    
    // initialize
    return initialize(numProgArgs,
    	progArgs,
    	defaultPort,
    	defaultHost,
    	ticktime,
    	maxTM,
    	isRealTimeModel);
    //#]
}

bool OXF::initialize(int aomArg(numProgArgs), char** aomArg(progArgs), unsigned aomArg(defaultPort), const char * 
aomArg(defaultHost), OxfTimeUnit ticktime, unsigned maxTM, bool isRealTimeModel) {
    //#[ operation initialize(int,char*,unsigned ,const char * ,OxfTimeUnit,unsigned ,bool) 
    #ifdef FRAMEWORK_DLL
    //If framework is a DLL keep track of total no. of 
    //times OXFInit(...) is called
    OXFRefLock aLock(theRefManager, false);
    if (theRefManager.Increment() > 1) {
    	//Framework is already initialized so return
    	return true;
    }
    #endif 
    
    // Currently we initialize the timer, which depends on OSFactory
    // The OSfactory is initialized by the singleton mechanism.
    // set the timer default parameter values
    if (maxTM == 0)
    {
    	maxTM = OMTimerManagerDefaults::defaultMaxTM;
    }

    if (ticktime == 0)
    {
    	ticktime = OMTimerManagerDefaults::defaultTicktime;
    }
    // create the timer
    (void) OMTimerManager::initInstance(ticktime, maxTM, isRealTimeModel);
    
    // disable the set of the timer factory
    (void) setTheTickTimerFactory(NULL);
    
    #ifdef OM_ENABLE_MEMORY_MANAGER_SWITCH
    // stop logging memory allocation
    // and cleanup the memory manager switch data, if the switch was not done
    OMMemoryManagerSwitchHelper::instance()->setUpdateState(false);
    if (OMMemoryManager::getMemoryManager() == OMMemoryManager::getDefaultMemoryManager())
    {
    	OMMemoryManagerSwitchHelper::instance()->cleanup();
    }
    #endif // OM_ENABLE_MEMORY_MANAGER_SWITCH
    
    #ifdef _OMINSTRUMENT
    // Initialize the animation (aomDispatcher (and in trace mode the tomDispatcher))
    bool animInitialized = AnimServices::init(numProgArgs, progArgs, defaultPort, defaultHost);
    if (!animInitialized)
    {
    	OMTimerManager::instance()->clearInstance();
    	return false;
    }
    AnimServices::registerAnimHelper(OMAnimHelper::instance());
    // Ensure that the default thread has the correct OS thread id
    // Required in some RTOS where the initialization of pre-main objects is -
    //   done in another (system) context
    AnimServices::resetDefaultThread(0, OMOSFactory::instance()->getCurrentThreadHandle());
    #endif 
    
    // Create the main thread (actually its OXF wrapper)
    (void)OMMainThread::instance();
    
    #ifdef _OMINSTRUMENT
    // Make sure that the main thread is set properly
    // This is required if the main thread is created in pre-main and the OS (e.g. VxWorks)
    //  initialize pre-main objects in another context (not the application main thread)
    // Since the main thread is initialized as a wrapper thread, without reset of its thread
    //   the main thread OS handle can be wrong
    OMOSThread* mainOsThread = OMMainThread::instance()->getOsThread();
    if (mainOsThread != 0)
    {
    	void* currentThread = OMOSFactory::instance()->getCurrentThreadHandle();
    	mainOsThread->resetWrapperThreadOsHandle(currentThread);
    }
    // Ensure no left over registration candidate in callstack from pre main
    AnimServices::resetCallStack(0);
    // Ensure main thread stops on first step (could be no if proxy not yet arrived).
    AnimServices::notifyFirstStep(0);
    #endif 
    
    // os specific actions to be taken after the environment is set
    OMOS::initEpilog();
    
    return true;
    //#]
}

bool OXF::setMemoryManager(IOxfMemoryAllocator* memoryManager) {
    //#[ operation setMemoryManager(IOxfMemoryAllocator) 
    #ifdef FRAMEWORK_DLL
    // prevent access from several DLLs at the same time
    OXFRefLock aLock(theRefManager, false);
    #endif
    
    bool result = false;
    bool allowManagerSwitch = false;
    
    #ifdef OM_ENABLE_MEMORY_MANAGER_SWITCH
    // allow switch of memory manager even if its already set
    allowManagerSwitch = true;
    #endif // OM_ENABLE_MEMORY_MANAGER_SWITCH
    
    if ((theMemoryManager == NULL) || allowManagerSwitch) {	//lint !e774 (Boolean within 'right side of || within if' always evaluates to False)
    	theMemoryManager = memoryManager;
    	result = true;
    }
    else {
    #ifdef _OMINSTRUMENT
    	OM_NOTIFY_TO_ERROR("ERROR: Attempt to set the memory manager failed,\n\t the memory manager is already set, and the framework was compiled without OM_ENABLE_MEMORY_MANAGER_SWITCH.\n");
    #endif
    }
    
    return result;
    //#]
}

bool OXF::setTheDefaultActiveClass(IOxfActive* t) {
    //#[ operation setTheDefaultActiveClass(IOxfActive) 
    #ifdef FRAMEWORK_DLL
    // prevent access from several DLLs at the same time
    OXFRefLock aLock(theRefManager, false);
    #endif
    
    bool result = false;
    if (theDefaultActiveClass == NULL) {
    	theDefaultActiveClass = t;
    	result = true;
    }
    else {
    #ifdef _OMINSTRUMENT
    	OM_NOTIFY_TO_ERROR("ERROR: Attempt to set the default active class failed\n\tthe efault active class already set.\n");
    #endif
    }
    return result;
    //#]
}

bool OXF::setTheTickTimerFactory(const IOxfTickTimerFactory* theFactory) {
    //#[ operation setTheTickTimerFactory(IOxfTickTimerFactory) 
    #ifdef FRAMEWORK_DLL
    // prevent access from several DLLs at the same time
    OXFRefLock aLock(theRefManager, false);
    #endif
    static bool wasSet = false;
    bool result = false;
    if (!wasSet) {
    	theTickTimerFactory = theFactory;
    	wasSet = true;
    	result = true;
    }
    else if (theFactory != NULL) {
    #ifdef _OMINSTRUMENT
    	OM_NOTIFY_TO_ERROR("ERROR: Attempt to set the timer factory failed.\n");
    #endif
    }
    return result;
    //#]
}

void OXF::start(bool doFork) {
    //#[ operation start(bool) 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyFrameworkStarted();
    #endif
    
    #ifdef FRAMEWORK_DLL
    //Note: No special handling in case of OXF::start(false) 
    //as this will block the main thread
    if (doFork)
    {
    	if (!theRefManager.getOxfStarted())
    	{
    		OXFRefLock aLock(theRefManager, false);
    		if (!theRefManager.getOxfStarted())
    		{
    			theRefManager.setOxfStarted(true);
    			if (!rhp5CompatibleAPI)
    			{
    				// normal mode
    				OMMainThread::instance()->startDispatching(true);
    			}
    			else
    			{
    				// compatibility mode
    				OMMainThread::instance()->start(1);
    			}
    		}
    		return;
    	}
    }
    #endif 
    
    // Calling the main event dispatching loop
    if (!rhp5CompatibleAPI)
    {
    	// normal mode
    	OMMainThread::instance()->startDispatching(doFork);
    }
    else
    {
    	// compatibility mode
    	OMMainThread::instance()->start(static_cast<int>(doFork));
    }
    // Note the Instrumentation threads have already been started
    // in OXF::init() or earlier (see AOMDispatcher::instance()
    //#]
}

void OXF::supportExplicitReactiveDeletion() {
    //#[ operation supportExplicitReactiveDeletion() 
    OMReactive::setGlobalSupportDirectDeletion(true);
    //#]
}

bool OXF::getManagedTimeoutCanceling() {
    return managedTimeoutCanceling;
}

void OXF::setManagedTimeoutCanceling(bool p_managedTimeoutCanceling) {
    managedTimeoutCanceling = p_managedTimeoutCanceling;
}

IOxfActive* OXF::getTheDefaultActiveClass() {
    return theDefaultActiveClass;
}

IOxfMemoryAllocator* OXF::getMemoryManager() {
    return theMemoryManager;
}

const IOxfTickTimerFactory* OXF::getTheTickTimerFactory() {
    return theTickTimerFactory;
}



//
//! Log: $Log: oxf.cpp $
//! Log: Revision 1.103  2007/04/06 07:08:21  ilgiga
//! Log: bug fix 98191
//


