//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMString
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omstring.cpp $
//!	File version	: $Revision: 1.51 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:15 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: omstring.cpp 1.51 2007/04/06 07:08:15 ilgiga Exp $";
#endif
//#]

#include "omstring.h"
#include "OXFManager.h"
#include "omunicode.h"

//----------------------------------------------------------------------------
// omstring.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::String 

//## class OMString 


// Static class member attribute
int OMString::defaultBlock = 256;

OMString::OMString(const OMString& s) : count(0) ,size(0) ,str(0) {
    //#[ operation OMString(OMString) 
    //lint -save -e668 -e613 (lint fail to identify the memory allocation by setSize())
    count = s.count;
    setSize(count + 1);
    if (count > 0) { 
    	strncpy(str, s.str,(unsigned int)count + 1);
    } 
    else { 
    	str[count] = '\0'; 
    }
    // lint -restore
    //#]
}

OMString::OMString(const char c) : count(0) ,size(0) ,str(0) {
    //#[ operation OMString(char) 
    count = 1;
    setSize(count + 1);
    //lint -save -e613 (lint fail to identify the memory allocation by setSize())
    str[0] = c;
    str[count] = '\0';
    //lint -restore
    //#]
}

OMString::OMString(const char* s) : count(0) ,size(0) ,str(0) {
    //#[ operation OMString(char*) 
    //lint -save  -e668 -e613 (lint fails to identify the memory allocation by setSize())
    if (s != 0) {
    	count = static_cast<int>(strlen(s));
    	setSize(count + 1);
    	if (count > 0) { 
    		strncpy(str, s, strlen(s) + 1);
    	} 
    	else { 
    		str[count] = '\0'; 
    	} 
    }
    else{
    	setSize(count + 1);
    	str[count]='\0';
    }
    //lint -restore
    //#]
}

OMString::OMString() : count(0) ,size(0) ,str(0) {
    //#[ operation OMString() 
    setSize(1);
    //lint -save -e613 (lint fail to identify the memory allocation by setSize())
    str[0] = '\0';
    // lint -restore
    //#]
}

OMString::~OMString() {
    //#[ operation ~OMString() 
    if (size > 0) {
    	OMDELETE(str, size);
    }
    str = 0;
    size = 0;
    count = 0;
    //#]
}

int OMString::CompareNoCase(const char* const s2) const {
    //#[ operation CompareNoCase(char*) const 
    return CompareNoCase_(str,s2);
    //#]
}

int OMString::CompareNoCase(const OMString& s) const {
    //#[ operation CompareNoCase(OMString) const 
    return CompareNoCase_(str, s.str);
    //#]
}

int OMString::CompareNoCase_(const char* const s1, const char* const s2) {
    //#[ operation CompareNoCase_(char*,char*) 
    // res = 3 - unknown
    int res = 3;
    if ((s1 != 0) && (s2 != 0)) {
    	for (int i = 0; res == 3; i++) {
    #ifndef _OM_UNICODE_ONLY
    		char d1 = (char)toupper(s1[i]);
    		char d2 = (char)toupper(s2[i]);
    #else
    		char d1 = OMtoupper(s1[i]);
    		char d2 = OMtoupper(s2[i]);
    #endif // _OM_UNICODE_ONLY
    		if (d1 < d2) {
    			res = -1;
    		}
    		else if (d1 > d2) {
    			res = 1;
    		}
    		else if (d1 == '\0') {
    			res = 0;
    		}
    	}
    }
    return res;
    //#]
}

void OMString::Empty() {
    //#[ operation Empty() 
    if (count > 0)
    {
    	count = 0;
    	// lint fails to identify the correlation between count and str
    	str[count]='\0';  //lint !e613
    }
    //#]
}

char* OMString::GetBuffer(int /**/) const {
    //#[ operation GetBuffer(int) const 
    return str;
    //#]
}

char* OMString::GetBuffer(int newBufferSize) {
    //#[ operation GetBuffer_(int) 
    resetSize(newBufferSize);
    return str;
    //#]
}

bool OMString::IsEmpty() const {
    //#[ operation IsEmpty() const 
    return count == 0; 
    //#]
}

void OMString::SetAt(int i, char c) {
    //#[ operation SetAt(int,char) 
    if (i < count)
    {
    	// lint fails to identify the correlation between count and str
    	str[i] = c;	//lint !e613
    }
    //#]
}


//#[ ignore 
// the operation is not const to comply with MFC CString
//lint -save -e1762
//#]
  OMString::operator const char*() {
    //#[ operation operator const char*() 
    return str;
    //#]
}

//#[ ignore 

//lint -restore
//#]

bool OMString::operator!=(const char* c2) const {
    //#[ operation operator!=(char*) const 
    return (strcmp(str, c2) != 0);  //lint !e668 (OMString::str is never NULL)
    //#]
}

bool OMString::operator!=(const OMString& s2) const {
    //#[ operation operator!=(OMString) const 
    return (strcmp(str, s2.str) != 0); //lint !e668 (OMString::str is never NULL)
    //#]
}

const OMString& OMString::operator+=(const char* s) {
    //#[ operation operator+=(char*) 
    if(s){
    	int newCount = count + static_cast<int>(strlen(s));
    	resetSize(newCount + 1);
    	if(str){
    		strncpy(str + count, s, strlen(s) + 1);
    		count = newCount;
    	}
    }
    return *this;
    //#]
}

const OMString& OMString::operator+=(const char c) {
    //#[ operation operator+=(char) 
    ++count;
    resetSize(count + 1);
    if(str) {
    	str[count-1] = c;
    	str[count] = '\0';
    }
    return *this;
    //#]
}

const OMString& OMString::operator+=(const OMString& s) {
    //#[ operation operator+=(OMString) 
    int newCount = count + s.count;
    resetSize(newCount + 1);
    if (str) {
    	strncpy(str + count, s.str, (unsigned int) s.count + 1);
    	count = newCount;
    }
    return *this;
    //#]
}

bool OMString::operator<(const char* c2) const {
    //#[ operation operator<(char*) const 
    bool smaller = false;
    if (c2 != 0) {
    	smaller = (strcmp(str,c2) < 0); //lint !e668 (str is never NULL)
    }
    return smaller;
    //#]
}

bool OMString::operator<(const OMString& s2) const {
    //#[ operation operator<(OMString) const 
    return (strcmp(str, s2.str) < 0); //lint !e668 (OMString::str is never NULL)
    //#]
}

bool OMString::operator<=(const char* c2) const {
    //#[ operation operator<=(char*) const 
    bool res = false;
    if (c2 != 0) {
    	res = (strcmp(str, c2) <= 0); //lint !e668 (str is never NULL)
    }
    return res;
    //#]
}

bool OMString::operator<=(const OMString& s2) const {
    //#[ operation operator<=(OMString) const 
    return (strcmp(str, s2.str) <= 0);	//lint !e668 (OMString::str is never NULL)
    //#]
}

const OMString& OMString::operator=(const char* s) {
    //#[ operation operator=(char*) 
    if (s) {
    	count = static_cast<int>(strlen(s));
    	resetSize(count + 1);
    	if (str) {
    		strncpy(str, s, strlen(s) + 1);
    	}
    }
    return *this;
    //#]
}


//#[ ignore 
//lint -save -e1539 (the size doesn't change only the data)
//#]
const OMString& OMString::operator=(const char c) {
    //#[ operation operator=(char) 
    count = 1;
    if (str) {
    	str[0] = c;
    	str[count] = '\0';
    }
    return *this;
    //#]
}

//#[ ignore 

//lint -restore
//#]

const OMString& OMString::operator=(const OMString& s) {
    //#[ operation operator=(OMString) 
    if(str != s.str) {
    	count = s.count;
    	resetSize(count + 1);
    	if (str) {
    		strncpy(str, s.str, static_cast<unsigned int>(count) + 1);
    	}
    }
    return *this;
    //#]
}

bool OMString::operator==(const char* c2) const {
    //#[ operation operator==(char*) const 
    bool res = false;
    if (c2 != 0) {
    	res = (strcmp(str, c2) == 0); //lint !e668 (str is never NULL)
    }
    return res;
    //#]
}

bool OMString::operator==(const OMString& s2) const {
    //#[ operation operator==(OMString) const 
    return (strcmp(str, s2.str) == 0); //lint !e668 (str is never NULL)
    //#]
}

bool OMString::operator>(const char* c2) const {
    //#[ operation operator>(char*) const 
    bool res = true;
    if (c2 != 0) {
    	res = (strcmp(str, c2) > 0); //lint !e668 (str is never NULL)
    }
    return res;
    //#]
}

bool OMString::operator>(const OMString& s2) const {
    //#[ operation operator>(OMString) const 
    return (strcmp(str, s2.str) > 0);	//lint !e668 (str is never NULL)
    //#]
}

bool OMString::operator>=(const char* c2) const {
    //#[ operation operator>=(char*) const 
    bool res = true;
    if (c2 != 0) {
    	res = (strcmp(str, c2) >= 0);	//lint !e668 (str is never NULL)
    }
    return res;
    //#]
}

bool OMString::operator>=(const OMString& s2) const {
    //#[ operation operator>=(OMString) const 
    return (strcmp(str, s2.str) >= 0);	//lint !e668 (str is never NULL)
    //#]
}

char OMString::operator[](int i) const {
    //#[ operation operator[](int) const 
    return str[i];
    //#]
}

void OMString::resetSize(int newSize) {
    //#[ operation resetSize(int) 
    // Do we need to allocate new memory
    if (size < newSize) {
    	// retain a pointer to the actual data
    	char* oldStr = str;
    	// allocate the new memory
    	int oldSize = size;
    	setSize(newSize);
    	// copy the actual data to the new location
    	if (str && oldStr) {
    		strncpy(str,oldStr, (unsigned int)oldSize + 1);
    	}
    	// free memory used by the old location
    	OMDELETE(oldStr, oldSize);
    }
    //#]
}

void OMString::setSize(int newSize) {
    //#[ operation setSize(int) 
    
    // Round size up to the nearest stringBlock
    size = (newSize / defaultBlock) * defaultBlock;
    if (newSize > size) {
    	size += defaultBlock;
    }
    // Actually allocate the memory
    //lint -save -e119 (lint fail to find the replacement operator new[] )
    str = OMNEW(char, size);
    //lint -restore
    //#]
}

int OMString::GetLength() const {
    return count;
}

int OMString::getDefaultBlock() {
    return defaultBlock;
}

void OMString::setDefaultBlock(int p_defaultBlock) {
    defaultBlock = p_defaultBlock;
}

int OMString::getSize() const {
    return size;
}

char* OMString::getStr() const {
    return str;
}


//## package Design::oxf::Services::String::StringFunctions::OMString 



//## operation operator!=(char*,OMString) 
bool operator!=(const char* c1, const OMString& s2) {
    //#[ operation operator!=(char*,OMString) 
    return (strcmp(c1, s2.GetBuffer(0)) != 0);
    //#]
}

//## operation operator+(OMString,OMString) 
OMString operator+(const OMString& s1, const OMString& s2) {
    //#[ operation operator+(OMString,OMString) 
    OMString res(s1);
    res += s2;
    return res; 
    //#]
}

//## operation operator+(OMString,char*) 
OMString operator+(const OMString& s1, const char* s2) {
    //#[ operation operator+(OMString,char*) 
    OMString res(s1);
    res += s2;
    return res; 
    //#]
}

//## operation operator+(char*,OMString) 
OMString operator+(const char* s1, const OMString& s2) {
    //#[ operation operator+(char*,OMString) 
    OMString res(s1);
    res += s2;
    return res;
    //#]
}

//## operation operator+(OMString,char) 
OMString operator+(const OMString& str, const char c) {
    //#[ operation operator+(OMString,char) 
    OMString res(str);
    res += c;
    return res;
    //#]
}

//## operation operator<(char*,OMString) 
bool operator<(const char* c1, const OMString& s2) {
    //#[ operation operator<(char*,OMString) 
    return (strcmp(c1,s2.GetBuffer(0)) < 0);
    //#]
}

//## operation operator<=(char*,OMString) 
bool operator<=(const char* c1, const OMString& s2) {
    //#[ operation operator<=(char*,OMString) 
    return (strcmp(c1,s2.GetBuffer(0)) <= 0);
    //#]
}

//## operation operator==(char*,OMString) 
bool operator==(const char* c1, const OMString& s2) {
    //#[ operation operator==(char*,OMString) 
    return (strcmp(c1,s2.GetBuffer(0)) == 0);
    //#]
}

//## operation operator>(char*,OMString) 
bool operator>(const char* c1, const OMString& s2) {
    //#[ operation operator>(char*,OMString) 
    return (strcmp(c1,s2.GetBuffer(0)) > 0);
    //#]
}

//## operation operator>=(char*,OMString) 
bool operator>=(const char* c1, const OMString& s2) {
    //#[ operation operator>=(char*,OMString) 
    return (strcmp(c1,s2.GetBuffer(0)) >= 0);
    //#]
}


//
//! Log: $Log: omstring.cpp $
//! Log: Revision 1.51  2007/04/06 07:08:15  ilgiga
//! Log: bug fix 98191
//


