//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omreactive.h $
//!	File version	: $Revision: 1.131 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:13 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef omreactive_H 

#define omreactive_H 

#include "rp_framework_dll_definition.h"
#include "OXFEvents.h"
#include "OXFGenMacros.h"
#include "IOxfEvent.h"
#include "IOxfReactive.h"
#include "OMOSEventGenerationParams.h"
#include "OXFStatechartMacros.h"

//----------------------------------------------------------------------------
// omreactive.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class AOMSState;
class IOxfActive;
class OMAnimReactive;
class OMComponentState;
class OMEvent;
class OMMainThread;
class OMOS;
class OMOSThread;
class OMProtected;
class OMThread;
class OMTimeout;
class OMTimerManager;
class OXF;

//## package Design::oxf::Core::CoreImplementation 


// The base IOxfReactive implementation
//## class OMReactive 
class RP_FRAMEWORK_DLL OMReactive : public IOxfReactive {
public :
    // Constant default values
    //## type Defaults 
    enum Defaults {DEFAULT_MAX_NULL_STEPS = 100};
    
    

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Initialize the reactive instance
    // Argument IOxfActive* context : 
    // the active context of the reactive class
    //## operation OMReactive(IOxfActive) 
    OMReactive(IOxfActive* context = 0);
    
    // Virtual destructor to enable polymorphic deletion
    //## operation ~OMReactive() 
    virtual ~OMReactive();


////    Operations    ////
public :
    
    // Check if the provided event ID matches the current handled event.
    // Argument IOxfEvent::ID eventId : 
    // The id to check
    //## operation IsCurrentEvent(ID) const 
    bool IsCurrentEvent(IOxfEvent::ID eventId) const;
    
    // send the specified event to the reactive instance's active context queue
    // Argument OMEvent* ev : 
    // The event to send
    // Argument bool fromISR : 
    // When true the event is send in the context on an ISR
    //## operation _gen(OMEvent,bool) 
    virtual bool _gen(OMEvent* ev, bool fromISR = false);
    
    // cleanup the event queue in destruction, 
    // if the user modified the event queue - reactive relationship,
    // it must deal with the cleanup in its own code.
    //## operation cancelEvents() 
    void cancelEvents();
    
    // cleanup references to the specified timeout
    // Argument const IOxfTimeout* /*timeout*/ : 
    // the timeout to remove references to
    //## operation cancelTimeout(IOxfTimeout) 
    bool cancelTimeout(const IOxfTimeout* /*timeout*/);
    
    // cleanup timeouts in destruction, 
    // if the user modified the event queue - reactive relationship,
    // it must deal with the cleanup in its own code.
    //## operation cancelTimeouts() 
    void cancelTimeouts();
    
    // destroy the reactive instance (delete should never be called directly)
    //## operation destroy() 
    void destroy();
    
    // Backward compatibility: destroy a timeout.
    // Argument OMTimeout* timeout : 
    // The timeout to delete
    //## operation discarnateTimeout(OMTimeout) 
    virtual void discarnateTimeout(OMTimeout* timeout);
    
    // signal that the reactive instance reached a terminate connector
    //## operation endBehavior(const char* aomArg()) 
    virtual void endBehavior(const char* aomArg(theTerminator) = 0);
    
    // send the specified event to the instance active context queue
    // Argument OMEvent* ev : 
    // The event to send
    // Argument bool fromISR : 
    // When true the event is send in the context on an ISR
    //## operation gen(OMEvent,bool) 
    virtual bool gen(OMEvent* ev, bool fromISR = false);
    
    // send the specified event to the instance active context queue
    // Argument OMEvent* ev : 
    // The event to send
    // Argument void * sender : 
    // The event sender (for design level debugging)
    //## operation gen(OMEvent,void *) 
    virtual bool gen(OMEvent* ev, void * sender);
    
    // Deprecated.
    // get the active context as OMThread* for backward compatibility.
    // Use getActiveContext()
    //## operation getThread() const 
    OMThread* getThread() const;
    
    // Consume an event
    // Argument IOxfEvent* ev : 
    // The event to handle
    //## operation handleEvent(IOxfEvent) 
    IOxfReactive::TakeEventStatus handleEvent(IOxfEvent* ev);
    
    // Backward compatibility: create a timeout without scheduling it.
    // Argument short id : 
    // The timeout specific id
    // Argument timeUnit delay : 
    // The delay time
    // Argument const OMHandle* theState : 
    // The state that the timeout is associated with
    //## operation incarnateTimeout(short,timeUnit,OMHandle) 
    virtual OMTimeout* incarnateTimeout(short id, timeUnit delay, const OMHandle* theState);
    
    // Deprecated, use popNullTransition()
    // signal that a null transition was taken (called by the generated code)
    //## operation popNullConfig() 
    void popNullConfig();
    
    // signal that a null transition was taken (called by the generated code)
    //## operation popNullTransition() 
    void popNullTransition();
    
    // Deprecated, use pushNullTransition()
    // signal that there is a null transition to be taken (called by the generated code)
    //## operation pushNullConfig() 
    void pushNullConfig();
    
    // signal that there is a null transition to be taken (called by the generated code)
    //## operation pushNullTransition() 
    void pushNullTransition();
    
    // states serialization (should be overridden in Flat code generation)
    // Argument AOMSState* aomsState : 
    // The state vector
    //## operation rootState_serializeStates(AOMSState) const 
    
    //#[ ignore 
    #ifdef _OMINSTRUMENT
    //#]
    void rootState_serializeStates(AOMSState* aomsState) const;
    //#[ ignore 
    
    #endif // _OMINSTRUMENT
    //#]
    
    
    // send an event to the active context queue
    // Argument IOxfEvent* ev : 
    // The event to send
    // Argument const IOxfEventGenerationParams& params : 
    // Sending parameters
    //## operation send(IOxfEvent,IOxfEventGenerationParams) 
    virtual bool send(IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
    // send the specified event to the instance active context queue
    // Argument IOxfEvent* ev : 
    // The event to send
    //## operation send(IOxfEvent) 
    virtual bool send(IOxfEvent* ev);
    
    // serialization of the active states vector
    // Argument AOMSState* aomsState : 
    // The state vector
    //## operation serializeStates(AOMSState) const 
    
    //#[ ignore 
    #ifdef _OMINSTRUMENT
    //#]
    void serializeStates(AOMSState* aomsState) const;
    //#[ ignore 
    
    #endif // _OMINSTRUMENT
    //#]
    
    
    // set the active context
    // Argument IOxfActive* context : 
    // The active context (event dispatcher) of the reactive instance
    //## operation setActiveContext(IOxfActive) 
    virtual void setActiveContext(IOxfActive* context);
    
    // this operation is virtual and public in order to allow user to initialize 
    // nested embedded reactive components of active class manually
    // Rhapsody supports only one level of nesting for such cases.
    // The usage of the operation should be done with care.
    // Argument IOxfActive* context : 
    // The active context (event dispatcher) of the reactive instance
    // Argument bool activeInstance : 
    // should be true if the instance is active-reactive and false otherwise
    //## operation setActiveContext(IOxfActive,bool) 
    virtual void setActiveContext(IOxfActive* context, bool activeInstance);
    
    // set  the event guard by reference
    // Argument const OMProtected& guard : 
    // The guard
    //## operation setEventGuard(OMProtected) 
    void setEventGuard(const OMProtected& guard);
    
    // Mark the instance as dynamically or statically allocated
    // Argument bool b : 
    // The new value
    //## operation setShouldDelete(bool) 
    void setShouldDelete(bool b);
    
    // getter/setter for the shouldTerminate flag
    // Argument bool b : 
    // The new value
    //## operation setShouldTerminate(bool) 
    inline void setShouldTerminate(bool b) {
        //#[ operation setShouldTerminate(bool) 
        if (b) {
        	state |= terminateConnectorReachedStateMask;
        }
        else {
        	state &= ~terminateConnectorReachedStateMask;
        }
        //#]
    }
    
    
    // Deprecated, use setActiveContext().
    // This operation is virtual and public in order to allow user to initialize nested embedded reactive components 
    // of active class manually
    // .
    // 
    // Rhapsody supports only one level of nesting for such cases.
    // The usage of the operation should be done with care.
    // Argument OMThread* thread : 
    // the event dispatcher
    // Argument bool activeInstance : 
    // should be true when this is an active-reactive instance
    //## operation setThread(OMThread,bool) 
    virtual void setThread(OMThread* thread, bool activeInstance);
    
    // mark the reactive instance as guarded - to prevent mutual exclusion between the instance deletion and the event 
    // consumption
    // Argument bool flag : 
    // The new value
    //## operation setToGuardReactive(bool) 
    void setToGuardReactive(bool flag);
    
    // Check if the instance is dynamically allocated.
    //## operation shouldDelete() const 
    inline bool shouldDelete() const {
        //#[ operation shouldDelete() const 
        return ((state & deleteOnTerminateStateMask) != 0);
        //#]
    }
    
    
    // Check if the instance should support direct deletion
    //## operation shouldSupportDirectDeletion() const 
    bool shouldSupportDirectDeletion() const;
    
    // initialize the reactive instance state machine
    //## operation startBehavior() 
    bool startBehavior();
    
    // Provide a backward compatibility for users that customized the framework in Rhapsody 5.X
    // Argument OMEvent* ev : 
    // The event to handle
    //## operation takeEvent(OMEvent) 
    virtual IOxfReactive::TakeEventStatus takeEvent(OMEvent* ev);
    
    // signal that the reactive instance reached a terminate connector
    // Argument const char* theTerminator : 
    // A design-level debugging argument that specify the termination context
    //## operation terminate(char*) 
    virtual void terminate(const char* theTerminator = 0);

protected :
    
    // Provide a backward compatibility signature for users that customized the framework
    // Argument OMEvent* ev : 
    // The call-event
    //## operation _takeTrigger(OMEvent) 
    virtual void _takeTrigger(OMEvent* ev);
    
    // Process the event
    // Argument OMEvent* ev : 
    // The event to handle
    //## operation consumeEvent(OMEvent) 
    virtual IOxfReactive::TakeEventStatus consumeEvent(OMEvent* ev);
    
    // Deprecated.
    // handle unconsumed event.
    // Use handleNotConsumed()
    // Argument OMEvent* /*ev*/ : 
    // the missed event
    //## operation handleEventNotConsumed(OMEvent) 
    virtual void handleEventNotConsumed(OMEvent* /*ev*/);
    
    // react to an event that was not consumed.
    // note that the event can be allocated on the stack.
    // Argument IOxfEvent* /*ev*/ : 
    // The context event
    // Argument IOxfReactive::EventNotConsumedReason /*reason*/ : 
    // The reason for the consumption failure
    //## operation handleNotConsumed(IOxfEvent,EventNotConsumedReason) 
    void handleNotConsumed(IOxfEvent* /*ev*/, IOxfReactive::EventNotConsumedReason /*reason*/);
    
    // Deprecated.
    // handle unconsumed event.
    // Use handleNotConsumed()
    // Argument OMEvent* /*ev*/ : 
    // the missed event
    //## operation handleTONotConsumed(OMEvent) 
    virtual void handleTONotConsumed(OMEvent* /*ev*/);
    
    // This operation is called when the setting of a timeout failed.
    // This happens when the timer manager cannot add the timeout to the waiting timeouts heap
    // The user should override it in derived classes to handle the error.
    // For example the user may call OMTimerManager::instance()->cleanupCanceledTimeouts() and then retry setting the 
    // timeout
    //## operation handleTimeoutSetFailure(IOxfTimeout) 
    virtual void handleTimeoutSetFailure(IOxfTimeout* /*timeout*/);
    
    // the entry-point for triggered operation consumption
    // Argument IOxfEvent* ev : 
    // The call-event to handle
    //## operation handleTrigger(IOxfEvent) 
    virtual void handleTrigger(IOxfEvent* ev);
    
    // check if there are null transitions to take
    //## operation hasWaitingNullTransitions() const 
    bool hasWaitingNullTransitions() const;
    
    // getter/setter for the behavior started flag
    //## operation isBehaviorStarted() const 
    bool isBehaviorStarted() const;
    
    // return true when the instance is under destruction
    //## operation isUnderDestruction() const 
    bool isUnderDestruction() const;
    
    // events/triggered operations event consumption shared code
    // Argument IOxfEvent* ev : 
    // The event to process
    //## operation processEvent(IOxfEvent) 
    virtual IOxfReactive::TakeEventStatus processEvent(IOxfEvent* ev);
    
    // Checks if second call to startBehavior() should cause restart - i.e. restart of the statechart
    //## operation restartBehaviorEnabled() const 
    bool restartBehaviorEnabled() const;
    
    // Dispatch the received event to the statechart. 
    // In FLAT statechart code, expected to be overridden by the user class.
    // Argument IOxfEvent::ID /*id*/ : 
    // The id of the current event
    //## operation rootState_dispatchEvent(ID) 
    virtual int rootState_dispatchEvent(IOxfEvent::ID /*id*/);
    
    // Take the statechart initial default transition(s).
    // In FLAT statechart code, expected to be overridden by the user class.
    //## operation rootState_entDef() 
    virtual void rootState_entDef();
    
    // Dispatch the received event to the statechart.
    // In FLAT statechart code, expected to be overridden by the user class.
    //## operation rootState_processEvent() 
    virtual IOxfReactive::TakeEventStatus rootState_processEvent();
    
    // take null transitions - called at the end of the event consumption
    //## operation runToCompletion() 
    void runToCompletion();
    
    // schedule a timeout to be consumed by the reactive instance.
    // Argument OxfTimeUnit delay : 
    // The time until the timeout will expire
    // Argument const char* targetStateName : 
    // The target state name (for design level debugging)
    //## operation scheduleTimeout(OxfTimeUnit,char) 
    IOxfTimeout* scheduleTimeout(OxfTimeUnit delay, const char* targetStateName = 0);
    
    // Mark that startBehavior() was called
    //## operation setBehaviorStarted() 
    void setBehaviorStarted();
    
    // set the ShouldCompleteStartBehavior flag
    // Argument bool b : 
    // The flag value
    //## operation setCompleteStartBehavior(bool) 
    inline void setCompleteStartBehavior(bool b) {
        //#[ operation setCompleteStartBehavior(bool) 
        if (b) {
        	state |= shouldCompleteStartBehaviorStateMask;
        }
        else {
        	state &= ~shouldCompleteStartBehaviorStateMask;
        }
        //#]
    }
    
    
    // set the current event
    // Argument IOxfEvent* ev : 
    // The event currently handled
    //## operation setCurrentEvent(IOxfEvent) 
    void setCurrentEvent(IOxfEvent* ev);
    
    // Mark that the instance is being destroyed
    //## operation setInDtor() 
    void setInDtor();
    
    // Mark that the instance is being destroyed
    //## operation setUnderDestruction() 
    void setUnderDestruction();
    
    // check if there are null transitions to take
    //## operation shouldCompleteRun() const 
    bool shouldCompleteRun() const;
    
    // check if there are null transitions to take as part of startBehavior()
    //## operation shouldCompleteStartBehavior() const 
    bool shouldCompleteStartBehavior() const;
    
    // Test if the reactive instance should terminate
    //## operation shouldTerminate() const 
    inline bool shouldTerminate() const;
    
    // Provide a backward compatibility for users that customized the framework in Rhapsody 5.X
    // Argument OMEvent* ev : 
    // The call-event to handle
    //## operation takeTrigger(OMEvent) 
    virtual void takeTrigger(OMEvent* ev);

private :
    
    // Consume an event when the reaction instance is under destruction
    // Argument const IOxfEvent* ev : 
    // The event to handle
    //## operation handleEventUnderDestruction(IOxfEvent) 
    IOxfReactive::TakeEventStatus handleEventUnderDestruction(const IOxfEvent* ev);
    
    // Check if the theTerminateEvent was resent
    //## operation isDestroyEventResent() const 
    bool isDestroyEventResent() const;
    
    // actually send an event to the active context queue
    // Argument IOxfEvent* ev : 
    // The event to send
    // Argument const IOxfEventGenerationParams& params : 
    // Sending parameters
    //## operation sendEvent(IOxfEvent,IOxfEventGenerationParams) 
    bool sendEvent(IOxfEvent* ev, const IOxfEventGenerationParams& params);
    
    // Mark that the theTerminateEvent was resent
    //## operation setDestroyEventResent() 
    void setDestroyEventResent();


////    Additional operations    ////
public :
    
    //## auto_generated 
    static int getMaxNullSteps();
    
    //## auto_generated 
    static void setMaxNullSteps(int p_maxNullSteps);
    
    //## auto_generated 
    bool isActive() const;
    
    //## auto_generated 
    bool getToGuardReactive() const;
    
    //## auto_generated 
    bool getSupportDirectDeletion() const;
    
    //## auto_generated 
    void setSupportDirectDeletion(bool p_supportDirectDeletion);
    
    //## auto_generated 
    static bool getGlobalSupportDirectDeletion();
    
    //## auto_generated 
    static void setGlobalSupportDirectDeletion(bool p_globalSupportDirectDeletion);
    
    //## auto_generated 
    bool getSupportRestartBehavior() const;
    
    //## auto_generated 
    void setSupportRestartBehavior(bool p_supportRestartBehavior);
    
    //## auto_generated 
    static bool getGlobalSupportRestartBehavior();
    
    //## auto_generated 
    static void setGlobalSupportRestartBehavior(bool p_globalSupportRestartBehavior);
    
    //## auto_generated 
    IOxfActive* getActiveContext() const;
    
    //## auto_generated 
    IOxfEvent* getCurrentEvent() const;
    
    //## auto_generated 
    const OMProtected* getEventGuard() const;
    
    //## auto_generated 
    void setEventGuard(const OMProtected* p_OMProtected);
    
    //## auto_generated 
    OMThread* getMyThread() const;

protected :
    
    //## auto_generated 
    unsigned long getReactiveInternalState() const;
    
    //## auto_generated 
    void setReactiveInternalState(unsigned long p_state);
    
    //## auto_generated 
    bool isFrameworkInstance() const;
    
    //## auto_generated 
    void setFrameworkInstance(bool p_frameworkInstance);
    
    //## auto_generated 
    bool isBusy() const;
    
    //## auto_generated 
    void setBusy(bool p_busy);

private :
    
    //## auto_generated 
    void setActive(bool p_active);


////    Framework operations    ////
protected :
    
    //## auto_generated 
    void cleanUpRelations();


////    Attributes    ////
private :
    
    // OMReactive state mask - the initial state
    static const unsigned long defaultStateMask;		//## attribute defaultStateMask 
    
    // OMReactive state mask - a null transition was found/taken
    static const unsigned long nullTransitionStateMask;		//## attribute nullTransitionStateMask 
    
    // OMReactive state mask - the max number of waiting null transitions that OMReactive can handle
    static const unsigned long nullTransitionMask;		//## attribute nullTransitionMask 
    
    // OMReactive state mask - the instance statechart reached a terminate connector
    static const unsigned long terminateConnectorReachedStateMask;		//## attribute terminateConnectorReachedStateMask 
    
    // OMReactive state mask - the instance is under destruction
    static const unsigned long underDestructionStateMask;		//## attribute underDestructionStateMask 
    
    // OMReactive state mask - the reactive instance should be deleted when a terminate connector is reached
    static const unsigned long deleteOnTerminateStateMask;		//## attribute deleteOnTerminateStateMask 
    
    // OMReactive state mask - need to complete the startBehavior() by a start behavior event
    static const unsigned long shouldCompleteStartBehaviorStateMask;		//## attribute shouldCompleteStartBehaviorStateMask 
    
    // OMReactive state mask - startBehavior() was called	
    static const unsigned long behaviorStartedStateMask;		//## attribute behaviorStartedStateMask 
    
    // Maximum number of null transitions allowed in a single take
    // infinite loop checker.
    static int maxNullSteps;		//## attribute maxNullSteps 
    
    // The reactive internal state (bit field)
    unsigned long state;		//## attribute state 
    
    // This flag mark an instance as an internal to the framework (that should be invisible in design-level debugging)
    bool frameworkInstance;		//## attribute frameworkInstance 
    
    // This flag mark an active-reactive class
    bool active;		//## attribute active 
    
    // This flag indicate that the reactive instance is currently handling an event.
    bool busy;		//## attribute busy 
    
    // This flag indicate that the destruction of the reactive instance should be guarded against mutual exclusion - 
    // prevents deletion of the instance while processing an event.
    bool toGuardReactive;		//## attribute toGuardReactive 
    
    // The instance start behavior event.
    // This event is sent from the instance to itself when the default transition is followed by null transitions.
    OMStartBehaviorEvent theStartBehaviorEvent;		//## attribute theStartBehaviorEvent 
    
public :
    
    // Alias to IOxfReactive::eventNotConsumed
    static const IOxfReactive::TakeEventStatus OMTakeEventCompletedEventNotConsumed;		//## attribute OMTakeEventCompletedEventNotConsumed 
    
    // Alias to IOxfReactive::eventConsumed
    static const IOxfReactive::TakeEventStatus OMTakeEventCompleted;		//## attribute OMTakeEventCompleted 
    
private :
    
    // When set to true, the reactive class should support direct deletion.
    // The user can also set the globalSupportDirectDeletion attribute to affect all the reactive classes in the 
    // system.
    // The reactive instance will support direct deletion if either of the attributes is set to true.
    bool supportDirectDeletion;		//## attribute supportDirectDeletion 
    
    // When set to true, all the reactive classes in the system should support direct deletion.
    // The user can also set the supportDirectDeletion attribute to affect a single reactive instance.
    // The reactive instance will support direct deletion if either of the attributes is set to true.
    static bool globalSupportDirectDeletion;		//## attribute globalSupportDirectDeletion 
    
    // The reactive terminate event.
    // The reactive instance sends this event to itself on call to terminate() and will self-destruct once the event 
    // is consumed
    OMReactiveTerminationEvent theTerminateEvent;		//## attribute theTerminateEvent 
    
    // OMReactive state mask - indicate that theTerminateEvent was resent.
    // The terminate event is send twice to reduce the probability of a race between event sending on call to 
    // destroy().
    // When destroy is called the reactive instance is set in under destruction mode that prevents sending of 
    // additional events and the terminate event is sent by the instance to itself.
    // The terminate event must be the last event sent to this instance and since the setting in under destruction 
    // mode is done without guarding (for performance considerations), the terminate event is reset after consumed on 
    // the first time to avoid a scenario where, due to task scheduling, another event is sent after the destroy 
    // event.
    // Sending the terminate event a second time prevents most scheduling races however it does not prevent all 
    // possible scenarios.
    // In case that your scheduler may stop a task in the middle of a regular code (without a blocking call) for 
    // indefinite time (that will let the reactive instance thread dispatch the terminate event twice), you should 
    // consider using the direct deletion policy.
    static const unsigned long destroyEventResentStateMask;		//## attribute destroyEventResentStateMask 
    
    // When set to true the instance reacts to sequential calls of startBehavior() by reset of the statechart.
    // The user can also set the globalSupportRestartBehavior static attribute to apply this behavior to all the 
    // instances of OMReactive.
    bool supportRestartBehavior;		//## attribute supportRestartBehavior 
    
    // When set to true all the instances of OMReactive reacts to sequential calls of startBehavior() by reset of the 
    // statechart.
    // The user can also set the instance supportRestartBehavior attribute to apply this behavior to specific 
    // instance.
    static bool globalSupportRestartBehavior;		//## attribute globalSupportRestartBehavior 
    
public :
    
    // Static instance of OMOSEventGenerationParams for ISR generation
    static const OMOSEventGenerationParams isrParams;		//## attribute isrParams 
    

////    Relations and components    ////
protected :
    
    // Backward compatibility API
    OMEvent* event;		//## link event 
    
    
    // Direct reference to OMThread for backward compatibility
    OMThread* myThread;		//## link myThread 
    
    
    OMComponentState* rootState;		//## link rootState 
    

private :
    
    IOxfActive* activeContext;		//## link activeContext 
    
    
    IOxfEvent* currentEvent;		//## link currentEvent 
    
    
    const OMProtected* eventGuard;		//## link eventGuard 
    

};


#endif  
//
//! Log: $Log: omreactive.h $
//! Log: Revision 1.131  2007/04/06 07:08:13  ilgiga
//! Log: bug fix 98191
//


