//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMReactive
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omreactive.cpp $
//!	File version	: $Revision: 1.161 $
//
//!	Date changed	: $Date: 2007/04/15 09:41:29 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: omreactive.cpp 1.161 2007/04/15 09:41:29 ilgiga Exp $";
#endif
//#]

#include "omreactive.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "IOxfActive.h"
#include "OXFNotifyMacros.h"
#include "OMAnimReactive.h"
#include "state.h"
#include "OMEvent.h"
#include "OMMainThread.h"
#include "os.h"
#include "omprotected.h"
#include "omthread.h"
#include "OMTimeout.h"
#include "OMTimerManager.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// omreactive.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Core::CoreImplementation 

//## class OMReactive 


// Static class member attribute
const unsigned long OMReactive::defaultStateMask = 0x00000000L;
// Static class member attribute
const unsigned long OMReactive::nullTransitionStateMask = 0x00000001L;
// Static class member attribute
const unsigned long OMReactive::nullTransitionMask = 0x0000FFFFL;
// Static class member attribute
const unsigned long OMReactive::terminateConnectorReachedStateMask = 0x00010000L;
// Static class member attribute
const unsigned long OMReactive::underDestructionStateMask = 0x00020000L;
// Static class member attribute
const unsigned long OMReactive::deleteOnTerminateStateMask = 0x00040000L;
// Static class member attribute
const unsigned long OMReactive::shouldCompleteStartBehaviorStateMask = 0x00080000L;
// Static class member attribute
const unsigned long OMReactive::behaviorStartedStateMask = 0x00100000L;
// Static class member attribute
int OMReactive::maxNullSteps = DEFAULT_MAX_NULL_STEPS;
// Static class member attribute
const IOxfReactive::TakeEventStatus OMReactive::OMTakeEventCompletedEventNotConsumed = eventNotConsumed;
// Static class member attribute
const IOxfReactive::TakeEventStatus OMReactive::OMTakeEventCompleted = eventConsumed;
// Static class member attribute
bool OMReactive::globalSupportDirectDeletion = false;
// Static class member attribute
const unsigned long OMReactive::destroyEventResentStateMask = 0x00200000L;
// Static class member attribute
bool OMReactive::globalSupportRestartBehavior = false;
// Static class member attribute
const OMOSEventGenerationParams OMReactive::isrParams = true;

OMReactive::OMReactive(IOxfActive* context) : state(0) ,frameworkInstance(false) ,active(false) ,busy(false) ,
toGuardReactive(false) ,supportDirectDeletion(false) ,supportRestartBehavior(false) ,
event(0), myThread(0), rootState(0), activeContext(0), currentEvent(0), eventGuard(0) {
    //#[ operation OMReactive(IOxfActive) 
    OMReactive::setActiveContext(context, false);
    setShouldDelete(true);
    theTerminateEvent.setFrameworkEvent(true);
    
    #ifdef _OMINSTRUMENT
    // register the reactive instance
    AnimServices::registerReactiveInstance(this, new OMAnimReactive(this));
    // register the start behavior event
    AnimServices::notifyFrameworkEventCreated(&theStartBehaviorEvent);
    #endif
    //#]
}

OMReactive::~OMReactive() {
    //#[ operation ~OMReactive() 
    // Mark that the object is under destruction. This is required
    setUnderDestruction();
    if (shouldSupportDirectDeletion())
    {
    	// In case where the object is destructed from another thread.
    	if (!OMThread::endOfProcess)
    	{
    		// All events queued for this object need be "deleted".
    		if (!isActive())
    		{
    			cancelEvents();
    		}
    		else
    		{
    			cancelTimeouts();
    		}
    	}
    	if (toGuardReactive && (activeContext != 0))
    	{
    		// toGuard should be set to true by the application class, if necessary
    		// unlock the thread guard taken in the beggining of the user class DTOR
    		static_cast<OMThread*>(activeContext)->unlock();
    	}
    }
    #ifdef _OMINSTRUMENT
    AnimServices::notifyReactiveInstanceDeleted(this);
    #endif // _OMINSTRUMENT
    //#]
    cleanUpRelations();
}

bool OMReactive::IsCurrentEvent(IOxfEvent::ID eventId) const {
    //#[ operation IsCurrentEvent(ID) const 
    IOxfEvent* e = currentEvent;
    // e might be 0 during destruction
    if (e == 0) {
    	return false;
    }
    
    return e->isTypeOf(eventId);
    //#]
}

bool OMReactive::_gen(OMEvent* ev, bool fromISR) {
    //#[ operation _gen(OMEvent,bool) 
    bool res = false;
    if (fromISR)
    {
    	res = sendEvent(ev, isrParams);
    }
    else
    {
    	OMOSEventGenerationParams params(false);
    	res = sendEvent(ev, params);
    }
    return res;
    //#]
}

void OMReactive::_takeTrigger(OMEvent* ev) {
    //#[ operation _takeTrigger(OMEvent) 
    (void) consumeEvent(ev);
    //#]
}

void OMReactive::cancelEvents() {
    //#[ operation cancelEvents() 
    #ifndef OM_DISABLE_DIRECT_REACTIVE_DELETION
    // ask my thread to cancel all the events that are targeted for me
    if (getActiveContext() != 0) {
    	static_cast<OMThread*>(getActiveContext())->cancelPendingEvents(this);
    }
    #endif /* OM_DISABLE_DIRECT_REACTIVE_DELETION */
    //#]
}

bool OMReactive::cancelTimeout(const IOxfTimeout* /*timeout*/) {
    //#[ operation cancelTimeout(IOxfTimeout) 
    return false;
    //#]
}

void OMReactive::cancelTimeouts() {
    //#[ operation cancelTimeouts() 
    if (OXF::getManagedTimeoutCanceling())
    {
    	// compatibility mode
    	// cancel any timeouts that are targeted to the this
    	OMTimerManager* sysTimer = OMTimerManager::instance();
    	if (sysTimer)
    	{
    		sysTimer->unschedTm(OMAnyEventId ,this);
    	}
    }
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::consumeEvent(OMEvent* ev) {
    //#[ operation consumeEvent(OMEvent) 
    IOxfEvent* e = ev;
    return processEvent(e);
    //#]
}

void OMReactive::destroy() {
    //#[ operation destroy() 
    setUnderDestruction();
    if (isActive() &&
    	(getActiveContext() != 0))
    {
    	// this is an active-reactive instance
    	// terminate the dispatching (this will destroy the instance by destroyThread())
    	getActiveContext()->endDispatching();
    }
    else
    {
    	if (!shouldSupportDirectDeletion())
    	{
    		// graceful self-termination
    		(void) send(&theTerminateEvent);
    	}
    	else if (shouldDelete())
    	{
    		// foced termination
    		delete this;
    	}
    }
    //#]
}

void OMReactive::discarnateTimeout(OMTimeout* timeout) {
    //#[ operation discarnateTimeout(OMTimeout) 
    if (timeout != 0)
    {
    	timeout->cancel();
    	delete timeout;
    }
    //#]
}

void OMReactive::endBehavior(const char* aomArg(theTerminator)) {
    //#[ operation endBehavior(const char* aomArg()) 
    state |= terminateConnectorReachedStateMask;
    #ifdef _OMINSTRUMENT
    	AnimServices::notifyTerminateConnector(this, theTerminator);
    #endif // _OMINSTRUMENT
    //#]
}

bool OMReactive::gen(OMEvent* ev, bool fromISR) {
    //#[ operation gen(OMEvent,bool) 
    return _gen(ev, fromISR);
    //#]
}

bool OMReactive::gen(OMEvent* ev, void * sender) {
    //#[ operation gen(OMEvent,void *) 
    OMOSEventGenerationParams params(sender);
    return sendEvent(ev, params);
    //#]
}

OMThread* OMReactive::getThread() const {
    //#[ operation getThread() const 
    return static_cast<OMThread*>(getActiveContext());
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::handleEvent(IOxfEvent* ev) {
    //#[ operation handleEvent(IOxfEvent) 
    if (isUnderDestruction())
    {
    	// in termination process
    	return handleEventUnderDestruction(ev);
    }
    
    // check that the behavior should still run
    if (shouldTerminate() && shouldDelete())
    {
    	return eventConsumed;
    }
    
    // the event guard is set -
    // use it to set mutual exclusion between Events and Triggered Operations
    // the m_eventGuard is set by the application when there is a guarded triggered operation
    if (eventGuard != 0)
    {
    	eventGuard->lock();
    }
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyHandleEventBegin(this, ev);
    #endif
    
    // actually handle the event
    TakeEventStatus eventConsumeResult = eventNotConsumed;
    if (!OXF::getRhp5CompatibleAPI())
    {
    	// normal mode
    	eventConsumeResult = processEvent(ev);
    }
    else
    {
    	// compatibility mode
    	eventConsumeResult = consumeEvent(static_cast<OMEvent*>(ev));
    	// Notify unconsumed event
    	// This call is only supplied for backward compatibility
    	// A call to handleNotConsumed() is made from processEvent()
    	if (eventConsumeResult == eventNotConsumed)
    	{
    		handleEventNotConsumed(static_cast<OMEvent*>(ev));
    	}
    }
    
    // unlock the event guard
    if (eventGuard != 0)
    {
    	eventGuard->unlock();
    }
    
    // result with a status which indicates that the item had reached a terminate connector
    if (shouldTerminate())
    {
    	eventConsumeResult = instanceReachTerminate;
    }
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyHandleEventEnd(this, ev);
    #endif
    
    return eventConsumeResult;
    //#]
}

void OMReactive::handleEventNotConsumed(OMEvent* /*ev*/) {
    //#[ operation handleEventNotConsumed(OMEvent) 
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::handleEventUnderDestruction(const IOxfEvent* ev) {
    //#[ operation handleEventUnderDestruction(IOxfEvent) 
    if ((ev != 0) &&
    	ev->isTypeOf(OMReactiveTerminationEventId))
    {
    	if (shouldDelete())
    	{
    		if (isDestroyEventResent())
    		{
    			// second consumption
    			// self termination event - do self destruction
    			delete this;
    		}
    		else
    		{
    			// first consumption - resend
    			// When destroy is called the reactive instance is set in under destruction mode 
    			//	that prevents sending of additional events and the terminate event is sent by the instance to itself.
    			// The terminate event must be the last event sent to this instance and since the setting in under destruction mode is done without guarding
    			//	(for performance considerations), the terminate event is reset after consumed on the first time to avoid a scenario where, 
    			//	due to task scheduling, another event is sent after the destroy event.
    			// Sending the terminate event a second time prevents most scheduling races 
    			//	however it does not prevent all possible scenarios.
    			// In case that your scheduler may stop a task in the middle of a regular code (without a blocking call) 
    			//	for indefinite time (that will let the reactive instance thread dispatch the terminate event twice), 
    			//	you should consider using the direct deletion policy.
    			(void) send(&theTerminateEvent);
    			setDestroyEventResent();
    		}
    	}
    }
    return instanceUnderDestruction;
    //#]
}

void OMReactive::handleNotConsumed(IOxfEvent* /*ev*/, IOxfReactive::EventNotConsumedReason /*reason*/) {
    //#[ operation handleNotConsumed(IOxfEvent,EventNotConsumedReason) 
    //#]
}

void OMReactive::handleTONotConsumed(OMEvent* /*ev*/) {
    //#[ operation handleTONotConsumed(OMEvent) 
    //#]
}

void OMReactive::handleTimeoutSetFailure(IOxfTimeout* /*timeout*/) {
    //#[ operation handleTimeoutSetFailure(IOxfTimeout) 
    //#]
}

void OMReactive::handleTrigger(IOxfEvent* ev) {
    //#[ operation handleTrigger(IOxfEvent) 
    // mark as triggered operation
    ev->setSynchronous(true);
    
    TakeEventStatus eventConsumeResult = eventNotConsumed;
    if (!OXF::getRhp5CompatibleAPI()) {
    	// normal mode
    	eventConsumeResult = processEvent(ev);
    }
    else {
    	// compatibility mode
    	eventConsumeResult = consumeEvent(static_cast<OMEvent*>(ev));
    	// Notify unconsumed triggered operation
    	// This call is only supplied for backward compatibility
    	// A call to handleNotConsumed() is made from processEvent()
    	if (eventConsumeResult == eventNotConsumed) {
    		handleTONotConsumed(static_cast<OMEvent*>(ev));
    	}
    }
    
    // deleting the item if it reached a terminate connector
    if(shouldTerminate() && shouldDelete()) {
    	delete this;
    }
    //#]
}

bool OMReactive::hasWaitingNullTransitions() const {
    //#[ operation hasWaitingNullTransitions() const 
    return ((state & nullTransitionMask) != 0);
    //#]
}

OMTimeout* OMReactive::incarnateTimeout(short id, timeUnit delay, const OMHandle* theState) {
    //#[ operation incarnateTimeout(short,timeUnit,OMHandle) 
    OMTimeout* timeout = new OMTimeout(this, delay, theState);
    if (timeout != 0)
    {
    	timeout->setTimeoutId(id);
    }
    return timeout;
    //#]
}

bool OMReactive::isBehaviorStarted() const {
    //#[ operation isBehaviorStarted() const 
    return ((state & behaviorStartedStateMask) != 0);
    //#]
}

bool OMReactive::isDestroyEventResent() const {
    //#[ operation isDestroyEventResent() const 
    return ((state & destroyEventResentStateMask) != 0);
    //#]
}

bool OMReactive::isUnderDestruction() const {
    //#[ operation isUnderDestruction() const 
    return ((state & underDestructionStateMask) != 0);
    //#]
}

void OMReactive::popNullConfig() {
    //#[ operation popNullConfig() 
    popNullTransition();
    //#]
}

void OMReactive::popNullTransition() {
    //#[ operation popNullTransition() 
    if (state == 0) {
    	OM_NOTIFY_TO_ERROR("underflow in OMREactive less then 0 0 Config's\n");
    }
    else {
    	--state;
    }
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::processEvent(IOxfEvent* ev) {
    //#[ operation processEvent(IOxfEvent) 
    // the first received event, need to perform runToCompletion(),
    // if in startBehavior() shouldCompleteStartBehavior() returned true.
    // for any other event shouldCompleteStartBehavior(), should return false.
    if (shouldCompleteStartBehavior()) {
    	setCompleteStartBehavior(false);
    	// protect from recursive Triggered Operation calls
    	setBusy(true);
    	runToCompletion();
    	// end protection from recursive Triggered Operation calls
    	setBusy(false);
    }
    
    // check that this is not the dummy OMStartBehaviorEvent event
    TakeEventStatus res = eventNotConsumed;
    if (ev->getId() != OMStartBehaviorEventId) {
    	if (!isBusy()) {
    		// protect from recursive Triggered Operation calls
    		setBusy(true);
    		// Store the event in the OMReactive instance
    		setCurrentEvent(ev);
    		// consume the event
    		if (OXF::getRhp5CompatibleAPI()) {
    			// compatibility mode
    			res = static_cast<TakeEventStatus>(rootState_dispatchEvent(ev->getId()));
    		}
    		else {
    			// normal mode
    			res = rootState_processEvent();
    		}
    		// take null transitions (transitions without triggeres)
    		if (shouldCompleteRun()) {
    			runToCompletion();
    		}
    		// notify unconsumed event
    		if (res ==	eventNotConsumed) {
    			handleNotConsumed(ev, EventNotHandledByStatechart);
    		}	
    		// done with this event
    		setCurrentEvent(0);
    		// end protection from recursive Triggered Operation calls
    		setBusy(false);
    	}
    	else {
    		handleNotConsumed(ev, StateMachineBusy);
    	}
    }
    else {
    	// the start behavior event is consumed by taking the 0 transitions
    	// therefore it is always consumed
    	res = eventConsumed;
    }
    return res;
    //#]
}

void OMReactive::pushNullConfig() {
    //#[ operation pushNullConfig() 
    pushNullTransition();
    //#]
}

void OMReactive::pushNullTransition() {
    //#[ operation pushNullTransition() 
    if (state == nullTransitionMask) {
    	OM_NOTIFY_TO_ERROR("overflow in OMREactive too many active 0 Config's\n");
    }
    else {
    	++state;
    }
    //#]
}

bool OMReactive::restartBehaviorEnabled() const {
    //#[ operation restartBehaviorEnabled() const 
    return (supportRestartBehavior || globalSupportRestartBehavior);
    //#]
}

int OMReactive::rootState_dispatchEvent(IOxfEvent::ID /*id*/) {
    //#[ operation rootState_dispatchEvent(ID) 
    return rootState_processEvent();
    //#]
}

void OMReactive::rootState_entDef() {
    //#[ operation rootState_entDef() 
    if ((rootState != 0) && (rootState->active == 0)) {
    	rootState->entDef();
    }
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::rootState_processEvent() {
    //#[ operation rootState_processEvent() 
    if (isUnderDestruction()) {
    	// Destruction had begun, so no more dispatching.
    #ifdef _OMINSTRUMENT
    	AnimServices::notifyError("Event ignored - Instance is under destruction\n\n");
    #endif
    	return eventNotConsumed; 
    }
    TakeEventStatus res = eventNotConsumed;
    if (rootState == 0) {
    #ifdef _OMINSTRUMENT
    	AnimServices::notifyError("\nEvent ignored - Instance has no root state\n\n");
    #endif
    	return eventNotConsumed;
    }
    if (rootState->active != 0){
    	if (OXF::getRhp5CompatibleAPI()) {
    		// compatibility mode
    		if (currentEvent)
    		{
    			res = static_cast<TakeEventStatus>(
    				rootState->active->takeEvent(currentEvent->getId()));
    		}
    	}
    	else {
    		// normal mode
    		res = rootState->active->handleEvent();
    	}
    	return res;
    }
    else {
    #ifdef _OMINSTRUMENT
    	AnimServices::notifyError("\nEvent ignored - Instance did not execute startBehavior()\n\n");
    #endif
    	return eventNotConsumed;
    }
    //#]
}


//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
void OMReactive::rootState_serializeStates(AOMSState* aomsState) const {
    //#[ operation rootState_serializeStates(AOMSState) const 
    // serialize states from the class statechart 
    if(rootState != 0)
    {
    	// call serialization for the root state
    	rootState->serializeStates(aomsState);
    }
    //#]
}

//#[ ignore 

#endif // _OMINSTRUMENT
//#]

void OMReactive::runToCompletion() {
    //#[ operation runToCompletion() 
    int nullStepCount = 0;
    
    // remember the real event, and relace it with a 0 event
    IOxfEvent* evReal = currentEvent;
    OMNullEvent evNull;
    setCurrentEvent(&evNull);
    
    // If untriggered transitions are "hot" take them
    while (hasWaitingNullTransitions())
    {
    	++nullStepCount;
    	if ((maxNullSteps > 0) &&
    		(nullStepCount > maxNullSteps)) 
    	{
    		// Found infinite loop
    		break;
    	}
    #ifdef _OMINSTRUMENT
    	// notify a single step is about to be taken
    	AnimServices::notifyNullTransition(this);
    #endif 	// _OMINSTRUMENT
    	// avoid event consumtion
    	if (isUnderDestruction())
    	{
    		break;
    	}
    	TakeEventStatus res = eventNotConsumed;
    	if (OXF::getRhp5CompatibleAPI())
    	{
    		// compatibility mode
    		res = static_cast<TakeEventStatus>(rootState_dispatchEvent(evNull.getId()));
    	}
    	else
    	{
    		// normal mode
    		res = rootState_processEvent();
    	}
    	// No more null transitions to take
    	if (res == eventNotConsumed)
    	{
    		break;
    	}
    }
    
    // restore the real event
    setCurrentEvent(evReal);
    
    // Treat the infinite loop case
    if ((maxNullSteps > 0) &&
    	(nullStepCount > maxNullSteps))
    {
    	state = state & (~nullTransitionMask);
    #ifdef _OMINSTRUMENT
    	AnimServices::notifyError(this, "Infinite Loop of Null Transitions");
    #else
    	// notify the infinite loop for debugging
    	OM_NOTIFY_TO_ERROR("Exception - Infinite Loop of null transitions found\n");
    #endif // _OMINSTRUMENT
    }
    //#]
}

IOxfTimeout* OMReactive::scheduleTimeout(OxfTimeUnit delay, const char* targetStateName) {
    //#[ operation scheduleTimeout(OxfTimeUnit,char) 
    IOxfTimeout* timeout = NULL;
    
    OMTimerManager* sysTimer = OMTimerManager::instance();
    if (sysTimer != 0)
    { 
    	//If heap is full try to empty out the cancel timeout to gain
    	//memory space.       
    	if(sysTimer->isHeapFull())
    		(void)sysTimer->cleanupCanceledTimeouts();   
    
    	// schedule timeout
    	timeout = new OMTimeout(this, delay, targetStateName);
    	if (timeout != 0)
    	{
    		// Delegating the request to timer
    		bool isSet = sysTimer->set(timeout);
    		if (!isSet)
    		{
    			handleTimeoutSetFailure(timeout);
    		}
    	}
    #ifdef _OMINSTRUMENT
    	// notify the event queue of this
    	AnimServices::notifyTimeoutSet(timeout);
    #endif
    }
    return timeout;
    //#]
}

bool OMReactive::send(IOxfEvent* ev, const IOxfEventGenerationParams& params) {
    //#[ operation send(IOxfEvent,IOxfEventGenerationParams) 
    bool res = false;
    if (!OXF::getRhp5CompatibleAPI())
    {
    	// normal mode
    	res = sendEvent(ev, params);
    }
    else
    {
    	// compatibility mode
    	void* sender = params.getSender();
    	if (sender != 0)
    	{
    		// call gen(event, sender)
    		res = gen(static_cast<OMEvent*>(ev), sender);
    	}
    	else
    	{
    		// call gen(event, fromISR)
    		res = gen(static_cast<OMEvent*>(ev), params.getFromISR());
    	}
    }
    return res;
    //#]
}

bool OMReactive::send(IOxfEvent* ev) {
    //#[ operation send(IOxfEvent) 
    #ifndef _OMINSTRUMENT
    	static OMOSEventGenerationParams params;
    #else
    	OMOSEventGenerationParams params;
    #endif
    return send(ev, params);
    //#]
}

bool OMReactive::sendEvent(IOxfEvent* ev, const IOxfEventGenerationParams& params) {
    //#[ operation sendEvent(IOxfEvent,IOxfEventGenerationParams) 
    if (isUnderDestruction() &&
    	!ev->isTypeOf(OMReactiveTerminationEventId))
    {
    	// Destruction had begun,
    	// ignore events
    
    #ifdef _OMINSTRUMENT
    	// Inside an interrupt request this code is not allowed
    	if (!params.getFromISR())
    	{
    		AnimServices::notifyError("Event sent to an under-destruction item is ignored.");
    	}
    #endif // _OMINSTRUMENT
    	
    	return false; 
    }
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifySendingEvent(ev, params);
    #endif // _OMINSTRUMENT
    
    // Set the Receiver of the event
    bool result = false;
    IOxfActive* context = getActiveContext();
    if ((ev != 0) && (context != 0))
    {
    	ev->setDestination(this);
    	if (!OXF::getRhp5CompatibleAPI())
    	{
    		// normal mode
    		result = context->queue(ev, params);
    	}
    	else
    	{
    		// compatibility mode
    		result = static_cast<OMThread*>(context)->queueEvent(
    			static_cast<OMEvent*>(ev),
    			params.getFromISR());
    
    	}
    }
    return result;
    //#]
}


//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
void OMReactive::serializeStates(AOMSState* aomsState) const {
    //#[ operation serializeStates(AOMSState) const 
    AnimServices::addTerminateState(aomsState, shouldTerminate());
    //#]
}

//#[ ignore 

#endif // _OMINSTRUMENT
//#]

void OMReactive::setActiveContext(IOxfActive* context) {
    //#[ operation setActiveContext(IOxfActive) 
    activeContext = context;
    // For compatibility mode (OXF::getRhp5CompatibleAPI())
    // the static_cast is done without 'if (OXF::getRhp5CompatibleAPI())'
    // in order to support pre-main creation of reactive instances -
    // the OXF::setRhp5CompatibleAPI(true) is called from within the main
    // and therefore if we will check the compatibility mode,
    // pre-main reactive instances myThread member will not be set
    // which will lead to runtime error if the framework is later moved into compatibility mode.
    myThread = static_cast<OMThread*>(activeContext);
    //#]
}

void OMReactive::setActiveContext(IOxfActive* context, bool activeInstance) {
    //#[ operation setActiveContext(IOxfActive,bool) 
    if (context != getActiveContext()) {
    	setActive(activeInstance);
    	setActiveContext(context); 
    }
    // Make sure we have a context
    if (getActiveContext() == 0) {
    	// The fallback is that the object is dispatched by the system thread.
    	setActiveContext(OMMainThread::instance());
    }
    //#]
}

void OMReactive::setBehaviorStarted() {
    //#[ operation setBehaviorStarted() 
    state |= behaviorStartedStateMask;
    //#]
}

void OMReactive::setCurrentEvent(IOxfEvent* ev) {
    //#[ operation setCurrentEvent(IOxfEvent) 
    currentEvent = ev;
    if (OXF::getRhp5CompatibleAPI()) {
    	// For compatibility mode
    	event = static_cast<OMEvent*>(ev);
    }
    //#]
}

void OMReactive::setDestroyEventResent() {
    //#[ operation setDestroyEventResent() 
    state |= destroyEventResentStateMask;
    //#]
}

void OMReactive::setEventGuard(const OMProtected& guard) {
    //#[ operation setEventGuard(OMProtected) 
    setEventGuard(&guard);
    //#]
}

void OMReactive::setInDtor() {
    //#[ operation setInDtor() 
    setUnderDestruction();
    //#]
}

void OMReactive::setShouldDelete(bool b) {
    //#[ operation setShouldDelete(bool) 
    if (b) {
    	state |= deleteOnTerminateStateMask;
    }
    else {
    	state &= ~deleteOnTerminateStateMask;
    	if (isActive() && (getActiveContext() != 0))
    	{
    		static_cast<OMThread*>(getActiveContext())->setDeletionAllowed(false);
    	}
    }
    //#]
}

void OMReactive::setThread(OMThread* thread, bool activeInstance) {
    //#[ operation setThread(OMThread,bool) 
    setActiveContext(thread, activeInstance);
    //#]
}

void OMReactive::setToGuardReactive(bool flag) {
    //#[ operation setToGuardReactive(bool) 
    toGuardReactive = toGuardReactive || flag;
    if (getActiveContext() != 0) {
    	static_cast<OMThread*>(getActiveContext())->setToGuardThread(flag);
    }
    //#]
}

void OMReactive::setUnderDestruction() {
    //#[ operation setUnderDestruction() 
    state |= underDestructionStateMask;
    //#]
}

bool OMReactive::shouldCompleteRun() const {
    //#[ operation shouldCompleteRun() const 
    return ((state & nullTransitionMask) != 0);
    //#]
}

bool OMReactive::shouldCompleteStartBehavior() const {
    //#[ operation shouldCompleteStartBehavior() const 
    return ((state & shouldCompleteStartBehaviorStateMask) != 0);
    //#]
}

bool OMReactive::shouldSupportDirectDeletion() const {
    //#[ operation shouldSupportDirectDeletion() const 
    return (supportDirectDeletion || globalSupportDirectDeletion);
    //#]
}

bool OMReactive::startBehavior() {
    //#[ operation startBehavior() 
    if (isUnderDestruction())
    {
    	return false;
    }
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStartBehaviorBegin(this);
    #endif
    
    if (!isBehaviorStarted() ||
    	restartBehaviorEnabled())
    {
    	setBehaviorStarted();
    	// take the default transition
    	rootState_entDef();
    	// This takes care of transitions without triggering events
    	if (shouldCompleteRun())
    	{
    		// generate a dummy event in case the class doesn't receive any external events
    		// this causes the runToCompletion() after the default transition to be taken -
    		// in the class own thread (for active classes)
    		setCompleteStartBehavior(true);
    		(void) send(&theStartBehaviorEvent);
    	}
    }
       
    // and deleting the item if it reached a terminate connector
    bool toTerminate = shouldTerminate();
    if (toTerminate)
    {
    	destroy();
    }
    
    #ifdef _OMINSTRUMENT
    AnimServices::notifyStartBehaviorEnd(this);
    #endif
    
    return (!toTerminate);
    //#]
}

IOxfReactive::TakeEventStatus OMReactive::takeEvent(OMEvent* ev) {
    //#[ operation takeEvent(OMEvent) 
    IOxfEvent* e = ev;
    return handleEvent(e);
    //#]
}

void OMReactive::takeTrigger(OMEvent* ev) {
    //#[ operation takeTrigger(OMEvent) 
    if (!(isUnderDestruction() || // check that the behavior should still run
    	(shouldTerminate() && shouldDelete()))) 
    {
    	IOxfEvent* e = ev;
    	handleTrigger(e);
    }
    //#]
}

void OMReactive::terminate(const char* theTerminator) {
    //#[ operation terminate(char*) 
    endBehavior(theTerminator);
    //#]
}

int OMReactive::getMaxNullSteps() {
    return maxNullSteps;
}

void OMReactive::setMaxNullSteps(int p_maxNullSteps) {
    maxNullSteps = p_maxNullSteps;
}

unsigned long OMReactive::getReactiveInternalState() const {
    return state;
}

void OMReactive::setReactiveInternalState(unsigned long p_state) {
    state = p_state;
}

bool OMReactive::isFrameworkInstance() const {
    return frameworkInstance;
}

void OMReactive::setFrameworkInstance(bool p_frameworkInstance) {
    frameworkInstance = p_frameworkInstance;
}

bool OMReactive::isActive() const {
    return active;
}

void OMReactive::setActive(bool p_active) {
    active = p_active;
}

bool OMReactive::isBusy() const {
    return busy;
}

void OMReactive::setBusy(bool p_busy) {
    busy = p_busy;
}

bool OMReactive::getToGuardReactive() const {
    return toGuardReactive;
}

bool OMReactive::getSupportDirectDeletion() const {
    return supportDirectDeletion;
}

void OMReactive::setSupportDirectDeletion(bool p_supportDirectDeletion) {
    supportDirectDeletion = p_supportDirectDeletion;
}

bool OMReactive::getGlobalSupportDirectDeletion() {
    return globalSupportDirectDeletion;
}

void OMReactive::setGlobalSupportDirectDeletion(bool p_globalSupportDirectDeletion) {
    globalSupportDirectDeletion = p_globalSupportDirectDeletion;
}

bool OMReactive::getSupportRestartBehavior() const {
    return supportRestartBehavior;
}

void OMReactive::setSupportRestartBehavior(bool p_supportRestartBehavior) {
    supportRestartBehavior = p_supportRestartBehavior;
}

bool OMReactive::getGlobalSupportRestartBehavior() {
    return globalSupportRestartBehavior;
}

void OMReactive::setGlobalSupportRestartBehavior(bool p_globalSupportRestartBehavior) {
    globalSupportRestartBehavior = p_globalSupportRestartBehavior;
}

IOxfActive* OMReactive::getActiveContext() const {
    return activeContext;
}

IOxfEvent* OMReactive::getCurrentEvent() const {
    return currentEvent;
}

const OMProtected* OMReactive::getEventGuard() const {
    return eventGuard;
}

void OMReactive::setEventGuard(const OMProtected* p_OMProtected) {
    eventGuard = p_OMProtected;
}

OMThread* OMReactive::getMyThread() const {
    return myThread;
}

void OMReactive::cleanUpRelations() {
    if(activeContext != 0)
        {
            activeContext = 0;
        }
    if(currentEvent != 0)
        {
            currentEvent = 0;
        }
    if(event != 0)
        {
            event = 0;
        }
    if(eventGuard != 0)
        {
            eventGuard = 0;
        }
    if(myThread != 0)
        {
            myThread = 0;
        }
    if(rootState != 0)
        {
            rootState = 0;
        }
}

//---------------------------------------------------------------------------- 
// inline operations for OMReactive
//---------------------------------------------------------------------------- 
inline bool OMReactive::shouldTerminate() const {
    //#[ operation shouldTerminate() const 
    return ((state & terminateConnectorReachedStateMask) != 0);
    //#]
}



//
//! Log: $Log: omreactive.cpp $
//! Log: Revision 1.161  2007/04/15 09:41:29  ilgiga
//! Log: bug fix 102456
//! Log: Revision 1.160.1.2  2007/04/15 05:42:32  ilgiga
//! Log: bug fix 102456
//


