//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMProtected
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/omprotected.cpp $
//!	File version	: $Revision: 1.19 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:11 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: omprotected.cpp 1.19 2007/04/06 07:08:11 ilgiga Exp $";
#endif
//#]

#include "omprotected.h"
#include "os.h"

//----------------------------------------------------------------------------
// omprotected.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Guards 

//## class OMProtected 



OMProtected::OMProtected() : theMutex(NULL) {
    //#[ operation OMProtected() 
    initializeMutex();
    //#]
}

OMProtected::OMProtected(const OMProtected& omProtected) {
    //#[ operation OMProtected(const OMProtected& ) 
    *this = omProtected;
    //#]
}

void OMProtected::cleanupMutex() {
    //#[ operation cleanupMutex() 
    if (theMutex != 0) {
    	delete theMutex;
    	theMutex = 0;
    }
    //#]
}


//#[ ignore 
#ifndef OM_OS_USE_FREE
//#]
void OMProtected::free() const {
    //#[ operation free() const 
    unlock();
    //#]
}

//#[ ignore 

#endif
//#]

const OMProtected& OMProtected::getGuard() const {
    //#[ operation getGuard() const 
    return *this;
    //#]
}

void OMProtected::initializeMutex() {
    //#[ operation initializeMutex() 
    if (theMutex == NULL) {
    	theMutex = OMOSFactory::instance()->createOMOSMutex();
    }
    //#]
}

void OMProtected::lock() const {
    //#[ operation lock() const 
    if (theMutex != 0)
    {
    	theMutex->lock();
    }
    //#]
}

OMProtected& OMProtected::operator=(const OMProtected& omProtected) {
    //#[ operation operator=(const OMProtected& ) 
    theMutex = NULL;
    if (omProtected.theMutex!= NULL)
    {
    	initializeMutex();
    }
    return *this;
    
    //#]
}

void OMProtected::unlock() const {
    //#[ operation unlock() const 
    if (theMutex != 0)
    {
    	theMutex->unlock();
    }
    //#]
}


//## package Design::oxf::Services::Guards 

//## class OMGuard 




//
//! Log: $Log: omprotected.cpp $
//! Log: Revision 1.19  2007/04/06 07:08:11  ilgiga
//! Log: bug fix 98191
//


