//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: TimeManagement
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OXFTimeManagement.h $
//!	File version	: $Revision: 1.16 $
//
//!	Date changed	: $Date: 2007/04/06 07:08:05 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OXFTimeManagement_H 

#define OXFTimeManagement_H 

#include "IOxfTickTimerFactory.h"

//----------------------------------------------------------------------------
// OXFTimeManagement.h                                                                  
//----------------------------------------------------------------------------

class IOxfTimeout;
class OMDelay;
class OMTimeout;
class OMTimerManager;
class OMTimerManagerDefaults;
class OXF;

//## package Design::oxf::Services::Time::TimeManagement 


// The time services implementation.
// This package does not contain tick-timers which are part of the adapters.

// typedef of IOxfTickTimerFactory for backward compatibility
//## type OMAbstractTickTimerFactory 
typedef IOxfTickTimerFactory OMAbstractTickTimerFactory;


// Less than timeouts compare that compares two timeouts based on the due time.
// Used to sort & find the timeouts collection of the timer manager.
// Argument const IOxfTimeout& t1 : 
// The source timeout
// Argument const IOxfTimeout& t2 : 
// The other timeout
//## operation operator <(IOxfTimeout,IOxfTimeout) 
bool operator <(const IOxfTimeout& t1, const IOxfTimeout& t2);

// Equal to timeouts compare that compares two timeouts based on the due time.
// Used to sort & find the timeouts collection of the timer manager.
// Argument const IOxfTimeout& t1 : 
// The source timeout
// Argument const IOxfTimeout& t2 : 
// The other timeout
//## operation operator ==(IOxfTimeout,IOxfTimeout) 
bool operator ==(const IOxfTimeout& t1, const IOxfTimeout& t2);

// Greater than timeouts compare that compares two timeouts based on the due time.
// Used to sort & find the timeouts collection of the timer manager.
// Argument const IOxfTimeout& t1 : 
// The source timeout
// Argument const IOxfTimeout& t2 : 
// The other timeout
//## operation operator >(IOxfTimeout,IOxfTimeout) 
bool operator >(const IOxfTimeout& t1, const IOxfTimeout& t2);



#endif  
//
//! Log: $Log: OXFTimeManagement.h $
//! Log: Revision 1.16  2007/04/06 07:08:05  ilgiga
//! Log: bug fix 98191
//


