//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMTimerManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMTimerManager.h $
//!	File version	: $Revision: 1.25 $
//
//!	Date changed	: $Date: 2007/06/17 07:41:03 $
//!	Last change by	: $Author: ilelpa $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMTimerManager_H 

#define OMTimerManager_H 

#include "OXFTimeManagement.h"
#include "IOxfAnimTimerManager.h"
#include "IOxfEvent.h"
#include "IOxfTimeout.h"
#include "omcollec.h"
#include "omheap.h"
#include "OMTimerManagerDefaults.h"
#include "OXFTypes.h"

//----------------------------------------------------------------------------
// OMTimerManager.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfReactive;
class IOxfTickTimerFactory;
class OMDelay;
template <class  Concept> class OMIterator;
class OMOSMutex;
class OMOSTimer;
class OMThread;
class OMTimeout;
class OXF;

//## package Design::oxf::Services::Time::TimeManagement 


// The timer manager is responsible for timeout bookkeeping and dispatching.
// In Extensive Timeout Management mode it is also responsible for timeouts canceling.
//## class OMTimerManager 
class OMTimerManager : public IOxfAnimTimerManager {


////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument OxfTimeUnit ticktime : 
    // The tick-timer resolution
    // Argument unsigned int maxTM : 
    // The maximum number of timeouts that can be active in the system
    // Argument bool isRealTimeModel : 
    // Real-time vs. simulated-time mode
    //## operation OMTimerManager(OxfTimeUnit,unsigned int,bool) 
    RP_FRAMEWORK_DLL OMTimerManager(OxfTimeUnit ticktime = OMTimerManagerDefaults::defaultTicktime, unsigned int maxTM
     = OMTimerManagerDefaults::defaultMaxTM, bool isRealTimeModel = true);
    
    // Cleanup
    //## operation ~OMTimerManager() 
    RP_FRAMEWORK_DLL virtual ~OMTimerManager();

private :
    
    // disable copy CTOR and = operator
    // Argument const OMTimerManager& other : 
    // The manager to copy
    //## operation OMTimerManager(OMTimerManager) 
    RP_FRAMEWORK_DLL OMTimerManager(const OMTimerManager& other);


////    Operations    ////
public :
    
    // advance the system time to the next waiting timeout
    //## operation advanceTime() 
    RP_FRAMEWORK_DLL virtual void advanceTime();
    
    // the timer manager callback (activated by the tick-timer)
    // Argument void * me : 
    // The timer manager
    //## operation cbkBridge(void *) 
    RP_FRAMEWORK_DLL static void cbkBridge(void * me);
    
    // Remove canceled timeouts from the heap
    // Returns true is canceled timeouts were removed
    //## operation cleanupCanceledTimeouts() 
    RP_FRAMEWORK_DLL bool cleanupCanceledTimeouts();
    
    // Singleton cleanup
    //## operation clearInstance() 
    RP_FRAMEWORK_DLL static void clearInstance();
    
    //## operation consumeTime(OxfTimeUnit,OxfTimeUnit) 
    RP_FRAMEWORK_DLL void consumeTime(OxfTimeUnit interval, OxfTimeUnit step = 1);
    
    // Reduce the number of active threads
    //## operation decNonIdleThreadCounter() 
    RP_FRAMEWORK_DLL void decNonIdleThreadCounter();
    
    // Cleanup
    //## operation destroyTimer() 
    RP_FRAMEWORK_DLL inline void destroyTimer() {
        //#[ operation destroyTimer() 
        this->~OMTimerManager();
        //#]
    }
    
    
    // Returns the elapsed time
    //## operation getElapsedTime() const 
    RP_FRAMEWORK_DLL OxfTimeUnit getElapsedTime() const;
    
    // Advance the simulated/instrumentation time and send matured timeouts
    //## operation goNextAndPost() 
    RP_FRAMEWORK_DLL void goNextAndPost();
    
    // Increase the number of active threads
    //## operation incNonIdleThreadCounter() 
    RP_FRAMEWORK_DLL inline void incNonIdleThreadCounter() {
        //#[ operation incNonIdleThreadCounter() 
        ++nonIdleThreadCounter;
        //#]
    }
    
    
    // Initialize the timer manager
    //## operation init() 
    RP_FRAMEWORK_DLL virtual void init();
    
    // Lazy initialization of the timer manager singleton
    // Argument OxfTimeUnit ticktime : 
    // The tick-timer resolution
    // Argument unsigned int maxTM : 
    // The maximum number of timeouts that can be active in the system
    // Argument bool isRealTimeModel : 
    // Real-time vs. simulated-time mode
    //## operation initInstance(OxfTimeUnit,unsigned int,bool) 
    RP_FRAMEWORK_DLL static OMTimerManager* initInstance(OxfTimeUnit ticktime = OMTimerManagerDefaults::defaultTicktime
    , unsigned int maxTM = OMTimerManagerDefaults::defaultMaxTM, bool isRealTimeModel = true);
    
    // Get the singleton
    //## operation instance() 
    RP_FRAMEWORK_DLL static OMTimerManager* instance();
    
    //## operation isHeapFull() const 
    RP_FRAMEWORK_DLL bool isHeapFull() const;
    
    // Start a guarded critical section
    //## operation lock() 
    RP_FRAMEWORK_DLL void lock();
    
    // A service to be notified after deltaT time.
    // Argument IOxfReactive* reactive : 
    // The reactive requesting the service
    // Argument const OxfTimeUnit deltaT : 
    // The requested time to elapse
    // Argument OxfTimeUnit& baseTime : 
    // An output parameter containing the current time
    //## operation requestTimeNotification(IOxfReactive*,const OxfTimeUnit,IOxfTimeout*&,OxfTimeUnit&) 
    RP_FRAMEWORK_DLL virtual void requestTimeNotification(IOxfReactive* reactive, const OxfTimeUnit deltaT, 
    IOxfTimeout*& timeout, OxfTimeUnit& baseTime);
    
    // Design level debugging support - resume time processing
    //## operation resume() 
    RP_FRAMEWORK_DLL inline void resume() {
        //#[ operation resume() 
        suspended = false; 
        //#]
    }
    
    
    // set - adding a timeout to be managed
    // Argument IOxfTimeout* timeout : 
    // The new timeout
    //## operation set(IOxfTimeout) 
    RP_FRAMEWORK_DLL bool set(IOxfTimeout* timeout);
    
    // Update the time
    // Argument OxfTimeUnit newTime : 
    // The new time
    //## operation setElapsedTime(OxfTimeUnit) 
    RP_FRAMEWORK_DLL void setElapsedTime(OxfTimeUnit newTime);
    
    // unschedule the timeout - used only from ~Timeout()
    // Argument OMTimeout* timeout : 
    // The timeout to unsched
    //## operation softUnschedTm(OMTimeout) 
    RP_FRAMEWORK_DLL void softUnschedTm(OMTimeout* timeout);
    
    // Design level debugging support - suspend time processing
    //## operation suspend() 
    RP_FRAMEWORK_DLL void suspend();
    
    // End of the manager critical section
    //## operation unlock() 
    RP_FRAMEWORK_DLL void unlock();
    
    // Canceling a timeout for a single object or a single object.
    // 
    // This method is used
    //   (1) in case of exiting a state - timeout no longer relevant
    //   (2) In case where the object is destroyed. In that case all timers associated with the object are destroyed. 
    // 
    // Canceling a timeout requires one of two actions:
    // - Deleting the timeout from the timeouts, or
    // - Canceling it inside the event queue, if already dispatched. This in done by iterating the "enqueued but not 
    // yet dispatched" list.
    // Argument IOxfEvent::ID id : 
    // The timeout id
    // Argument IOxfReactive* c : 
    // The timeout destination
    //## operation unschedTm(ID,IOxfReactive) 
    RP_FRAMEWORK_DLL void unschedTm(IOxfEvent::ID id, IOxfReactive* c);

protected :
    
    // Send a matured timeout to its destination.
    // Also wakeup  completed delays.
    // Argument IOxfTimeout* timeout : 
    // The matured timeout
    //## operation action(IOxfTimeout) 
    RP_FRAMEWORK_DLL virtual void action(IOxfTimeout* timeout);
    
    // Backward compatibility API.
    // Send a matured timeout to its destination.
    // Also wakeup  completed delays.
    // Argument OMTimeout* timeout : 
    // The matured timeout
    //## operation action(OMTimeout) 
    RP_FRAMEWORK_DLL virtual void action(OMTimeout* timeout);

private :
    
    // find a timeout by id & destination (for timeout cancellation, on reactive class deletion)
    // Argument IOxfEvent::ID id : 
    // The timeout id
    // Argument const IOxfReactive* c : 
    // The timeout destination
    //## operation findInList(ID,IOxfReactive) const 
    RP_FRAMEWORK_DLL IOxfTimeout* findInList(IOxfEvent::ID id, const IOxfReactive* c) const;
    
    // return a static instance of the timer manager
    //## operation getStaticTimerManager() 
    RP_FRAMEWORK_DLL static OMTimerManager* getStaticTimerManager();
    
    // Create/get the timer manager singleton
    // Argument OxfTimeUnit tickTime : 
    // The tick-timer resolution
    // Argument unsigned int maxTM : 
    // The maximum number of timeouts that can be active in the system
    // Argument bool isRealTimeModel : 
    // Real-time vs. simulated-time mode
    // Argument bool forceInitialization : 
    // When true, reinitialize the singleton even if it was already initialized
    //## operation getStaticTimerManager(OxfTimeUnit,unsigned int,bool,bool) 
    RP_FRAMEWORK_DLL static OMTimerManager* getStaticTimerManager(OxfTimeUnit tickTime, unsigned int maxTM, bool 
    isRealTimeModel, bool forceInitialization = false);
    
    // simulated time/instrumentation tick
    //## operation goNext() 
    RP_FRAMEWORK_DLL void goNext();
    
    // initialize the timeouts static memory pool
    //## operation initTimeoutsMemoryPool() 
    RP_FRAMEWORK_DLL static void initTimeoutsMemoryPool();
    
    // Disabled assignment operator
    // Argument const OMTimerManager& other : 
    // The manager to copy
    //## operation operator=(OMTimerManager) 
    RP_FRAMEWORK_DLL OMTimerManager& operator=(const OMTimerManager& other);
    
    // handle the matured timeouts, and handle timer overflow
    //## operation post() 
    RP_FRAMEWORK_DLL void post();
    
    // Correct the timeouts due time and the time itself when the time_ field overflows.
    //## operation resetTimeoutsDueTime() 
    RP_FRAMEWORK_DLL void resetTimeoutsDueTime();
    
    // Set the timeout due time.
    // Done when the timeout is added to the manager based on the timeout delay and the current system time.
    // Argument IOxfTimeout* timeout : 
    // The timeout
    //## operation setTimeoutDueTime(IOxfTimeout) const 
    RP_FRAMEWORK_DLL void setTimeoutDueTime(IOxfTimeout* timeout) const;
    
    // respond to a tick
    //## operation timeTickCbk() 
    RP_FRAMEWORK_DLL void timeTickCbk();


////    Additional operations    ////
public :
    
    //## auto_generated 
    OxfTimeUnit getTick() const;
    
    //## auto_generated 
    bool getRealTimeModel() const;

private :
    
    //## auto_generated 
    long getNonIdleThreadCounter() const;


////    Attributes    ////
private :
    
    // The matured timeouts
    OMCollection<IOxfTimeout*> matured;		//## attribute matured 
    
    // The current system time
    OxfTimeUnit time_;		//## attribute time_ 
    
    // timer resolution, updated every tick ms and counts time
    OxfTimeUnit tick;		//## attribute tick 
    
    // The number of active threads. 
    // Used for simulated time support (a tick occur only when all the threads are idle).
    long nonIdleThreadCounter;		//## attribute nonIdleThreadCounter 
    
    // time model can be real or simulated
    bool realTimeModel;		//## attribute realTimeModel 
    
    // Used by AOM to suspend/resume
    bool suspended;		//## attribute suspended 
    
    // overflow watermark;
    static const OxfTimeUnit overflowMark;		//## attribute overflowMark 
    
    // Singleton state flag, used to identify that the singleton is destroyed (due to exit())
    static bool timerManagerSingletonDestroyed;		//## attribute timerManagerSingletonDestroyed 
    

////    Relations and components    ////
private :
    
    OMOSMutex* guard;		//## link guard 
    
    
    OMOSTimer* tickTimer;		//## link tickTimer 
    
    
    // The pending timeouts (not yet matured)
    OMHeap<IOxfTimeout> timeouts;		//## link timeouts 
    


};


#endif  
//
//! Log: $Log: OMTimerManager.h $
//! Log: Revision 1.25  2007/06/17 07:41:03  ilelpa
//! Log: Decoupling AOM-OXF
//


