//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMTimerManager
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMTimerManager.cpp $
//!	File version	: $Revision: 1.37 $
//
//!	Date changed	: $Date: 2007/06/19 11:48:55 $
//!	Last change by	: $Author: ilelpa $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMTimerManager.cpp 1.37 2007/06/19 11:48:55 ilelpa Exp $";
#endif
//#]

#include "OMTimerManager.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFEvents.h"
#include "IOxfReactive.h"
#include "IOxfTickTimerFactory.h"
#include "OMDelay.h"
#include "OMIterator.h"
#include "os.h"
#include "omthread.h"
#include "OMTimeout.h"
#include "oxf.h"

//----------------------------------------------------------------------------
// OMTimerManager.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::Time::TimeManagement 

//## class OMTimerManager 


// Static class member attribute
const OxfTimeUnit OMTimerManager::overflowMark = 0x80000000;
// Static class member attribute
bool OMTimerManager::timerManagerSingletonDestroyed = false;


//#[ ignore 
/*
//#]
OMTimerManager::OMTimerManager(const OMTimerManager& other) {
    //#[ operation OMTimerManager(OMTimerManager) 
    //#]
}

//#[ ignore 

*/
//#]

OMTimerManager::OMTimerManager(OxfTimeUnit ticktime, unsigned int maxTM, bool isRealTimeModel) : matured(
static_cast<int>(maxTM)) ,time_(0) ,tick(ticktime) ,nonIdleThreadCounter(0) ,realTimeModel(true) ,suspended(false) ,
timeouts(static_cast<int>(maxTM)) {
    //#[ operation OMTimerManager(OxfTimeUnit,unsigned int,bool) 
    OMTimeout::OMMemoryPoolSetIncrement(static_cast<int>(maxTM));
    tickTimer = NULL;
    guard = NULL;
    realTimeModel = isRealTimeModel;
    suspended = false;
    //#]
}

OMTimerManager::~OMTimerManager() {
    //#[ operation ~OMTimerManager() 
    // mark the timer manager singleton is destroyed
    if (getStaticTimerManager() == this) {
    	timerManagerSingletonDestroyed = true;
    }
    
    // Without grabbing the guard before deleting the tick timer, there is a
    // possible race condition. The tick timer could be cancelled after it
    // has destroyed a timeout but before it has removed it from the heap. 
    // Grabbing the lock insures that the tick timer can complete 
    // OMTimerManager::post before it is cancelled.
    lock ();
    // delete the timer - done first to stop timer work
    delete tickTimer;
    tickTimer = NULL;
    unlock ();
    
    // reset time
    time_ = 0;
    tick = 0;
    // delete the guard
    delete guard;
    guard = NULL;
    // cleanup the timeouts & delete the timouts left in it
    // this should be done after the deletion of the mutex
    while (!timeouts.isEmpty()) {
    	IOxfTimeout* t = timeouts.top();
    	timeouts.trim();
    	delete t;
    }
    //#]
}

void OMTimerManager::action(IOxfTimeout* timeout) {
    //#[ operation action(IOxfTimeout) 
    if (timeout->getId() != OMTimeoutDelayId)
    {
    	// only "real" timeouts
    	// send the timeout
    	IOxfReactive* reactive = timeout->getDestination();
    	if (reactive != 0)
    	{
    		OMOSEventGenerationParams params(this);
    		(void) reactive->send(timeout, params);
    	}
    	else
    	{
    		// cleanup
    		timeout->destroy();
    	}
    }
    else
    {
    	// A delay request - The thread is the receiver	
    	OMDelay* d = reinterpret_cast<OMDelay*>(timeout->getDestination());
    	d->wakeup();
    	///////////////////////
    	// destroy the timeout
    	///////////////////////
    	// first cancel the timeout
    	// so that the timeout will not call -
    	// the destination cancelTimeout()
    	// set the destiation to 0 to avoid query of the destination
    	timeout->setDestination(0);
    	timeout->cancel();
    	timeout->destroy();
    }
    //#]
}

void OMTimerManager::action(OMTimeout* timeout) {
    //#[ operation action(OMTimeout) 
    IOxfTimeout* tm = timeout;
    action(tm);
    //#]
}

void OMTimerManager::advanceTime() {
    //#[ operation advanceTime() 
    goNextAndPost();
    //#]
}

void OMTimerManager::cbkBridge(void * me) {
    //#[ operation cbkBridge(void *) 
    reinterpret_cast<OMTimerManager*>(me)->timeTickCbk();
    //#]
}

bool OMTimerManager::cleanupCanceledTimeouts() {
    //#[ operation cleanupCanceledTimeouts() 
    bool res = false;
    OMTimeout examplar;
    examplar.cancel();
    
    lock();
    bool done = false;
    while (!done)
    {
    	IOxfTimeout* tm = timeouts.remove(&examplar);
    	if (tm != 0)
    	{
    		tm->destroy();
    		res = true;
    	}
    	else
    	{
    		done = true;
    	}
    }
    unlock();
    return res;
    //#]
}

void OMTimerManager::clearInstance() {
    //#[ operation clearInstance() 
    if (getStaticTimerManager() != NULL)
    {
    	getStaticTimerManager()->destroyTimer();
    }
    //#]
}

void OMTimerManager::consumeTime(OxfTimeUnit interval, OxfTimeUnit step) {
    //#[ operation consumeTime(OxfTimeUnit,OxfTimeUnit) 
    if (!realTimeModel) {
    	int phases = static_cast<int>(interval/step);
    	for (int i = 0; i < phases; i++) {
    		lock();
    		time_ += step;
    		unlock(); 
    		// Always need to check for mature timeouts
    		post();
    	}
    }
    
    //#]
}

void OMTimerManager::decNonIdleThreadCounter() {
    //#[ operation decNonIdleThreadCounter() 
    if (nonIdleThreadCounter > 0)
    {
    	--nonIdleThreadCounter;
    }
    //#]
}

IOxfTimeout* OMTimerManager::findInList(IOxfEvent::ID id, const IOxfReactive* c) const {
    //#[ operation findInList(ID,IOxfReactive) const 
    OMIterator<IOxfTimeout*> it(matured);
    while (*it) {
    	IOxfTimeout* t = (*it);
    	if (t->getDestination()==c) {
    		short itsId = static_cast<OMTimeout*>(t)->getTimeoutId();
    		if ((itsId == id) || (id == OMAnyEventId)) {
    			return t;
    		}
    	}
    	++it; //NOTE!!! leave this here since pSOS compiler does not accept 
    		  //        incrementing iter within the for statemant.
    }
    return NULL;
    //#]
}

OxfTimeUnit OMTimerManager::getElapsedTime() const {
    //#[ operation getElapsedTime() const 
    return time_;
    //#]
}

OMTimerManager* OMTimerManager::getStaticTimerManager() {
    //#[ operation getStaticTimerManager() 
    return getStaticTimerManager(1,0,true);
    //#]
}

OMTimerManager* OMTimerManager::getStaticTimerManager(OxfTimeUnit tickTime, unsigned int maxTM, bool isRealTimeModel, 
bool forceInitialization) {
    //#[ operation getStaticTimerManager(OxfTimeUnit,unsigned int,bool,bool) 
    static bool initialized = false;
    if (!timerManagerSingletonDestroyed && 
    	(initialized || forceInitialization))
    {
    	// the timer manager static instance is already initialized (and was not destroyed) or -
    	// the parameter for the timer manager initialization are valid
    	initialized = true;
    	// the memory manager static instance
    	static OMTimerManager theTimerManager(tickTime, maxTM, isRealTimeModel);
    	initTimeoutsMemoryPool();
    
    #ifdef _OMINSTRUMENT
    	AnimServices::registerAnimTimerManager(&theTimerManager);
    #endif
    
    	return &theTimerManager;
    }
    // the timer manager static instance was not initialized yet, and -
    // the initialization parameters are not valid
    return 0;
    //#]
}

void OMTimerManager::goNext() {
    //#[ operation goNext() 
    // Check for expired timeouts 
    if (!timeouts.isEmpty())
    {
    	// Advance to next relevant time
    	time_ = timeouts.top()->getDueTime();
    }
    //#]
}

void OMTimerManager::goNextAndPost() {
    //#[ operation goNextAndPost() 
    // Advance to the next timeout and post it
    lock(); // critical section for the timeouts structure
    goNext();
    unlock();
    post();	// Handle that time event
    //#]
}

void OMTimerManager::init() {
    //#[ operation init() 
    // initialize the guard
    guard = OMOSFactory::instance()->createOMOSMutex();
    // reset the idle thread counter
    nonIdleThreadCounter = 0;
    // get the user timer factory
    const IOxfTickTimerFactory* timerFactory = OXF::getTheTickTimerFactory();
    // create the timer
    if (realTimeModel)
    {
    	if (timerFactory)
    	{
    		// user timer
    		tickTimer = timerFactory->createRealTimeTimer(tick,cbkBridge,this);
    	}
    	else
    	{
    		// the system timer
    		tickTimer = OMOSFactory::instance()->createOMOSTickTimer(tick,cbkBridge,this);
    	}
    }
    else
    {
    	// In case of simulated time this task is an idle task called when all other tasks are Blocked
    	if (timerFactory)
    	{
    		// user timer
    		tickTimer = timerFactory->createSimulatedTimeTimer(cbkBridge,this);
    	}
    	else
    	{
    		tickTimer = OMOSFactory::instance()->createOMOSIdleTimer(cbkBridge,this);
    	}
    }
    //#]
}

OMTimerManager* OMTimerManager::initInstance(OxfTimeUnit ticktime, unsigned int maxTM, bool isRealTimeModel) {
    //#[ operation initInstance(OxfTimeUnit,unsigned int,bool) 
    static bool initialized = false;
    if (!initialized)
    {
    	initialized = true;
    	OMTimerManager* timerManager = getStaticTimerManager(ticktime,maxTM,isRealTimeModel, true);
    	if (timerManager != NULL)
    	{
    		timerManager->init();
    	}
    	return timerManager;
    }
    // was initialized
    return NULL;
    //#]
}

void OMTimerManager::initTimeoutsMemoryPool() {
    //#[ operation initTimeoutsMemoryPool() 
    static bool timeoutsMemoryInitialized = false;
    if (!timeoutsMemoryInitialized)
    {
    	// do once
    	timeoutsMemoryInitialized = true;
    	// create a dummy timeout in order to force the allocation of timeouts memory pool
    	OMTimeout::OMCallMemoryPoolIsEmpty(false); // avoid Message to the user 
    	OMTimeout* dummy = new OMTimeout;
    	delete dummy;
    	OMTimeout::OMCallMemoryPoolIsEmpty(true);
    }
    //#]
}

OMTimerManager* OMTimerManager::instance() {
    //#[ operation instance() 
    return getStaticTimerManager();
    //#]
}

bool OMTimerManager::isHeapFull() const {
    //#[ operation isHeapFull() const 
    if(timeouts.getCount()+1 >= timeouts.getHeapSize())
    	return true;
    else
    	return false;
    //#]
}

void OMTimerManager::lock() {
    //#[ operation lock() 
    if (guard)
    {
    	guard->lock();
    }
    //#]
}


//#[ ignore 
/*
//#]
OMTimerManager& OMTimerManager::operator=(const OMTimerManager& other) {
    //#[ operation operator=(OMTimerManager) 
    //#]
}

//#[ ignore 

*/
//#]

void OMTimerManager::post() {
    //#[ operation post() 
    // Note post() must always be within the "lock" of OMTimerManager
    ///////////////////////////
    // begin critical section
    ///////////////////////////
    lock();
    ///////////////////////////
    while (!timeouts.isEmpty())
    {
    	IOxfTimeout* timeout = timeouts.top();
    	if (time_ < timeout->getDueTime())
    	{
    		// no ready timeouts
    		break;
    	}
    	
    	if (timeout->isCanceled())
    	{
    		// destroy the canceled timeout
    		timeout->destroy();
    	}
    	else
    	{
    		// send the timeout
    		if (OXF::getRhp5CompatibleAPI())
    		{
    			// compatibility mode
    			action(static_cast<OMTimeout*>(timeout));
    		}
    		else
    		{
    			// normal mode
    			action(timeout);
    		}
    	}
    	timeouts.trim(); // trim the timeout
    }
    // checking if the time counter overflowed
    if (time_ >= overflowMark)
    {
    	resetTimeoutsDueTime();
    }
    ///////////////////////////
    // end critical section
    ///////////////////////////
    unlock();
    ///////////////////////////
    //#]
}

void OMTimerManager::requestTimeNotification(IOxfReactive* reactive, const OxfTimeUnit deltaT, IOxfTimeout*& timeout, 
OxfTimeUnit& baseTime) {
    //#[ operation requestTimeNotification(IOxfReactive*,const OxfTimeUnit,IOxfTimeout*&,OxfTimeUnit&) 
    
    if (isHeapFull())
    	(void)cleanupCanceledTimeouts();
    
    timeout = (IOxfTimeout*)(new OMTimeout(reactive, deltaT, NULL));
    (void)set(timeout);
    baseTime = getElapsedTime();
    
    //#]
}

void OMTimerManager::resetTimeoutsDueTime() {
    //#[ operation resetTimeoutsDueTime() 
    // iterate over the timeouts and update the triggered timeouts
    OMIterator<IOxfTimeout> iter(timeouts);
    while(&iter.value() != &OMNullValue<IOxfTimeout>::get())
    {
    	IOxfTimeout& curr = *iter;
    	OxfTimeUnit currDueTime = curr.getDueTime();
    	curr.setDueTime(currDueTime & ~overflowMark);
    	++iter;
    }
    // update the timer counter
    time_ &= ~overflowMark;
    //#]
}

bool OMTimerManager::set(IOxfTimeout* timeout) {
    //#[ operation set(IOxfTimeout) 
    // critical section for the timeouts structure
    lock();
    setTimeoutDueTime(timeout);
    bool res = timeouts.add(timeout);
    unlock();
    return res;
    //#]
}

void OMTimerManager::setElapsedTime(OxfTimeUnit newTime) {
    //#[ operation setElapsedTime(OxfTimeUnit) 
    lock(); 
    time_ = newTime & ~overflowMark ;
    unlock();
    //#]
}

void OMTimerManager::setTimeoutDueTime(IOxfTimeout* timeout) const {
    //#[ operation setTimeoutDueTime(IOxfTimeout) const 
    if (timeout != NULL)
    {
    	timeout->setDueTime(timeout->getDelayTime() + time_);
    }
    //#]
}

void OMTimerManager::softUnschedTm(OMTimeout* timeout) {
    //#[ operation softUnschedTm(OMTimeout) 
    // critical section	for the timeouts structure
    lock();
    matured.remove(timeout);
    // critical section	for the timeouts structure
    unlock();
    //#]
}

void OMTimerManager::suspend() {
    //#[ operation suspend() 
    suspended = true; 
    //#]
}

void OMTimerManager::timeTickCbk() {
    //#[ operation timeTickCbk() 
    #ifdef _OMINSTRUMENT 
    // This code ensures the timer will not advance during
    // the "user's turn" in animation/trace
    // This is done by not advancing the time_ so the timer
    // keeps ticking but never advances (until resume)
    // For simulated time, in effect, this is a "busy wait".
    if (suspended)
    {
    	return;
    }
    #endif // _OMINSTRUMENT
    
    lock(); // critical section for the timeouts structure
    if (realTimeModel)
    {
    	time_ += tick ;
    }
    else 
    {
    	// simulated time
    	// The purpose of the following condition is to ensure that
    	// all threads are idle and not just rely on the priority
    	// of the threads (NT scheduling policy may cause scheduling 
    	// of low priority threads).
    	// In some cases, when using guarded operations with simulated 
    	// time, one may consider to remove this condition.
    	if (nonIdleThreadCounter == 0)
    	{
    		goNext();
    	}
    }
    
    unlock();
    post();	// Handle that time event
    //#]
}

void OMTimerManager::unlock() {
    //#[ operation unlock() 
    if (guard) {
    	guard->unlock();
    }
    //#]
}

void OMTimerManager::unschedTm(IOxfEvent::ID id, IOxfReactive* c) {
    //#[ operation unschedTm(ID,IOxfReactive) 
    if (c == NULL)
    {
    	return;
    }
    
    lock(); // critical section	for the timeouts structure
    
    IOxfEvent* ev = c->getCurrentEvent();
    IOxfTimeout* tm = NULL;
    if ((ev != NULL) && ev->getId() == OMTimeoutEventId)
    {
    	tm = static_cast<IOxfTimeout*>(ev);
    }
    if (id == OMAnyEventId)
    {
    	// this is the current event being processed,
    	// so we just need to take it out of bookkeeping list
    	if ((tm != NULL) && (static_cast<OMTimeout*>(tm)->getTimeoutId() == id))
    	{
    		tm->cancel();
    		matured.remove(tm);
    	}
    
    	// create a dummy "wildcard" timeout 
    	// Timeout clone(id, c, 0, NULL);
    	OMTimeout clone;  
    	clone.setTimeoutId(id);
    	clone.setDestination(c);
    #ifdef _OMINSTRUMENT
    	clone.setState(NULL);
    #endif
    	// remove events from the timeouts
    	IOxfTimeout* timeout = NULL;
    	while ((timeout = timeouts.remove(&clone)) != NULL)
    	{
    #ifdef _OMINSTRUMENT
    		// notify the user of this cancellation
    		AnimServices::notifyTimeoutCancelled(timeout);
    #endif
    		timeout->destroy();
    	}
    
    	// there might be events on the list, too
    
    	while ((timeout = findInList(id,c)) != NULL)
    	{
    		timeout->cancel(); // Mark as cancelled
    		matured.remove(timeout);
    #ifdef _OMINSTRUMENT
    		// notify the user of this cancellation
    		AnimServices::notifyTimeoutCancelled(timeout);
    #endif
    	}
    }
    else
    {
    	// we should look for a specific timeout
    	// this is the current event being processed,
    	// so we just need to take it out of bookkeeping list
    	if ((tm != NULL)  && (static_cast<OMTimeout*>(tm)->getTimeoutId() == id))
    	{
    		tm->cancel();
    		matured.remove(tm);
    	}
    	else
    	{
    		// Search in timeouts, if found - remove from timeouts
    		// create a dummy "wildcard" timeout 
    		// Timeout clone(id, c, 0, NULL);
    		OMTimeout clone;  
    		clone.setTimeoutId(id);
    		clone.setDestination(c);
    #ifdef _OMINSTRUMENT
    		clone.setState(NULL);
    #endif
    		// remove events from the timeouts
    		IOxfTimeout* timeout = timeouts.remove(&clone);
    		bool wasInHeap  = (timeout != NULL);
    
    		if (!wasInHeap)
    		{ // Search in list
    			timeout = findInList(id,c);
    			if (timeout != NULL)
    			{
    				timeout->cancel(); // Mark as cancelled
    				matured.remove(timeout);
    			}
    		}
    #ifdef _OMINSTRUMENT
    		// notify the user of this cancellation
    		AnimServices::notifyTimeoutCancelled(timeout);
    #endif
    		// Delete timeout only if it was found in the timeouts
    		if (timeout && wasInHeap)
    		{
    			timeout->destroy();
    		}
    	}
    }
    unlock(); // critical section	for the timeouts structure
    //#]
}

OxfTimeUnit OMTimerManager::getTick() const {
    return tick;
}

long OMTimerManager::getNonIdleThreadCounter() const {
    return nonIdleThreadCounter;
}

bool OMTimerManager::getRealTimeModel() const {
    return realTimeModel;
}



//
//! Log: $Log: OMTimerManager.cpp $
//! Log: Revision 1.37  2007/06/19 11:48:55  ilelpa
//! Log: fixed lint
//


