//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMMemoryManagerSwitchHelperImpl
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMMemoryManagerSwitchHelperImpl.cpp $
//!	File version	: $Revision: 1.19 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:45 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMMemoryManagerSwitchHelperImpl.cpp 1.19 2007/04/06 07:07:45 ilgiga Exp $";
#endif
//#]

#include "OMMemoryManagerSwitchHelperImpl.h"
#ifdef _OMINSTRUMENT
#include "OXFNotifyMacros.h"

#endif // _OMINSTRUMENT
//----------------------------------------------------------------------------
// OMMemoryManagerSwitchHelperImpl.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Services::MemoryManagement::Manager 

//## class OMMemoryManagerSwitchHelperImpl 


//#[ ignore 
#if (!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]


void OMMemoryManagerSwitchHelperImpl::cleanup() {
    //#[ operation cleanup() 
    Node* current = _recordedMemory;
    while (current != NULL) {
    	Node* next = current->next;
    	delete current;
    	current = next;
    }
    _recordedMemory = NULL;
    //#]
}

bool OMMemoryManagerSwitchHelperImpl::findMemory(const void * memory) const {
    //#[ operation findMemory(void *) const 
    Node* current = _recordedMemory;
    // find the node
    while (current != NULL) {
    	if (current->allocatedMemory == memory) {
    		return true;
    	}
    	current = current->next;
    }
    return false;
    //#]
}

OMMemoryManagerSwitchHelperImpl* OMMemoryManagerSwitchHelperImpl::instance() {
    //#[ operation instance() 
    static OMMemoryManagerSwitchHelperImpl impl;
    return &impl;
    //#]
}

bool OMMemoryManagerSwitchHelperImpl::recordMemoryAllocation(const void * memory) {
    //#[ operation recordMemoryAllocation(void *) 
    Node* node = new Node(memory, _recordedMemory);
    assert (node != NULL);
    if (node != NULL) {		//lint !e774 (Boolean within 'if' always evaluates to True)
    	_recordedMemory = node;
    }
    return (node != NULL);
    //#]
}

bool OMMemoryManagerSwitchHelperImpl::recordMemoryDeallocation(const void * memory) {
    //#[ operation recordMemoryDeallocation(void *) 
    bool found = false;
    Node* prev = NULL;
    Node* current = _recordedMemory;
    // find the node
    while ((current != NULL) && (!found)) {
    	if (current->allocatedMemory == memory) {
    		found = true;
    	}
    	else {
    		prev = current;
    		current = current->next;
    	}
    }
    // remove the node
    // lint fail to see that the while condition potect from an option where 'current' is NULL
    //lint -save -e613 (Possible use of null pointer 'current' in left argument to operator '->')
    if (found) {
    	// first element
    	if (prev == NULL) {
    		_recordedMemory = current->next;
    	}
    	else {
    		// not the first element
    		prev->next = current->next;
    	}
    	delete current;
    }
    //lint -restore
    return found;
    //#]
}

bool OMMemoryManagerSwitchHelperImpl::shouldUpdate() const {
    return shouldUpdateLog;
}

void OMMemoryManagerSwitchHelperImpl::setUpdateState(bool p_shouldUpdateLog) {
    shouldUpdateLog = p_shouldUpdateLog;
}

void OMMemoryManagerSwitchHelperImpl::cleanUpRelations() {
    if(_recordedMemory != 0)
        {
            _recordedMemory = 0;
        }
}


//## class OMMemoryManagerSwitchHelperImpl::Node 

IMPLEMENT_MEMORY_ALLOCATOR(OMMemoryManagerSwitchHelperImpl::Node, OM_MEMORY_MANAGER_SWITCH_HELPER_POOL_SIZE, 0, false)


OMMemoryManagerSwitchHelperImpl::Node::Node(const void * mem, Node* nextNode) : 
OMMemoryPoolNextChunk(0), allocatedMemory(mem), next(nextNode) {
    //#[ operation Node(void *,Node*) 
    //#]
}

OMMemoryManagerSwitchHelperImpl::Node::Node() : OMMemoryPoolNextChunk(0), allocatedMemory(0), next(0) {
    //#[ operation Node() 
    static bool wasCalled = false;
    if (!wasCalled) {
    	wasCalled = true;
    	OMCallMemoryPoolIsEmpty(FALSE);
    	OMSetMemoryAllocator(outOfMemoryAssert);
    }
    //#]
}

OMMemoryManagerSwitchHelperImpl::Node::~Node() {
    cleanUpRelations();
}

const void * OMMemoryManagerSwitchHelperImpl::Node::getAllocatedMemory() const {
    return allocatedMemory;
}

OMMemoryManagerSwitchHelperImpl::Node* OMMemoryManagerSwitchHelperImpl::Node::getNext() const {
    return next;
}

void OMMemoryManagerSwitchHelperImpl::Node::setNext(OMMemoryManagerSwitchHelperImpl::Node* p_Node) {
    next = p_Node;
}

void OMMemoryManagerSwitchHelperImpl::Node::cleanUpRelations() {
    if(next != 0)
        {
            next = 0;
        }
}


//#[ ignore 

#endif //(!defined(OM_NO_FRAMEWORK_MEMORY_MANAGER) && !defined(OMOMATE))
//#]



//
//! Log: $Log: OMMemoryManagerSwitchHelperImpl.cpp $
//! Log: Revision 1.19  2007/04/06 07:07:45  ilgiga
//! Log: bug fix 98191
//


