//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMHandleCloser
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMHandleCloser.h $
//!	File version	: $Revision: 1.19 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:43 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef OMHandleCloser_H 

#define OMHandleCloser_H 

#include "omreactive.h"
#include "omthread.h"

//----------------------------------------------------------------------------
// OMHandleCloser.h                                                                  
//----------------------------------------------------------------------------

class AnimServices;
class IOxfActive;
class IOxfEvent;
class OMAnimReactive;
class OMComponentState;
class OMEvent;
class OMMainThread;
class OMOS;
class OMOSThread;
class OMProtected;
class OMTimeout;
class OMTimerManager;
class OXF;

//## package Design::oxf::Services::ResourceManagement 


// Provide mechanism for cleanup after thread deletion
//## class OMHandleCloser 
class RP_FRAMEWORK_DLL OMHandleCloser : public OMReactive {
public :
    //#[ ignore 
    // The RTOS callback function that perform the RTOS thread cleanup
    typedef void  (* closeHandleFunc)(void * ) ;
    //#]
    
    

//#[ ignore 
// override new & delete operators
OM_DECLARE_FRAMEWORK_MEMORY_ALLOCATION_OPERATORS

//#]

////    Constructors and destructors    ////
public :
    
    // Initialize
    // Argument closeHandleFunc doCloseHandlePtr : 
    // The callback
    //## operation OMHandleCloser(closeHandleFunc) 
    OMHandleCloser(closeHandleFunc doCloseHandlePtr = 0);
    
    // Cleanup
    //## operation ~OMHandleCloser() 
    virtual ~OMHandleCloser();

private :
    
    // disable copy constructor
    // Argument const OMHandleCloser& other : 
    // unused
    //## operation OMHandleCloser(OMHandleCloser) 
    OMHandleCloser(const OMHandleCloser& other);


////    Operations    ////
public :
    
    // sends event to the HandleCloser thread to delete hObject thread
    // Argument void * hObject : 
    // The RTOS thread handle
    //## operation genCloseEvent(void *) 
    void genCloseEvent(void * hObject);
    
    // Get the internal thread
    //## operation getThread() const 
    OMThread* getThread() const;
    
    // Get the singleton
    //## operation instance() 
    static OMHandleCloser* instance();
    
    // returns handle closer instance and initializes its doCloseHandle function ptr
    // Argument closeHandleFunc doCloseHandlePtr : 
    // The callback
    //## operation instance(closeHandleFunc) 
    static OMHandleCloser* instance(closeHandleFunc doCloseHandlePtr);
    
    // Send the OMCloseHandleEvent to itself
    //## operation sendCloseHandleCloserEvent() 
    void sendCloseHandleCloserEvent();
    
    // Start the statechart
    //## operation startBehavior() 
    virtual bool startBehavior();

private :
    
    // Initialize and get the singleton
    // Argument closeHandleFunc doCloseHandlePtr : 
    // The callback
    //## operation getInstance(closeHandleFunc) 
    static OMHandleCloser &  getInstance(closeHandleFunc doCloseHandlePtr);
    
    // disable assignment operator
    // Argument const OMHandleCloser& other : 
    // unused
    //## operation operator=(OMHandleCloser) 
    OMHandleCloser& operator=(const OMHandleCloser& other);


////    Framework operations    ////
public :
    
    //OMCloseHandleEvent(void *);
    
    //rootState:
    
    //## statechart_method 
    inline bool rootState_IN() const;
    
    //## statechart_method 
    virtual void rootState_entDef();
    
    //## statechart_method 
    virtual IOxfReactive::TakeEventStatus rootState_processEvent();
    
    //ready:
    
    //## statechart_method 
    inline bool ready_IN() const;

protected :
    
    //## auto_generated 
    void initStatechart();


////    Attributes    ////
private :
    
    // Indicate that the singleton was destroyed (while exit())
    static bool _singletonDestroyed;		//## attribute _singletonDestroyed 
    
    // The cleanup callback function
    closeHandleFunc doCloseHandle;		//## attribute doCloseHandle 
    

////    Relations and components    ////
private :
    
    // The handle closer context
    OMThread thread;		//## classInstance thread 
    


////    Framework    ////
protected :
    
    //#[ ignore 
    //states enumeration: 
    enum OMHandleCloser_Enum{ OMNonState=0, ready=1 };
    //#]
    
    int rootState_subState;		//## ignore 
    
    
    int rootState_active;		//## ignore 
    

};
//---------------------------------------------------------------------------- 
// inline operations for OMHandleCloser
//---------------------------------------------------------------------------- 

inline bool OMHandleCloser::rootState_IN() const {
    return true;
}

inline bool OMHandleCloser::ready_IN() const {
    return rootState_subState == ready;
}



#endif  
//
//! Log: $Log: OMHandleCloser.h $
//! Log: Revision 1.19  2007/04/06 07:07:43  ilgiga
//! Log: bug fix 98191
//


