//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMEvent
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMEvent.cpp $
//!	File version	: $Revision: 1.23 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:41 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMEvent.cpp 1.23 2007/04/06 07:07:41 ilgiga Exp $";
#endif
//#]

#include "OMEvent.h"

//#[ ignore 
#ifdef _OMINSTRUMENT
//#]
#include <aom/AnimServices.h>

//#[ ignore 
#endif //_OMINSTRUMENT
//#]
#include "OXFEvents.h"
#include "IOxfReactive.h"

//----------------------------------------------------------------------------
// OMEvent.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Core::CoreImplementation 

//## class OMEvent 



OMEvent::OMEvent(IOxfEvent::ID eventId, IOxfReactive* dest) : lId(eventId) ,deleteAfterConsume(true) ,frameworkEvent(
false) ,port(0) ,synchronous(false) ,destination(dest) {
    //#[ operation OMEvent(ID,IOxfReactive) 
    //#]
}

OMEvent::OMEvent(const OMEvent& ev) : 
lId(ev.lId), deleteAfterConsume(ev.deleteAfterConsume), frameworkEvent(ev.frameworkEvent), port(ev.port), synchronous(ev.synchronous), destination(ev.destination)
 {
    //#[ operation OMEvent(OMEvent) 
    //#]
}

OMEvent::~OMEvent() {
    //#[ operation ~OMEvent() 
    #ifdef _OMINSTRUMENT
    AnimServices::notifyEventDestroyed(this);
    #endif
    //#]
    cleanUpRelations();
}

void OMEvent::Delete() {
    //#[ operation Delete() 
    destroy();
    //#]
}

void OMEvent::cancel() {
    //#[ operation cancel() 
    //#]
}

void OMEvent::destroy() {
    //#[ operation destroy() 
    if (shouldDeleteAfterConsume()) {
    	delete this;
    }
    //#]
}

OxfTimeUnit OMEvent::getDelayTime() const {
    //#[ operation getDelayTime() const 
    return 0;
    //#]
}

OxfTimeUnit OMEvent::getDueTime() const {
    //#[ operation getDueTime() const 
    return 0;
    //#]
}

bool OMEvent::isCanceled() const {
    //#[ operation isCanceled() const 
    return false;
    //#]
}

bool OMEvent::isRealEvent() const {
    //#[ operation isRealEvent() const 
    return (lId >= OMTimeoutEventId);
    //#]
}

OMEvent& OMEvent::operator =(const OMEvent& ev) {
    //#[ operation operator =(OMEvent) 
    lId = ev.lId;
    deleteAfterConsume = ev.deleteAfterConsume;
    frameworkEvent = ev.frameworkEvent;
    port = ev.port;
    synchronous = ev.synchronous;
    destination = ev.destination;
    return *this;
    //#]
}

void OMEvent::setDelayTime(OxfTimeUnit /**/) {
    //#[ operation setDelayTime(OxfTimeUnit) 
    //#]
}

void OMEvent::setDueTime(OxfTimeUnit /**/) {
    //#[ operation setDueTime(OxfTimeUnit) 
    //#]
}

bool OMEvent::shouldDeleteAfterConsume() const {
    return deleteAfterConsume;
}

void OMEvent::setDeleteAfterConsume(bool p_deleteAfterConsume) {
    deleteAfterConsume = p_deleteAfterConsume;
}

bool OMEvent::isFrameworkEvent() const {
    return frameworkEvent;
}

void OMEvent::setFrameworkEvent(bool p_frameworkEvent) {
    frameworkEvent = p_frameworkEvent;
}

void * OMEvent::getPort() const {
    return port;
}

void OMEvent::setPort(void * p_port) {
    port = p_port;
}

bool OMEvent::getSynchronous() const {
    return synchronous;
}

void OMEvent::setSynchronous(bool p_synchronous) {
    synchronous = p_synchronous;
}

IOxfReactive* OMEvent::getDestination() const {
    return destination;
}

void OMEvent::setDestination(IOxfReactive* p_IOxfReactive) {
    destination = p_IOxfReactive;
}

void OMEvent::cleanUpRelations() {
    if(destination != 0)
        {
            destination = 0;
        }
}



//
//! Log: $Log: OMEvent.cpp $
//! Log: Revision 1.23  2007/04/06 07:07:41  ilgiga
//! Log: bug fix 98191
//


