//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: OMAnimHelper
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/OMAnimHelper.cpp $
//!	File version	: $Revision: 1.9 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:35 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//
//#[ ignore
#if ((!defined lint) && (!defined OM_NO_RCS_ID))
static const char* rcsid = "//! $Id: OMAnimHelper.cpp 1.9 2007/04/06 07:07:35 ilgiga Exp $";
#endif
//#]

#include "OMAnimHelper.h"
#include "OXFEvents.h"
#include "omstring.h"
#include "OMTimeout.h"
#include "OMUnicodeHelper.h"

//----------------------------------------------------------------------------
// OMAnimHelper.cpp                                                                  
//----------------------------------------------------------------------------

//## package Design::oxf::Anim::AnimImplementation 

//## class OMAnimHelper 


OMAnimHelper::~OMAnimHelper() {
}

void OMAnimHelper::fillDelaySignature(const OMTimeout* tm, OMString& signature) const {
    //#[ operation fillDelaySignature(OMTimeout,OMString) const 
    if (tm != 0)
    {
       	signature = "Thread Delay ";
    	fillTime(tm, signature);
    }
    //#]
}

void OMAnimHelper::fillTime(const OMTimeout* tm, OMString& str) const {
    //#[ operation fillTime(OMTimeout,OMString) const 
    OxfTimeUnit t = 0;
    if (tm != 0)
    {
    	t = tm->getDelayTime();
    }
    char c[30];
    #ifndef _OM_UNICODE_ONLY
    // simple characters
    sprintf(c, "tm(%lu)", t);
    #else
    // wide characters 
    wchar_t wC[30];
    swprintf(wC, L"tm(%lu)", t);
    (void) OMUnicodeHelper::wtoc(c,wC,30);
    #endif // _OM_UNICODE_ONLY
    str += c;
    //#]
}

void OMAnimHelper::fillTimeoutSignature(const OMTimeout* tm, OMString& signature) const {
    //#[ operation fillTimeoutSignature(OMTimeout,OMString) const 
    if (tm != 0)
    {
    	fillTime(tm, signature);
       	signature += " at ";
       	signature += tm->getState();
    }
    //#]
}

bool OMAnimHelper::getFrameworkEventClassName(const IOxfEvent* event, OMString& className, bool signatureFormat) const
 {
    //#[ operation getFrameworkEventClassName(IOxfEvent,OMString,bool) const 
    bool res = false;
    bool applySignatureFormat = true;
    className.Empty();
    if (event != 0)
    {
    	if (event->isTypeOf(OMStartBehaviorEventId))
    	{
    		className = "OMStartBehaviorEvent";
    		res = true;
    	}
    	else if (event->isTypeOf(OMTimeoutEventId))
    	{
    		className = "Timeout";
    		applySignatureFormat = false;
    		res = true;
    	}
    	else if (event->isTypeOf(OMTimeoutDelayId))
    	{
    		className = "OMDelay";
    		res = true;
    	}
    	else if ((event->getId() == OMAnimWakeupEventId) ||
    		(event->getId() == OMCloseHandleEventId) ||
    		(event->getId() == OMEndThreadEventId) ||
    		(event->getId() == OMReactiveTerminationEventId))
    	{
    		// invisible framework event
    		res = true;
    	}
    }
    // Signature Format
    if (res &&
    	applySignatureFormat &&
    	signatureFormat &&
    	!className.IsEmpty())
    {
    	// if 
    	//		The event is a framework event AND
    	// 		A signature format should ve applied to this event class AND
    	//		A signature format was requested AND
    	//		The class is animated (has a name)
    	className += "()";
    }
    return res;
    //#]
}

bool OMAnimHelper::getFrameworkEventSignature(const IOxfEvent* event, OMString& signature) const {
    //#[ operation getFrameworkEventSignature(IOxfEvent,OMString) const 
    bool res = false;
    signature.Empty();
    if (event != 0)
    {
    	if (event->isTypeOf(OMStartBehaviorEventId))
    	{
    		signature = "OMStartBehaviorEvent";
    		res = true;
    	}
    	else if (event->isTypeOf(OMTimeoutEventId))
    	{
    		fillTimeoutSignature(static_cast<const OMTimeout*>(event), signature);
    		res = true;
    	}
    	else if (event->isTypeOf(OMTimeoutDelayId))
    	{
    		fillDelaySignature(static_cast<const OMTimeout*>(event), signature);
    		res = true;
    	}
    	else if ((event->getId() == OMAnimWakeupEventId) ||
    		(event->getId() == OMCloseHandleEventId) ||
    		(event->getId() == OMEndThreadEventId) ||
    		(event->getId() == OMReactiveTerminationEventId))
    	{
    		// invisible framework event
    		res = true;
    	}
    }
    return res;
    //#]
}

OMAnimHelper* OMAnimHelper::instance() {
    //#[ operation instance() 
    static OMAnimHelper theHelper;
    return &theHelper;
    //#]
}

bool OMAnimHelper::isCancelledEvent(const IOxfEvent* ev) const {
    //#[ operation isCancelledEvent(IOxfEvent) const 
    bool res = false;
    if (ev != 0)
    {
    	if (ev->isTypeOf(OMTimeoutEventId))
    	{
    		res = static_cast<const IOxfTimeout*>(ev)->isCanceled();
    	}
    	else
    	{
    		res = (ev->getId() == OMCancelledEventId);
    	}
    }
    return res;
    //#]
}

bool OMAnimHelper::isTimeoutEvent(const IOxfEvent* ev) const {
    //#[ operation isTimeoutEvent(IOxfEvent) const 
    return ((ev != 0) &&
    		(ev->isTypeOf(OMTimeoutEventId)));
    //#]
}



//
//! Log: $Log: OMAnimHelper.cpp $
//! Log: Revision 1.9  2007/04/06 07:07:35  ilgiga
//! Log: bug fix 98191
//


