//	Rhapsody		: 7.1 
//	Component		: oxfFiles 
//	Configuration 	: generic
//	Model Element	: IOxfAnimHelper
//!	File name		: $Source: R:/StmOO/Master/cg/LangCpp/oxf/rcs/IOxfAnimHelper.h $
//!	File version	: $Revision: 1.8 $
//
//!	Date changed	: $Date: 2007/04/06 07:07:27 $
//!	Last change by	: $Author: ilgiga $
//
//	(c) Copyright Telelogic 2004, 2007
//



#ifndef IOxfAnimHelper_H 

#define IOxfAnimHelper_H 

#include "rp_framework_dll_definition.h"

//----------------------------------------------------------------------------
// IOxfAnimHelper.h                                                                  
//----------------------------------------------------------------------------

class IOxfEvent;
class OMString;

//## package Design::oxf::Anim::AnimAPI 


// An animation helper interface a singleton helper class that provides animation with a set of services
//## class IOxfAnimHelper 
class RP_FRAMEWORK_DLL IOxfAnimHelper  {


////    Constructors and destructors    ////
public :
    
    // Cleanup
    //## operation ~IOxfAnimHelper() 
    virtual ~IOxfAnimHelper() {
        //#[ operation ~IOxfAnimHelper() 
        //#]
    }
    


////    Operations    ////
public :
    
    // The operation will return false and an empty string for user events, and the event class name for animated 
    // internal framework events (e.g. start behavior, timeouts)
    // Returns true if the event was handled (invisible framework events should return true and with an empty 
    // signature)
    // Argument const IOxfEvent* event : 
    // the event to get the signature for
    // Argument OMString& className : 
    // The specified event animation signature
    // Argument bool signatureFormat : 
    // Specify that the class name should be return in a signature format i.e. <class>()
    //## operation getFrameworkEventClassName(IOxfEvent,OMString,bool) const 
    virtual bool getFrameworkEventClassName(const IOxfEvent* event, OMString& className, bool signatureFormat = false)
     const=0;
    
    // The operation will return false and empty string for user events, and the event signature for animated internal 
    // framework events (e.g. start behavior, timeouts)
    // Returns true if the event was handled (invisible framework events should return true and with an empty 
    // signature)
    // Argument const IOxfEvent* event : 
    // the event to get the signature for
    // Argument OMString& signature : 
    // The specified event animation signature
    //## operation getFrameworkEventSignature(IOxfEvent,OMString) const 
    virtual bool getFrameworkEventSignature(const IOxfEvent* event, OMString& signature) const=0;
    
    // Return true if the provided event is cancelled
    // Argument const IOxfEvent* ev : 
    // the event
    //## operation isCancelledEvent(IOxfEvent) const 
    virtual bool isCancelledEvent(const IOxfEvent* ev) const=0;
    
    // Return true if the provided event is a timeout
    // Argument const IOxfEvent* ev : 
    // the event
    //## operation isTimeoutEvent(IOxfEvent) const 
    virtual bool isTimeoutEvent(const IOxfEvent* ev) const=0;


};


#endif  
//
//! Log: $Log: IOxfAnimHelper.h $
//! Log: Revision 1.8  2007/04/06 07:07:27  ilgiga
//! Log: bug fix 98191
//


